/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade.rest;

import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.tasks.LoggingTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeAction;

public class RestIndexUpgradeAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestIndexUpgradeAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    public RestIndexUpgradeAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "_xpack/migration/upgrade/{index}", (RestHandler)this, "[_xpack/migration/upgrade] is deprecated. Use the Kibana Upgrade Assistant or the Reindex API instead.", deprecationLogger);
    }

    public String getName() {
        return "xpack_migration_upgrade";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method().equals((Object)RestRequest.Method.POST)) {
            return this.handlePost(request, client);
        }
        throw new IllegalArgumentException("illegal method [" + request.method() + "] for request [" + request.path() + "]");
    }

    private BaseRestHandler.RestChannelConsumer handlePost(RestRequest request, NodeClient client) {
        IndexUpgradeAction.Request upgradeRequest = new IndexUpgradeAction.Request(request.param("index"));
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("include_created", Boolean.toString(true));
        params.put("include_updated", Boolean.toString(true));
        if (request.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.execute((Action)IndexUpgradeAction.INSTANCE, (ActionRequest)upgradeRequest, (ActionListener)new RestBuilderListener<BulkByScrollResponse>(channel){

                public RestResponse buildResponse(BulkByScrollResponse response, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    response.toXContent(builder, (ToXContent.Params)new ToXContent.DelegatingMapParams(params, (ToXContent.Params)this.channel.request()));
                    builder.endObject();
                    return new BytesRestResponse(this.getStatus(response), builder);
                }

                private RestStatus getStatus(BulkByScrollResponse response) {
                    RestStatus status = RestStatus.OK;
                    if (response.isTimedOut()) {
                        status = RestStatus.REQUEST_TIMEOUT;
                    }
                    for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
                        if (failure.getStatus().getStatus() <= status.getStatus()) continue;
                        status = failure.getStatus();
                    }
                    for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
                        RestStatus failureStatus = ExceptionsHelper.status((Throwable)failure.getReason());
                        if (failureStatus.getStatus() <= status.getStatus()) continue;
                        status = failureStatus;
                    }
                    return status;
                }
            });
        }
        upgradeRequest.setShouldStoreResult(true);
        ActionRequestValidationException validationException = upgradeRequest.validate();
        if (validationException != null) {
            throw validationException;
        }
        Task task = client.executeLocally((GenericAction)IndexUpgradeAction.INSTANCE, (ActionRequest)upgradeRequest, LoggingTaskListener.instance());
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", client.getLocalNodeId() + ":" + task.getId());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
        };
    }
}

