/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordResponse;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportChangePasswordAction
extends HandledTransportAction<ChangePasswordRequest, ChangePasswordResponse> {
    private final Settings settings;
    private final NativeUsersStore nativeUsersStore;

    @Inject
    public TransportChangePasswordAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeUsersStore nativeUsersStore) {
        super(settings, "cluster:admin/xpack/security/user/change_password", threadPool, transportService, actionFilters, indexNameExpressionResolver, ChangePasswordRequest::new);
        this.settings = settings;
        this.nativeUsersStore = nativeUsersStore;
    }

    protected void doExecute(ChangePasswordRequest request, final ActionListener<ChangePasswordResponse> listener) {
        String configPwdHashAlgo;
        String username = request.username();
        if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is anonymous and cannot be modified via the API"));
            return;
        }
        if ("_system".equals(username) || "_xpack".equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is internal"));
            return;
        }
        String requestPwdHashAlgo = Hasher.resolveFromHash((char[])request.passwordHash()).name();
        if (!requestPwdHashAlgo.equalsIgnoreCase(configPwdHashAlgo = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(this.settings))).name())) {
            listener.onFailure((Exception)new IllegalArgumentException("incorrect password hashing algorithm [" + requestPwdHashAlgo + "] used while [" + configPwdHashAlgo + "] is configured."));
            return;
        }
        this.nativeUsersStore.changePassword(request, new ActionListener<Void>(){

            public void onResponse(Void v) {
                listener.onResponse((Object)new ChangePasswordResponse());
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

