/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative.tool;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

final class HttpResponse {
    private final int httpStatus;
    private final Map<String, Object> responseBody;

    HttpResponse(int httpStatus, Map<String, Object> responseBody) {
        this.httpStatus = httpStatus;
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.putAll(responseBody);
        this.responseBody = Collections.unmodifiableMap(response);
    }

    int getHttpStatus() {
        return this.httpStatus;
    }

    Map<String, Object> getResponseBody() {
        return this.responseBody;
    }

    static class HttpResponseBuilder {
        private int httpStatus;
        private Map<String, Object> responseBody;

        HttpResponseBuilder() {
        }

        HttpResponseBuilder withHttpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        HttpResponseBuilder withResponseBody(String responseJson) throws ElasticsearchParseException, UnsupportedEncodingException {
            if (responseJson == null || responseJson.trim().isEmpty()) {
                throw new ElasticsearchParseException("Invalid string provided as http response body, Failed to parse content to form response body.", new Object[0]);
            }
            this.responseBody = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (String)responseJson, (boolean)false);
            return this;
        }

        HttpResponse build() {
            HttpResponse httpResponse = new HttpResponse(this.httpStatus, this.responseBody);
            return httpResponse;
        }
    }
}

