/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleType;
import org.elasticsearch.xpack.core.indexlifecycle.Phase;
import org.elasticsearch.xpack.core.indexlifecycle.UnfollowAction;

public class TimeseriesLifecycleType
implements LifecycleType {
    public static final TimeseriesLifecycleType INSTANCE = new TimeseriesLifecycleType();
    public static final String TYPE = "timeseries";
    static final List<String> VALID_PHASES = Arrays.asList("hot", "warm", "cold", "delete");
    static final List<String> ORDERED_VALID_HOT_ACTIONS = Arrays.asList("set_priority", "unfollow", "rollover");
    static final List<String> ORDERED_VALID_WARM_ACTIONS = Arrays.asList("set_priority", "unfollow", "readonly", "allocate", "shrink", "forcemerge");
    static final List<String> ORDERED_VALID_COLD_ACTIONS = Arrays.asList("set_priority", "unfollow", "allocate", "freeze");
    static final List<String> ORDERED_VALID_DELETE_ACTIONS = Arrays.asList("delete");
    static final Set<String> VALID_HOT_ACTIONS = Sets.newHashSet(ORDERED_VALID_HOT_ACTIONS);
    static final Set<String> VALID_WARM_ACTIONS = Sets.newHashSet(ORDERED_VALID_WARM_ACTIONS);
    static final Set<String> VALID_COLD_ACTIONS = Sets.newHashSet(ORDERED_VALID_COLD_ACTIONS);
    static final Set<String> VALID_DELETE_ACTIONS = Sets.newHashSet(ORDERED_VALID_DELETE_ACTIONS);
    private static Map<String, Set<String>> ALLOWED_ACTIONS = new HashMap<String, Set<String>>();

    private TimeseriesLifecycleType() {
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public List<Phase> getOrderedPhases(Map<String, Phase> phases) {
        ArrayList<Phase> orderedPhases = new ArrayList<Phase>(VALID_PHASES.size());
        for (String phaseName : VALID_PHASES) {
            Phase phase = phases.get(phaseName);
            if (phase == null) continue;
            Map<String, LifecycleAction> actions = phase.getActions();
            if (!actions.containsKey("unfollow") && (actions.containsKey("rollover") || actions.containsKey("shrink"))) {
                HashMap<String, LifecycleAction> actionMap = new HashMap<String, LifecycleAction>(phase.getActions());
                actionMap.put("unfollow", new UnfollowAction());
                phase = new Phase(phase.getName(), phase.getMinimumAge(), actionMap);
            }
            orderedPhases.add(phase);
        }
        return orderedPhases;
    }

    @Override
    public String getNextPhaseName(String currentPhaseName, Map<String, Phase> phases) {
        int index = VALID_PHASES.indexOf(currentPhaseName);
        if (index < 0 && !"new".equals(currentPhaseName)) {
            throw new IllegalArgumentException("[" + currentPhaseName + "] is not a valid phase for lifecycle type [" + TYPE + "]");
        }
        while (++index < VALID_PHASES.size()) {
            String phaseName = VALID_PHASES.get(index);
            if (!phases.containsKey(phaseName)) continue;
            return phaseName;
        }
        return null;
    }

    @Override
    public String getPreviousPhaseName(String currentPhaseName, Map<String, Phase> phases) {
        if ("new".equals(currentPhaseName)) {
            return null;
        }
        int index = VALID_PHASES.indexOf(currentPhaseName);
        if (index < 0) {
            throw new IllegalArgumentException("[" + currentPhaseName + "] is not a valid phase for lifecycle type [" + TYPE + "]");
        }
        while (--index >= 0) {
            String phaseName = VALID_PHASES.get(index);
            if (!phases.containsKey(phaseName)) continue;
            return phaseName;
        }
        return null;
    }

    @Override
    public List<LifecycleAction> getOrderedActions(Phase phase) {
        Map<String, LifecycleAction> actions = phase.getActions();
        switch (phase.getName()) {
            case "hot": {
                return ORDERED_VALID_HOT_ACTIONS.stream().map(a -> actions.getOrDefault(a, null)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case "warm": {
                return ORDERED_VALID_WARM_ACTIONS.stream().map(a -> actions.getOrDefault(a, null)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case "cold": {
                return ORDERED_VALID_COLD_ACTIONS.stream().map(a -> actions.getOrDefault(a, null)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case "delete": {
                return ORDERED_VALID_DELETE_ACTIONS.stream().map(a -> actions.getOrDefault(a, null)).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        throw new IllegalArgumentException("lifecycle type[timeseries] does not support phase[" + phase.getName() + "]");
    }

    @Override
    public String getNextActionName(String currentActionName, Phase phase) {
        List<String> orderedActionNames;
        switch (phase.getName()) {
            case "hot": {
                orderedActionNames = ORDERED_VALID_HOT_ACTIONS;
                break;
            }
            case "warm": {
                orderedActionNames = ORDERED_VALID_WARM_ACTIONS;
                break;
            }
            case "cold": {
                orderedActionNames = ORDERED_VALID_COLD_ACTIONS;
                break;
            }
            case "delete": {
                orderedActionNames = ORDERED_VALID_DELETE_ACTIONS;
                break;
            }
            default: {
                throw new IllegalArgumentException("lifecycle type[timeseries] does not support phase[" + phase.getName() + "]");
            }
        }
        int index = orderedActionNames.indexOf(currentActionName);
        if (index < 0) {
            throw new IllegalArgumentException("[" + currentActionName + "] is not a valid action for phase [" + phase.getName() + "] in lifecycle type [" + TYPE + "]");
        }
        while (++index < orderedActionNames.size()) {
            String actionName = orderedActionNames.get(index);
            if (!phase.getActions().containsKey(actionName)) continue;
            return actionName;
        }
        return null;
    }

    @Override
    public void validate(Collection<Phase> phases) {
        phases.forEach(phase -> {
            if (!ALLOWED_ACTIONS.containsKey(phase.getName())) {
                throw new IllegalArgumentException("Timeseries lifecycle does not support phase [" + phase.getName() + "]");
            }
            phase.getActions().forEach((actionName, action) -> {
                if (!ALLOWED_ACTIONS.get(phase.getName()).contains(actionName)) {
                    throw new IllegalArgumentException("invalid action [" + actionName + "] defined in phase [" + phase.getName() + "]");
                }
            });
        });
    }

    static {
        ALLOWED_ACTIONS.put("hot", VALID_HOT_ACTIONS);
        ALLOWED_ACTIONS.put("warm", VALID_WARM_ACTIONS);
        ALLOWED_ACTIONS.put("cold", VALID_COLD_ACTIONS);
        ALLOWED_ACTIONS.put("delete", VALID_DELETE_ACTIONS);
    }
}

