/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.action.TransportFreezeIndexAction;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public final class RestFreezeIndexAction
extends XPackRestHandler {
    public RestFreezeIndexAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_freeze", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_unfreeze", (RestHandler)this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) {
        boolean freeze = request.path().endsWith("/_freeze");
        TransportFreezeIndexAction.FreezeRequest freezeRequest = new TransportFreezeIndexAction.FreezeRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        freezeRequest.timeout(request.paramAsTime("timeout", freezeRequest.timeout()));
        freezeRequest.masterNodeTimeout(request.paramAsTime("master_timeout", freezeRequest.masterNodeTimeout()));
        freezeRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)freezeRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            freezeRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        freezeRequest.setFreeze(freeze);
        return channel -> client.freeze(freezeRequest, (ActionListener<TransportFreezeIndexAction.FreezeResponse>)new RestToXContentListener(channel));
    }

    public String getName() {
        return "freeze_index";
    }
}

