/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ConfirmationCallback
implements Callback,
Serializable {
    public static final int UNSPECIFIED_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int OK = 3;
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private String prompt;
    private int messageType;
    private int optionType;
    private int defaultOption;
    private String[] options;
    private int selection;

    private /* synthetic */ void finit$() {
        this.options = null;
    }

    public ConfirmationCallback(int messageType, int optionType, int defaultOption) throws IllegalArgumentException {
        this.finit$();
        this.setMessageType(messageType);
        this.setOptionType(optionType, defaultOption);
        this.defaultOption = defaultOption;
    }

    public ConfirmationCallback(int messageType, String[] options, int defaultOption) {
        this.finit$();
        this.setMessageType(messageType);
        this.setOptions(options, defaultOption);
        this.defaultOption = defaultOption;
    }

    public ConfirmationCallback(String prompt, int messageType, int optionType, int defaultOption) {
        this.finit$();
        this.setPrompt(prompt);
        this.setMessageType(messageType);
        this.setOptionType(optionType, defaultOption);
        this.defaultOption = defaultOption;
    }

    public ConfirmationCallback(String prompt, int messageType, String[] options, int defaultOption) {
        this.finit$();
        this.setPrompt(prompt);
        this.setMessageType(messageType);
        this.setOptions(options, defaultOption);
        this.defaultOption = defaultOption;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getOptionType() {
        if (this.options != null) {
            return -1;
        }
        return this.optionType;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public void setSelectedIndex(int selection) {
        if (this.options != null) {
            this.setOptions(this.options, selection);
        } else {
            this.setOptionType(this.optionType, selection);
        }
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    private void setMessageType(int messageType) throws IllegalArgumentException {
        switch (messageType) {
            case 0: 
            case 1: 
            case 2: {
                this.messageType = messageType;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal message type");
            }
        }
    }

    private void setOptionType(int optionType, int selectedOption) throws IllegalArgumentException {
        block0 : switch (optionType) {
            case 0: {
                this.optionType = optionType;
                switch (selectedOption) {
                    case 0: 
                    case 1: {
                        this.selection = selectedOption;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            case 1: {
                this.optionType = optionType;
                switch (selectedOption) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.selection = selectedOption;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            case 2: {
                this.optionType = optionType;
                switch (selectedOption) {
                    case 2: 
                    case 3: {
                        this.selection = selectedOption;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            default: {
                throw new IllegalArgumentException("illegal option type");
            }
        }
    }

    private void setOptions(String[] options, int selectedOption) throws IllegalArgumentException {
        if (selectedOption < 0 || selectedOption > options.length - 1) {
            throw new IllegalArgumentException("invalid selection");
        }
        if (options == null || options.length == 0) {
            throw new IllegalArgumentException("options is null or empty");
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i] != null && options[i].length() != 0) continue;
            throw new IllegalArgumentException("options[" + i + "] is null or empty");
        }
        this.options = options;
        this.selection = selectedOption;
    }

    private void setPrompt(String prompt) throws IllegalArgumentException {
        if (prompt == null || prompt.length() == 0) {
            throw new IllegalArgumentException("prompt is null or empty");
        }
        this.prompt = prompt;
    }
}

