/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.util.ArrayList;
import net.sf.gogui.utils.Histogram;
import net.sf.gogui.utils.Statistics;
import net.sf.gogui.utils.Table;

public final class TableUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean allEmpty(Table table, String string) {
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string2 = table.get(string, i);
            if (string2 == null || string2.trim().equals("")) continue;
            return false;
        }
        return true;
    }

    public static void appendRow(Table table, Table table2, int n) {
        if (!$assertionsDisabled && table.getNumberColumns() != table2.getNumberColumns()) {
            throw new AssertionError();
        }
        table.startRow();
        for (int i = 0; i < table.getNumberColumns(); ++i) {
            table.set(i, table2.get(i, n));
        }
    }

    public static int findRow(Table table, String string, String string2, String string3, String string4) {
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string5;
            String string6 = table.get(string, i);
            if (string6 == null || !string6.equals(string2) || (string5 = table.get(string3, i)) == null || !string5.equals(string4)) continue;
            return i;
        }
        return -1;
    }

    public static Table fromHistogram(Histogram histogram, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        arrayList.add("Count");
        Table table = new Table(arrayList);
        for (int i = 0; i < histogram.getSize(); ++i) {
            int n = histogram.getCount(i);
            if (n == 0) continue;
            table.startRow();
            table.set(string, histogram.getValue(i));
            table.set("Count", n);
        }
        return table;
    }

    public static ArrayList getColumnNotEmpty(Table table, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = table.getColumnIndex(string);
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string2 = table.get(n, i);
            if (string2 == null || string2.trim().equals("")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static ArrayList getColumnUnique(Table table, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = table.getColumnIndex(string);
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string2 = table.get(n, i);
            if (string2 == null || string2.equals("") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static double getMax(Table table, String string) {
        double d = Double.NEGATIVE_INFINITY;
        int n = table.getColumnIndex(string);
        for (int i = 0; i < table.getNumberRows(); ++i) {
            try {
                double d2 = Double.parseDouble(table.get(n, i));
                d = Math.max(d, d2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public static Statistics getStatistics(Table table, String string) {
        Statistics statistics = new Statistics();
        int n = table.getColumnIndex(string);
        for (int i = 0; i < table.getNumberRows(); ++i) {
            try {
                String string2 = table.get(n, i);
                if (string2 == null) continue;
                double d = Double.parseDouble(string2);
                statistics.add(d);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return statistics;
    }

    public static boolean isNumberValue(String string) {
        if (string == null) {
            return false;
        }
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isBoolValue(String string) {
        return string.equals("0") || string.equals("1");
    }

    public static boolean isIntValue(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static Table select(Table table, String string, String string2) {
        Table table2 = new Table(table.getColumnTitles());
        int n = table.getNumberColumns();
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string3 = table.get(string, i);
            if (string3 == null || !string3.equals(string2)) continue;
            table2.startRow();
            for (int j = 0; j < n; ++j) {
                table2.set(j, table.get(j, i));
            }
        }
        return table2;
    }

    public static Table select(Table table, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string3);
        Table table2 = new Table(arrayList);
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string4 = table.get(string, i);
            if (string4 == null || !string4.equals(string2)) continue;
            table2.startRow();
            table2.set(string3, table.get(string3, i));
        }
        return table2;
    }

    public static Table select(Table table, String string, String string2, String string3, String string4) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string3);
        arrayList.add(string4);
        Table table2 = new Table(arrayList);
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string5 = table.get(string, i);
            if (string5 == null || !string5.equals(string2)) continue;
            table2.startRow();
            table2.set(string3, table.get(string3, i));
            table2.set(string4, table.get(string4, i));
        }
        return table2;
    }

    public static Table selectIntRange(Table table, String string, int n, int n2) {
        Table table2 = new Table(table.getColumnTitles());
        int n3 = table.getNumberColumns();
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string2 = table.get(string, i);
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 < n || n4 > n2) continue;
                table2.startRow();
                for (int j = 0; j < n3; ++j) {
                    table2.set(j, table.get(j, i));
                }
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return table2;
    }

    private TableUtils() {
    }

    static {
        $assertionsDisabled = !TableUtils.class.desiredAssertionStatus();
    }
}

