/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.logical.shared.HasHighlightHandlers;
import com.google.gwt.event.logical.shared.HasShowRangeHandlers;
import com.google.gwt.event.logical.shared.HighlightEvent;
import com.google.gwt.event.logical.shared.HighlightHandler;
import com.google.gwt.event.logical.shared.ShowRangeEvent;
import com.google.gwt.event.logical.shared.ShowRangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.datepicker.client.CalendarModel;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.google.gwt.user.datepicker.client.CalendarView;
import com.google.gwt.user.datepicker.client.DateChangeEvent;
import com.google.gwt.user.datepicker.client.DefaultCalendarView;
import com.google.gwt.user.datepicker.client.DefaultMonthSelector;
import com.google.gwt.user.datepicker.client.MonthSelector;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DatePicker
extends Composite
implements HasHighlightHandlers<Date>,
HasShowRangeHandlers<Date>,
HasValue<Date>,
IsEditor<LeafValueEditor<Date>> {
    private static final int DEFAULT_VISIBLE_YEAR_COUNT = 21;
    private final DateStyler styler = new DateStyler();
    private final MonthSelector monthAndYearSelector;
    private final CalendarView view;
    private final CalendarModel model;
    private Date value;
    private Date highlighted;
    private StandardCss css = StandardCss.DEFAULT;
    private LeafValueEditor<Date> editor;
    private int visibleYearCount = 21;
    private boolean yearArrowsVisible;
    private boolean yearAndMonthDropdownVisible;

    public DatePicker() {
        this(new DefaultMonthSelector(), new DefaultCalendarView(), new CalendarModel());
    }

    protected DatePicker(MonthSelector monthAndYearSelector, CalendarView view, CalendarModel model) {
        this.model = model;
        this.monthAndYearSelector = monthAndYearSelector;
        monthAndYearSelector.setDatePicker(this);
        this.view = view;
        view.setDatePicker(this);
        view.setup();
        monthAndYearSelector.setup();
        this.setup();
        this.setCurrentMonth(new Date());
        this.addStyleToDates(this.css().dayIsToday(), new Date());
    }

    @Override
    public HandlerRegistration addHighlightHandler(HighlightHandler<Date> handler) {
        return this.addHandler(handler, HighlightEvent.getType());
    }

    @Override
    public HandlerRegistration addShowRangeHandler(ShowRangeHandler<Date> handler) {
        return this.addHandler(handler, ShowRangeEvent.getType());
    }

    public HandlerRegistration addShowRangeHandlerAndFire(ShowRangeHandler<Date> handler) {
        ShowRangeEvent<Date> event = new ShowRangeEvent<Date>(this.getView().getFirstDate(), this.getView().getLastDate()){};
        handler.onShowRange(event);
        return this.addShowRangeHandler(handler);
    }

    public void addStyleToDates(String styleName, Date date) {
        this.styler.setStyleName(date, styleName, true);
        if (this.isDateVisible(date)) {
            this.getView().addStyleToDate(styleName, date);
        }
    }

    public void addStyleToDates(String styleName, Date date, Date ... moreDates) {
        this.addStyleToDates(styleName, date);
        for (Date d : moreDates) {
            this.addStyleToDates(styleName, d);
        }
    }

    public void addStyleToDates(String styleName, Iterable<Date> dates) {
        for (Date d : dates) {
            this.addStyleToDates(styleName, d);
        }
    }

    public void addTransientStyleToDates(String styleName, Date date) {
        assert (this.isDateVisible(date)) : date + " must be visible";
        this.getView().addStyleToDate(styleName, date);
    }

    public final void addTransientStyleToDates(String styleName, Date date, Date ... moreDates) {
        this.addTransientStyleToDates(styleName, date);
        for (Date d : moreDates) {
            this.addTransientStyleToDates(styleName, d);
        }
    }

    public final void addTransientStyleToDates(String styleName, Iterable<Date> dates) {
        for (Date d : dates) {
            this.addTransientStyleToDates(styleName, d);
        }
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public LeafValueEditor<Date> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    public Date getCurrentMonth() {
        return this.getModel().getCurrentMonth();
    }

    public final Date getFirstDate() {
        return this.view.getFirstDate();
    }

    public final Date getHighlightedDate() {
        return CalendarUtil.copyDate(this.highlighted);
    }

    public final Date getLastDate() {
        return this.view.getLastDate();
    }

    public int getVisibleYearCount() {
        return this.visibleYearCount;
    }

    public String getStyleOfDate(Date date) {
        return this.styler.getStyleName(date);
    }

    @Override
    public final Date getValue() {
        return CalendarUtil.copyDate(this.value);
    }

    public boolean isDateEnabled(Date date) {
        assert (this.isDateVisible(date)) : date + " is not visible";
        return this.getView().isDateEnabled(date);
    }

    public boolean isDateVisible(Date date) {
        CalendarView r = this.getView();
        Date first = r.getFirstDate();
        Date last = r.getLastDate();
        return date != null && (CalendarUtil.isSameDate(first, date) || CalendarUtil.isSameDate(last, date) || first.before(date) && last.after(date));
    }

    public boolean isYearArrowsVisible() {
        return this.yearArrowsVisible;
    }

    public boolean isYearAndMonthDropdownVisible() {
        return this.yearAndMonthDropdownVisible;
    }

    @Override
    public void onLoad() {
        ShowRangeEvent.fire(this, this.getFirstDate(), this.getLastDate());
    }

    public void removeStyleFromDates(String styleName, Date date) {
        this.styler.setStyleName(date, styleName, false);
        if (this.isDateVisible(date)) {
            this.getView().removeStyleFromDate(styleName, date);
        }
    }

    public void removeStyleFromDates(String styleName, Date date, Date ... moreDates) {
        this.removeStyleFromDates(styleName, date);
        for (Date d : moreDates) {
            this.removeStyleFromDates(styleName, d);
        }
    }

    public void removeStyleFromDates(String styleName, Iterable<Date> dates) {
        for (Date d : dates) {
            this.removeStyleFromDates(styleName, d);
        }
    }

    public void setCurrentMonth(Date month) {
        this.getModel().setCurrentMonth(month);
        this.refreshAll();
    }

    public void setVisibleYearCount(int numberOfYears) {
        if (numberOfYears <= 0) {
            throw new IllegalArgumentException("The number of years to display must be positive");
        }
        this.visibleYearCount = numberOfYears;
        this.getMonthSelector().refresh();
    }

    public void setYearArrowsVisible(boolean yearArrowsVisible) {
        this.yearArrowsVisible = yearArrowsVisible;
        this.getMonthSelector().refresh();
    }

    public void setYearAndMonthDropdownVisible(boolean dropdownVisible) {
        this.yearAndMonthDropdownVisible = dropdownVisible;
        this.getMonthSelector().refresh();
    }

    @Override
    public void setStyleName(String styleName) {
        this.css = new StandardCss(styleName, "datePicker");
        super.setStyleName(styleName);
    }

    public final void setTransientEnabledOnDates(boolean enabled, Date date) {
        assert (this.isDateVisible(date)) : date + " must be visible";
        this.getView().setEnabledOnDate(enabled, date);
    }

    public final void setTransientEnabledOnDates(boolean enabled, Date date, Date ... moreDates) {
        this.setTransientEnabledOnDates(enabled, date);
        for (Date d : moreDates) {
            this.setTransientEnabledOnDates(enabled, d);
        }
    }

    public final void setTransientEnabledOnDates(boolean enabled, Iterable<Date> dates) {
        for (Date d : dates) {
            this.setTransientEnabledOnDates(enabled, d);
        }
    }

    @Override
    public final void setValue(Date newValue) {
        this.setValue(newValue, false);
    }

    @Override
    public final void setValue(Date newValue, boolean fireEvents) {
        Date oldValue = this.value;
        if (oldValue != null) {
            this.removeStyleFromDates(this.css().dayIsValue(), oldValue);
        }
        this.value = CalendarUtil.copyDate(newValue);
        if (this.value != null) {
            this.addStyleToDates(this.css().dayIsValue(), this.value);
        }
        this.getView().setAriaSelectedCell(newValue);
        if (fireEvents) {
            DateChangeEvent.fireIfNotEqualDates(this, oldValue, newValue);
        }
    }

    protected final CalendarModel getModel() {
        return this.model;
    }

    protected final MonthSelector getMonthSelector() {
        return this.monthAndYearSelector;
    }

    protected final CalendarView getView() {
        return this.view;
    }

    protected final void refreshAll() {
        this.highlighted = null;
        this.getModel().refresh();
        this.getView().refresh();
        this.getMonthSelector().refresh();
        if (this.isAttached()) {
            ShowRangeEvent.fire(this, this.getFirstDate(), this.getLastDate());
        }
        this.getView().setAriaSelectedCell(this.value);
    }

    protected void setup() {
        VerticalPanel panel = new VerticalPanel();
        this.initWidget(panel);
        DatePicker.setStyleName(panel.getElement(), this.css.datePicker());
        this.setStyleName(this.css().datePicker());
        panel.add(this.getMonthSelector());
        panel.add(this.getView());
    }

    final StandardCss css() {
        return this.css;
    }

    void setHighlightedDate(Date highlighted) {
        this.highlighted = highlighted;
        this.fireEvent(new DateHighlightEvent(highlighted));
    }

    private static class DateStyler {
        private Map<String, String> info = new HashMap<String, String>();

        private DateStyler() {
        }

        public String getStyleName(Date d) {
            return this.info.get(this.genKey(d));
        }

        public void setStyleName(Date d, String styleName, boolean add) {
            styleName = " " + styleName + " ";
            String key = this.genKey(d);
            String current = this.info.get(key);
            if (add) {
                if (current == null) {
                    this.info.put(key, styleName);
                } else if (current.indexOf(styleName) == -1) {
                    this.info.put(key, current + styleName);
                }
            } else if (current != null) {
                String newValue = current.replaceAll(styleName, "");
                if (newValue.trim().length() == 0) {
                    this.info.remove(key);
                } else {
                    this.info.put(key, newValue);
                }
            }
        }

        private String genKey(Date d) {
            return d.getYear() + "/" + d.getMonth() + "/" + d.getDate();
        }
    }

    private static class DateHighlightEvent
    extends HighlightEvent<Date> {
        protected DateHighlightEvent(Date highlighted) {
            super(highlighted);
        }

        @Override
        public Date getHighlighted() {
            return CalendarUtil.copyDate((Date)super.getHighlighted());
        }
    }

    static class StandardCss {
        static StandardCss DEFAULT = new StandardCss("gwt-DatePicker", "datePicker");
        private String baseName;
        private String widgetName;

        public StandardCss(String widgetName, String baseName) {
            this.widgetName = widgetName;
            this.baseName = baseName;
        }

        public String datePicker() {
            return this.getWidgetStyleName();
        }

        public String day() {
            return this.wrap("Day");
        }

        public String day(String dayModifier) {
            return this.day() + "Is" + dayModifier;
        }

        public String dayIsDisabled() {
            return this.day("Disabled");
        }

        public String dayIsFiller() {
            return this.day("Filler");
        }

        public String dayIsHighlighted() {
            return this.day("Highlighted");
        }

        public String dayIsToday() {
            return this.day("Today");
        }

        public String dayIsValue() {
            return this.day("Value");
        }

        public String dayIsValueAndHighlighted() {
            return this.dayIsValue() + "AndHighlighted";
        }

        public String dayIsWeekend() {
            return this.day("Weekend");
        }

        public String days() {
            return this.wrap("Days");
        }

        public String daysLabel() {
            return this.wrap("DaysLabel");
        }

        public String getBaseStyleName() {
            return this.baseName;
        }

        public String getWidgetStyleName() {
            return this.widgetName;
        }

        public String month() {
            return this.wrap("Month");
        }

        public String monthSelector() {
            return this.wrap("MonthSelector");
        }

        public String nextButton() {
            return this.wrap("NextButton");
        }

        public String nextYearButton() {
            return this.wrap("NextYearButton");
        }

        public String previousButton() {
            return this.wrap("PreviousButton");
        }

        public String previousYearButton() {
            return this.wrap("PreviousYearButton");
        }

        public String weekdayLabel() {
            return this.wrap("WeekdayLabel");
        }

        public String weekendLabel() {
            return this.wrap("WeekendLabel");
        }

        public String year() {
            return this.wrap("Year");
        }

        protected String wrap(String style) {
            return this.baseName + style;
        }
    }
}

