/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.spdy.api.Info;
import org.eclipse.jetty.util.Fields;

public class SynInfo
extends Info {
    public static final byte FLAG_CLOSE = 1;
    private final boolean close;
    private final byte priority;
    private final Fields headers;

    public SynInfo(Fields headers, boolean close) {
        this(0L, TimeUnit.SECONDS, headers, close, 0);
    }

    public SynInfo(Fields headers, boolean close, byte priority) {
        this(0L, TimeUnit.SECONDS, headers, close, priority);
    }

    public SynInfo(long timeout, TimeUnit unit, Fields headers, boolean close, byte priority) {
        super(timeout, unit);
        this.close = close;
        this.priority = priority;
        this.headers = headers;
    }

    public boolean isClose() {
        return this.close;
    }

    public byte getPriority() {
        return this.priority;
    }

    public Fields getHeaders() {
        return this.headers;
    }

    public byte getFlags() {
        return this.isClose() ? (byte)1 : 0;
    }

    public String toString() {
        return String.format("SYN close=%b headers=%s", this.close, this.headers);
    }
}

