/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.triggers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.monitor.jmx.EventState;
import org.eclipse.jetty.monitor.jmx.EventTrigger;

public class AggregateEventTrigger
extends EventTrigger {
    protected final List<EventTrigger> _triggers;

    public AggregateEventTrigger() {
        this._triggers = new ArrayList<EventTrigger>();
    }

    public AggregateEventTrigger(List<EventTrigger> triggers) {
        this._triggers = new ArrayList<EventTrigger>(triggers);
    }

    public AggregateEventTrigger(EventTrigger ... triggers) {
        this._triggers = Arrays.asList(triggers);
    }

    public void add(EventTrigger trigger) {
        this._triggers.add(trigger);
    }

    public void addAll(List<EventTrigger> triggers) {
        this._triggers.addAll(triggers);
    }

    public void addAll(EventTrigger ... triggers) {
        this._triggers.addAll(Arrays.asList(triggers));
    }

    public EventState getState(long timestamp) {
        EventState state = new EventState();
        for (EventTrigger trigger : this._triggers) {
            EventState<?> subState = trigger.getState(timestamp);
            if (subState == null) continue;
            state.addAll(subState.values());
        }
        return state;
    }

    @Override
    public boolean match(long timestamp) throws Exception {
        boolean result = false;
        for (EventTrigger trigger : this._triggers) {
            result = trigger.match(timestamp) ? true : result;
        }
        return true;
    }

    public String toString() {
        int cnt = 0;
        StringBuilder result = new StringBuilder();
        result.append("ANY(");
        for (EventTrigger trigger : this._triggers) {
            result.append(cnt++ > 0 ? "," : "");
            result.append(trigger);
        }
        result.append(')');
        return result.toString();
    }
}

