/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptorWithPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorOptionsTree
extends Tree {
    private final String myCategoryName;
    private final DefaultTreeModel myTreeModel;
    private static final Comparator<EditorSchemeAttributeDescriptor> ATTR_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.toString(), (String)o2.toString());

    public ColorOptionsTree(@NotNull String categoryName) {
        if (categoryName == null) {
            ColorOptionsTree.$$$reportNull$$$0(0);
        }
        super(ColorOptionsTree.createTreeModel());
        this.myTreeModel = (DefaultTreeModel)this.getModel();
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.myCategoryName = categoryName;
        new TreeSpeedSearch(this, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
    }

    public void fillOptions(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            ColorOptionsTree.$$$reportNull$$$0(1);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (EditorSchemeAttributeDescriptor description : this.getOrderedDescriptors(options)) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            List<String> path = ColorOptionsTree.extractPath(description);
            if (path != null && path.size() > 1) {
                MyTreeNode groupNode = ColorOptionsTree.ensureGroup(root, path, 0);
                groupNode.add(new MyTreeNode(description, path.get(path.size() - 1)));
                continue;
            }
            root.add(new MyTreeNode(description));
        }
        this.myTreeModel.setRoot(root);
    }

    public void setEmptyText(@NotNull String text, @Nullable ActionListener linkListener) {
        if (text == null) {
            ColorOptionsTree.$$$reportNull$$$0(2);
        }
        StatusText statusText = this.getEmptyText();
        if (linkListener != null) {
            statusText.clear();
            statusText.appendText(text + ' ');
            statusText.appendText("More...", SimpleTextAttributes.LINK_ATTRIBUTES, linkListener);
        } else {
            statusText.setText(text);
        }
    }

    private static TreeModel createTreeModel() {
        return new DefaultTreeModel((TreeNode)new DefaultMutableTreeTableNode());
    }

    private Collection<EditorSchemeAttributeDescriptor> getOrderedDescriptors(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            ColorOptionsTree.$$$reportNull$$$0(3);
        }
        ArrayList list2 = ContainerUtil.newArrayList();
        for (EditorSchemeAttributeDescriptor description : options.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            list2.add(description);
        }
        Collections.sort(list2, ATTR_COMPARATOR);
        return list2;
    }

    @Nullable
    public EditorSchemeAttributeDescriptor getSelectedDescriptor() {
        Object selectedValue = this.getSelectedValue();
        return selectedValue instanceof EditorSchemeAttributeDescriptor ? (EditorSchemeAttributeDescriptor)selectedValue : null;
    }

    @Nullable
    public Object getSelectedValue() {
        Object selectedNode = this.getLastSelectedPathComponent();
        if (selectedNode instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)selectedNode).getUserObject();
        }
        return null;
    }

    public void selectOptionByType(final @NotNull String attributeType) {
        if (attributeType == null) {
            ColorOptionsTree.$$$reportNull$$$0(4);
        }
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (data instanceof EditorSchemeAttributeDescriptor) {
                    return attributeType.equals(((EditorSchemeAttributeDescriptor)data).getType());
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/colors/ColorOptionsTree$1", "matches"));
            }
        }));
    }

    public void selectOptionByName(@NotNull String name) {
        if (name == null) {
            ColorOptionsTree.$$$reportNull$$$0(5);
        }
        final String optionName = name.replace(FontUtil.rightArrow((Font)UIUtil.getLabelFont()), "//");
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !optionName.isEmpty() && StringUtil.containsIgnoreCase((String)data.toString(), (String)optionName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/colors/ColorOptionsTree$2", "matches"));
            }
        }));
    }

    @Nullable
    private TreePath findOption(@NotNull Object nodeObject, @NotNull DescriptorMatcher matcher) {
        if (nodeObject == null) {
            ColorOptionsTree.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            ColorOptionsTree.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < this.myTreeModel.getChildCount(nodeObject); ++i) {
            Object data;
            Object childObject = this.myTreeModel.getChild(nodeObject, i);
            if (childObject instanceof MyTreeNode && matcher.matches(data = ((MyTreeNode)childObject).getUserObject())) {
                return new TreePath(this.myTreeModel.getPathToRoot((MyTreeNode)childObject));
            }
            TreePath pathInChild = this.findOption(childObject, matcher);
            if (pathInChild == null) continue;
            return pathInChild;
        }
        return null;
    }

    private void selectPath(@Nullable TreePath path) {
        if (path != null) {
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    @Nullable
    private static List<String> extractPath(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        if (descriptor == null) {
            ColorOptionsTree.$$$reportNull$$$0(8);
        }
        if (descriptor instanceof EditorSchemeAttributeDescriptorWithPath) {
            String name = descriptor.toString();
            ArrayList<String> path = new ArrayList<String>();
            int separatorStart = name.indexOf("//");
            int nextChunkStart = 0;
            while (separatorStart > 0) {
                path.add(name.substring(nextChunkStart, separatorStart));
                nextChunkStart = separatorStart + "//".length();
                separatorStart = name.indexOf("//", nextChunkStart);
            }
            if (nextChunkStart < name.length()) {
                path.add(name.substring(nextChunkStart));
            }
            return path;
        }
        return null;
    }

    private static MyTreeNode ensureGroup(@NotNull DefaultMutableTreeNode root, @NotNull List<String> path, int index) {
        if (root == null) {
            ColorOptionsTree.$$$reportNull$$$0(9);
        }
        if (path == null) {
            ColorOptionsTree.$$$reportNull$$$0(10);
        }
        String groupName = path.get(index++);
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode child2 = root.getChildAt(i);
            if (!(child2 instanceof MyTreeNode) || !groupName.equals(child2.toString())) continue;
            return index < path.size() - 1 ? ColorOptionsTree.ensureGroup((MyTreeNode)child2, path, index) : (MyTreeNode)child2;
        }
        MyTreeNode groupNode = new MyTreeNode(groupName);
        root.add(groupNode);
        return index < path.size() - 1 ? ColorOptionsTree.ensureGroup(groupNode, path, index) : groupNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/ColorOptionsTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fillOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setEmptyText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrderedDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOptionByType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOptionByName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findOption";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface DescriptorMatcher {
        public boolean matches(@NotNull Object var1);
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        private final String myName;

        MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor, @NotNull String name) {
            if (descriptor == null) {
                MyTreeNode.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MyTreeNode.$$$reportNull$$$0(1);
            }
            super(descriptor);
            this.myName = name;
        }

        MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor) {
            if (descriptor == null) {
                MyTreeNode.$$$reportNull$$$0(2);
            }
            super(descriptor);
            this.myName = descriptor.toString();
        }

        MyTreeNode(@NotNull String groupName) {
            if (groupName == null) {
                MyTreeNode.$$$reportNull$$$0(3);
            }
            super(groupName);
            this.myName = groupName;
        }

        @Override
        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/colors/ColorOptionsTree$MyTreeNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

