/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunConfigurableKt;
import com.intellij.execution.impl.RunConfigurableNodeKind;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000W\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0005\u001a \u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a3\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"INITIAL_VALUE_KEY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TEMPLATES", "com/intellij/execution/impl/RunConfigurableKt$TEMPLATES$1", "Lcom/intellij/execution/impl/RunConfigurableKt$TEMPLATES$1;", "TEMPLATE_GROUP_NODE_NAME", "canRunConfiguration", "", "configuration", "Lcom/intellij/execution/impl/SingleConfigurationConfigurable;", "Lcom/intellij/execution/configurations/RunConfiguration;", "executor", "Lcom/intellij/execution/Executor;", "createUniqueName", "typeNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "baseName", "kinds", "", "Lcom/intellij/execution/impl/RunConfigurableNodeKind;", "(Ljavax/swing/tree/DefaultMutableTreeNode;Ljava/lang/String;[Lcom/intellij/execution/impl/RunConfigurableNodeKind;)Ljava/lang/String;", "getName", "userObject", "", "getSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "treeNode", "getType", "Lcom/intellij/execution/configurations/ConfigurationType;", "_node", "intellij.platform.lang.impl"})
public final class RunConfigurableKt {
    private static final String TEMPLATE_GROUP_NODE_NAME = "Templates";
    private static final TEMPLATES.1 TEMPLATES = new Object(){

        @NotNull
        public String toString() {
            return "Templates";
        }
    };
    private static final String INITIAL_VALUE_KEY = "initialValue";
    private static final Logger LOG;

    private static final String getName(Object userObject) {
        String string;
        if (userObject instanceof ConfigurationType) {
            String string2 = ((ConfigurationType)userObject).getDisplayName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"userObject.displayName");
        } else if (userObject == TEMPLATES) {
            string = TEMPLATE_GROUP_NODE_NAME;
        } else if (userObject instanceof ConfigurationFactory) {
            String string3 = ((ConfigurationFactory)userObject).getName();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"userObject.name");
        } else {
            Object object;
            if (userObject instanceof SingleConfigurationConfigurable) {
                object = ((SingleConfigurationConfigurable)((Object)userObject)).getNameText();
            } else {
                Object object2 = userObject;
                if (!(object2 instanceof RunnerAndConfigurationSettingsImpl)) {
                    object2 = null;
                }
                if ((object = (RunnerAndConfigurationSettingsImpl)object2) == null || (object = ((RunnerAndConfigurationSettingsImpl)object).getName()) == null) {
                    object = userObject.toString();
                }
            }
            string = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"if (userObject is Single\u2026 ?: userObject.toString()");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canRunConfiguration(SingleConfigurationConfigurable<RunConfiguration> configuration, Executor executor) {
        try {
            if (configuration == null) return false;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = configuration.createSnapshot(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)runnerAndConfigurationSettings, (String)"configuration.createSnapshot(false)");
            if (!RunManagerImpl.Companion.canRunConfiguration(runnerAndConfigurationSettings, executor)) return false;
            return true;
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    private static final String createUniqueName(DefaultMutableTreeNode typeNode, String baseName, RunConfigurableNodeKind ... kinds) {
        String string = baseName;
        if (string == null) {
            string = ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]);
        }
        String str = string;
        ArrayList configurationNodes = new ArrayList();
        RunConfigurable.Companion.collectNodesRecursively(typeNode, configurationNodes, Arrays.copyOf(kinds, kinds.length));
        ArrayList<Object> currentNames = new ArrayList<Object>();
        Iterator iterator = configurationNodes.iterator();
        while (iterator.hasNext()) {
            Object userObject;
            DefaultMutableTreeNode node;
            DefaultMutableTreeNode defaultMutableTreeNode = node = (DefaultMutableTreeNode)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultMutableTreeNode, (String)"node");
            Object object = userObject = defaultMutableTreeNode.getUserObject();
            if (object instanceof SingleConfigurationConfigurable) {
                currentNames.add(((SingleConfigurationConfigurable)((Object)userObject)).getNameText());
                continue;
            }
            if (object instanceof RunnerAndConfigurationSettingsImpl) {
                Object object2 = userObject;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.RunnerAndConfigurationSettings");
                }
                currentNames.add(((RunnerAndConfigurationSettings)object2).getName());
                continue;
            }
            if (!(object instanceof String)) continue;
            currentNames.add(userObject);
        }
        String string2 = str;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"str");
        return RunManager.Companion.suggestUniqueName(string2, (Collection)currentNames);
    }

    private static final ConfigurationType getType(DefaultMutableTreeNode _node) {
        DefaultMutableTreeNode node = _node;
        while (node != null) {
            Object object = node.getUserObject();
            if (!(object instanceof ConfigurationType)) {
                object = null;
            }
            ConfigurationType configurationType = (ConfigurationType)object;
            if (configurationType != null) {
                ConfigurationType configurationType2;
                ConfigurationType it = configurationType2 = configurationType;
                return it;
            }
            TreeNode treeNode = node.getParent();
            if (!(treeNode instanceof DefaultMutableTreeNode)) {
                treeNode = null;
            }
            node = (DefaultMutableTreeNode)treeNode;
        }
        return null;
    }

    private static final RunnerAndConfigurationSettings getSettings(DefaultMutableTreeNode treeNode) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings;
        if (treeNode == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = null;
        if (treeNode.getUserObject() instanceof SingleConfigurationConfigurable) {
            Object object = treeNode.getUserObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.impl.SingleConfigurationConfigurable<*>");
            }
            runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)((SingleConfigurationConfigurable)((Object)object)).getSettings();
        } else if (treeNode.getUserObject() instanceof RunnerAndConfigurationSettings) {
            Object object = treeNode.getUserObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.RunnerAndConfigurationSettings");
            }
            runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)object;
        } else {
            runnerAndConfigurationSettings = settings;
        }
        return runnerAndConfigurationSettings;
    }

    static {
        Logger logger = Logger.getInstance(RunConfigurable.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @NotNull
    public static final /* synthetic */ String access$createUniqueName(@NotNull DefaultMutableTreeNode typeNode, @Nullable String baseName, RunConfigurableNodeKind ... kinds) {
        return RunConfigurableKt.createUniqueName(typeNode, baseName, kinds);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ TEMPLATES.1 access$getTEMPLATES$p() {
        return TEMPLATES;
    }

    @Nullable
    public static final /* synthetic */ ConfigurationType access$getType(@Nullable DefaultMutableTreeNode _node) {
        return RunConfigurableKt.getType(_node);
    }

    @NotNull
    public static final /* synthetic */ String access$getName(@NotNull Object userObject) {
        return RunConfigurableKt.getName(userObject);
    }

    public static final /* synthetic */ boolean access$canRunConfiguration(@Nullable SingleConfigurationConfigurable configuration, @NotNull Executor executor) {
        return RunConfigurableKt.canRunConfiguration(configuration, executor);
    }

    @Nullable
    public static final /* synthetic */ RunnerAndConfigurationSettings access$getSettings(@Nullable DefaultMutableTreeNode treeNode) {
        return RunConfigurableKt.getSettings(treeNode);
    }
}

