/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindPopupScopeUI;
import com.intellij.find.impl.FindPopupScopeUIImpl;
import com.intellij.find.impl.FindPopupScopeUIProvider;
import com.intellij.find.impl.FindUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.UIBundle;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowResizeListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupPanel
extends JBPanel
implements FindUI {
    private static final Logger LOG = Logger.getInstance(FindPopupPanel.class);
    private static final KeyStroke ENTER = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke ENTER_WITH_MODIFIERS = KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128);
    private static final KeyStroke REPLACE_ALL = KeyStroke.getKeyStroke(10, 72);
    private static final String SERVICE_KEY = "find.popup";
    private static final String SPLITTER_SERVICE_KEY = "find.popup.splitter";
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    private final Alarm myPreviewUpdater;
    @NotNull
    private final FindPopupScopeUI myScopeUI;
    private JComponent myCodePreviewComponent;
    private SearchTextArea mySearchTextArea;
    private SearchTextArea myReplaceTextArea;
    private ActionListener myOkActionListener;
    private final AtomicBoolean myCanClose;
    private final AtomicBoolean myIsPinned;
    private JBLabel myOKHintLabel;
    private JBLabel myNavigationHintLabel;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;
    private JLabel myTitleLabel;
    private StateRestoringCheckBox myCbCaseSensitive;
    private StateRestoringCheckBox myCbPreserveCase;
    private StateRestoringCheckBox myCbWholeWordsOnly;
    private StateRestoringCheckBox myCbRegularExpressions;
    private StateRestoringCheckBox myCbFileFilter;
    private ActionToolbarImpl myScopeSelectionToolbar;
    private ComboBox<String> myFileMaskField;
    private ActionButton myFilterContextButton;
    private ActionButton myTabResultsButton;
    private ActionButton myPinButton;
    private JButton myOKButton;
    private JButton myReplaceAllButton;
    private JButton myReplaceSelectedButton;
    private JTextArea mySearchComponent;
    private JTextArea myReplaceComponent;
    private String mySelectedContextName;
    private FindPopupScopeUI.ScopeType mySelectedScope;
    private JPanel myScopeDetailsPanel;
    private JBTable myResultsPreviewTable;
    private UsagePreviewPanel myUsagePreviewPanel;
    private DialogWrapper myDialog;
    private LoadingDecorator myLoadingDecorator;
    private int myLoadingHash;
    private JPanel myTitlePanel;
    private String myUsagesCount;
    private String myFilesCount;
    private UsageViewPresentation myUsageViewPresentation;
    private ComponentValidator myComponentValidator;

    FindPopupPanel(@NotNull FindUIHelper helper) {
        if (helper == null) {
            FindPopupPanel.$$$reportNull$$$0(0);
        }
        this.myCanClose = new AtomicBoolean(true);
        this.myIsPinned = new AtomicBoolean(false);
        this.mySelectedContextName = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        this.myHelper = helper;
        this.myProject = this.myHelper.getProject();
        this.myDisposable = Disposer.newDisposable();
        this.myPreviewUpdater = new Alarm(this.myDisposable);
        this.myScopeUI = FindPopupScopeUIProvider.getInstance().create(this);
        this.myComponentValidator = new ComponentValidator(this.myDisposable);
        Disposer.register((Disposable)this.myDisposable, () -> {
            this.finishPreviousPreviewSearch();
            if (this.mySearchRescheduleOnCancellationsAlarm != null) {
                Disposer.dispose((Disposable)this.mySearchRescheduleOnCancellationsAlarm);
            }
            if (this.myUsagePreviewPanel != null) {
                Disposer.dispose((Disposable)this.myUsagePreviewPanel);
            }
        });
        this.initComponents();
        this.initByModel();
    }

    @Override
    public void showUI() {
        if (this.myDialog != null && this.myDialog.isVisible()) {
            return;
        }
        if (this.myDialog != null && !Disposer.isDisposed((Disposable)this.myDialog.getDisposable())) {
            this.myDialog.doCancelAction();
        }
        if (this.myDialog == null || Disposer.isDisposed((Disposable)this.myDialog.getDisposable())) {
            this.myDialog = new DialogWrapper(this.myHelper.getProject(), true, DialogWrapper.IdeModalityType.MODELESS){
                {
                    this.init();
                    this.getContentPane().add((Component)new JLabel(), "South");
                    this.getRootPane().setDefaultButton(null);
                }

                protected void doOKAction() {
                    FindPopupPanel.this.processCtrlEnter();
                }

                protected void dispose() {
                    FindPopupPanel.this.saveSettings();
                    super.dispose();
                }

                @NotNull
                protected Action[] createLeftSideActions() {
                    Action[] actionArray = new Action[]{};
                    if (actionArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actionArray;
                }

                @Nullable
                protected Border createContentPaneBorder() {
                    return null;
                }

                protected JComponent createCenterPanel() {
                    return FindPopupPanel.this;
                }

                protected String getDimensionServiceKey() {
                    return FindPopupPanel.SERVICE_KEY;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel$1", "createLeftSideActions"));
                }
            };
            this.myDialog.setUndecorated(true);
            Disposer.register((Disposable)this.myDialog.getDisposable(), (Disposable)this.myDisposable);
            Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
            Component parent = UIUtil.findUltimateParent((Component)window);
            RelativePoint showPoint = null;
            Point screenPoint = DimensionService.getInstance().getLocation(SERVICE_KEY);
            if (screenPoint != null) {
                if (parent != null) {
                    SwingUtilities.convertPointFromScreen(screenPoint, parent);
                    showPoint = new RelativePoint(parent, screenPoint);
                } else {
                    showPoint = new RelativePoint(screenPoint);
                }
            }
            if (parent != null && showPoint == null) {
                int height;
                int n = height = UISettings.getInstance().getShowNavigationBar() ? 135 : 115;
                if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                    height -= 20;
                }
                showPoint = new RelativePoint(parent, new Point((parent.getSize().width - this.getPreferredSize().width) / 2, height));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.mySearchComponent.getCaret() != null) {
                    this.mySearchComponent.selectAll();
                }
            });
            WindowMoveListener windowListener = new WindowMoveListener((Component)((Object)this));
            this.myTitlePanel.addMouseListener(windowListener);
            this.myTitlePanel.addMouseMotionListener(windowListener);
            this.addMouseListener(windowListener);
            this.addMouseMotionListener(windowListener);
            Dimension panelSize = this.getPreferredSize();
            Dimension prev2 = DimensionService.getInstance().getSize(SERVICE_KEY);
            if (!this.myCbPreserveCase.isVisible()) {
                panelSize.width += this.myCbPreserveCase.getPreferredSize().width + 8;
            }
            panelSize.width += JBUI.scale((int)24);
            panelSize.height *= 2;
            if (prev2 != null && prev2.height < panelSize.height) {
                prev2.height = panelSize.height;
            }
            final Window w = this.myDialog.getPeer().getWindow();
            AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
            JRootPane root = ((RootPaneContainer)((Object)w)).getRootPane();
            final IdeGlassPaneImpl glass = (IdeGlassPaneImpl)this.myDialog.getRootPane().getGlassPane();
            int i = Registry.intValue((String)"ide.popup.resizable.border.sensitivity", (int)4);
            WindowResizeListener resizeListener = new WindowResizeListener(root, (Insets)JBUI.insets((int)i), null){
                private Cursor myCursor;

                @Override
                protected void setCursor(Component content, Cursor cursor) {
                    if (this.myCursor != cursor || this.myCursor != Cursor.getDefaultCursor()) {
                        glass.setCursor(cursor, this);
                        this.myCursor = cursor;
                        if (content instanceof JComponent) {
                            IdeGlassPaneImpl.savePreProcessedCursor((JComponent)content, content.getCursor());
                        }
                        super.setCursor(content, cursor);
                    }
                }
            };
            glass.addMousePreprocessor(resizeListener, this.myDisposable);
            glass.addMouseMotionPreprocessor(resizeListener, this.myDisposable);
            DumbAwareAction.create(e -> this.closeImmediately()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)root, this.myDisposable);
            root.setWindowDecorationStyle(0);
            root.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
            UIUtil.markAsPossibleOwner((Dialog)((Dialog)w));
            w.setBackground(UIUtil.getPanelBackground());
            w.setMinimumSize(panelSize);
            if (prev2 == null) {
                panelSize.height = (int)((double)panelSize.height * 1.5);
                panelSize.width = (int)((double)panelSize.width * 1.15);
            }
            w.setSize(prev2 != null ? prev2 : panelSize);
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            if (showPoint != null) {
                this.myDialog.setLocation(showPoint.getScreenPoint());
            } else {
                w.setLocationRelativeTo(parent);
            }
            this.myDialog.show();
            w.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    w.addWindowFocusListener(new WindowAdapter(){

                        @Override
                        public void windowLostFocus(WindowEvent e) {
                            Window oppositeWindow = e.getOppositeWindow();
                            if (oppositeWindow == w || oppositeWindow != null && oppositeWindow.getOwner() == w) {
                                return;
                            }
                            if (FindPopupPanel.this.canBeClosed() || !FindPopupPanel.this.myIsPinned.get() && oppositeWindow != null) {
                                FindPopupPanel.this.myDialog.doCancelAction();
                            }
                        }
                    });
                }
            });
            JRootPane rootPane = this.getRootPane();
            if (rootPane != null) {
                if (this.myHelper.isReplaceState()) {
                    rootPane.setDefaultButton(this.myReplaceSelectedButton);
                }
                rootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl pressed ENTER"), "openInFindWindow");
                rootPane.getActionMap().put("openInFindWindow", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindPopupPanel.this.processCtrlEnter();
                    }
                });
            }
            ApplicationManager.getApplication().invokeLater(this::scheduleResultsUpdate, ModalityState.any());
        }
    }

    protected boolean canBeClosed() {
        if (!this.myCanClose.get()) {
            return false;
        }
        if (this.myIsPinned.get()) {
            return false;
        }
        if (!ApplicationManager.getApplication().isActive()) {
            return false;
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null) {
            return false;
        }
        if (this.myFileMaskField.isPopupVisible()) {
            this.myFileMaskField.setPopupVisible(false);
            return false;
        }
        List popups = ContainerUtil.filter((Collection)JBPopupFactory.getInstance().getChildPopups((Component)((Object)this)), popup2 -> !popup2.isDisposed());
        if (!popups.isEmpty()) {
            for (JBPopup popup3 : popups) {
                popup3.cancel();
            }
            return false;
        }
        return !this.myScopeUI.hideAllPopups();
    }

    @Override
    public void saveSettings() {
        DimensionService.getInstance().setSize(SERVICE_KEY, this.myDialog.getSize(), this.myHelper.getProject());
        DimensionService.getInstance().setLocation(SERVICE_KEY, this.myDialog.getWindow().getLocationOnScreen(), this.myHelper.getProject());
        FindSettings findSettings = FindSettings.getInstance();
        this.myScopeUI.applyTo(findSettings, this.mySelectedScope);
        this.myHelper.updateFindSettings();
        this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel());
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            FindPopupPanel.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FindPopupPanel.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public FindUIHelper getHelper() {
        FindUIHelper findUIHelper = this.myHelper;
        if (findUIHelper == null) {
            FindPopupPanel.$$$reportNull$$$0(3);
        }
        return findUIHelper;
    }

    @NotNull
    public AtomicBoolean getCanClose() {
        AtomicBoolean atomicBoolean = this.myCanClose;
        if (atomicBoolean == null) {
            FindPopupPanel.$$$reportNull$$$0(4);
        }
        return atomicBoolean;
    }

    private void initComponents() {
        Keymap activeKeymap;
        JComponent[] tableAware;
        KeyStroke editSourceKeyStroke;
        this.myTitleLabel = new JBLabel(FindBundle.message("find.in.path.dialog.title", new Object[0]), UIUtil.ComponentStyle.REGULAR);
        this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(1));
        this.myLoadingDecorator = new LoadingDecorator((JComponent)new JLabel(EmptyIcon.ICON_16), this.getDisposable(), 250, true, new AsyncProcessIcon("FindInPathLoading"));
        this.myLoadingDecorator.setLoadingText("");
        this.myCbCaseSensitive = FindPopupPanel.createCheckBox("find.popup.case.sensitive");
        ItemListener liveResultsPreviewUpdateListener = __ -> this.scheduleResultsUpdate();
        this.myCbCaseSensitive.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase = FindPopupPanel.createCheckBox("find.options.replace.preserve.case");
        this.myCbPreserveCase.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase.setVisible(this.myHelper.getModel().isReplaceState());
        this.myCbWholeWordsOnly = FindPopupPanel.createCheckBox("find.popup.whole.words");
        this.myCbWholeWordsOnly.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbRegularExpressions = FindPopupPanel.createCheckBox("find.popup.regex");
        this.myCbRegularExpressions.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbFileFilter = FindPopupPanel.createCheckBox("find.popup.filemask");
        this.myCbFileFilter.addItemListener(__ -> {
            if (this.myCbFileFilter.isSelected()) {
                this.myFileMaskField.setEnabled(true);
                if (this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus(this.myFileMaskField, true);
                    this.myFileMaskField.getEditor().selectAll();
                }
            } else {
                this.myFileMaskField.setEnabled(false);
                if (this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchComponent, true);
                }
            }
        });
        this.myCbFileFilter.addItemListener(liveResultsPreviewUpdateListener);
        this.myFileMaskField = new ComboBox<String>(){

            public Dimension getPreferredSize() {
                Component editorComponent;
                Component[] components;
                int width = 0;
                int buttonWidth = 0;
                for (Component component : components = this.getComponents()) {
                    int w;
                    Dimension size = component.getPreferredSize();
                    int n = w = size != null ? size.width : 0;
                    if (component instanceof JButton) {
                        buttonWidth = w;
                    }
                    width += w;
                }
                ComboBoxEditor editor = this.getEditor();
                if (editor != null && (editorComponent = editor.getEditorComponent()) != null) {
                    FontMetrics fontMetrics = editorComponent.getFontMetrics(editorComponent.getFont());
                    width = Math.max(width, fontMetrics.stringWidth(String.valueOf(this.getSelectedItem())) + buttonWidth);
                    width += fontMetrics.stringWidth("m");
                }
                Dimension size = super.getPreferredSize();
                Insets insets = this.getInsets();
                size.width = Math.min(JBUI.scale((int)500), Math.max(JBUI.scale((int)80), width += insets.left + insets.right));
                return size;
            }
        };
        this.myFileMaskField.setEditable(true);
        this.myFileMaskField.setMaximumRowCount(8);
        this.myFileMaskField.addActionListener(__ -> this.scheduleResultsUpdate());
        Component editorComponent = this.myFileMaskField.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            EditorTextField etf = (EditorTextField)((Object)editorComponent);
            etf.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                    if (event == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.onFileMaskChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/impl/FindPopupPanel$6", "documentChanged"));
                }
            });
        } else if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    FindPopupPanel.this.onFileMaskChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$7", "textChanged"));
                }
            });
        } else assert (false);
        MyShowFilterPopupAction myShowFilterPopupAction = new MyShowFilterPopupAction();
        this.myFilterContextButton = new ActionButton((AnAction)myShowFilterPopupAction, myShowFilterPopupAction.getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            public int getPopState() {
                int state = super.getPopState();
                if (state != 0) {
                    return state;
                }
                return FindPopupPanel.this.mySelectedContextName.equals(FindDialog.getPresentableName(FindModel.SearchContext.ANY)) ? 0 : -1;
            }
        };
        myShowFilterPopupAction.registerCustomShortcutSet(myShowFilterPopupAction.getShortcutSet(), (JComponent)((Object)this));
        ToggleAction pinAction = new ToggleAction(null, null, AllIcons.General.Pin_tab){

            public boolean isDumbAware() {
                return true;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                return UISettings.getInstance().getPinFindInPath();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                FindPopupPanel.this.myIsPinned.set(state);
                UISettings.getInstance().setPinFindInPath(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myPinButton = new ActionButton((AnAction)pinAction, pinAction.getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        DefaultActionGroup tabResultsContextGroup = new DefaultActionGroup();
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0])){

            public boolean isDumbAware() {
                return true;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                return FindPopupPanel.this.myHelper.isSkipResultsWithOneUsage();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    10.$$$reportNull$$$0(1);
                }
                FindPopupPanel.this.myHelper.setSkipResultsWithOneUsage(state);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(2);
                }
                super.update(e);
                e.getPresentation().setVisible(!FindPopupPanel.this.myHelper.isReplaceState());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0])){

            public boolean isDumbAware() {
                return true;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                return FindPopupPanel.this.myHelper.isUseSeparateView();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    11.$$$reportNull$$$0(1);
                }
                FindPopupPanel.this.myHelper.setUseSeparateView(state);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(2);
                }
                super.update(e);
                e.getPresentation().setEnabled(FindPopupPanel.this.myHelper.getModel().isOpenInNewTabEnabled());
                e.getPresentation().setVisible(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        tabResultsContextGroup.setPopup(true);
        Presentation tabSettingsPresentation = new Presentation();
        tabSettingsPresentation.setIcon(AllIcons.General.GearPlain);
        this.myTabResultsButton = new ActionButton((AnAction)tabResultsContextGroup, tabSettingsPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        DumbAwareAction.create(event -> this.myTabResultsButton.click()).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt ctrl DOWN"}), (JComponent)((Object)this));
        this.myOKButton = new JButton(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myReplaceAllButton = new JButton(FindBundle.message("find.popup.replace.all.button", new Object[0]));
        this.myReplaceSelectedButton = new JButton(FindBundle.message("find.popup.replace.selected.button", 0));
        this.myOkActionListener = __ -> this.doOK(true);
        this.myReplaceAllButton.addActionListener(__ -> this.doOK(false));
        this.myReplaceSelectedButton.addActionListener(e -> {
            int rowToSelect = this.myResultsPreviewTable.getSelectionModel().getMinSelectionIndex();
            Map<Integer, Usage> usages = this.getSelectedUsages();
            if (usages == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                for (Map.Entry entry : usages.entrySet()) {
                    try {
                        ReplaceInProjectManager.getInstance(this.myProject).replaceUsage((Usage)entry.getValue(), this.myHelper.getModel(), Collections.emptySet(), false);
                        ((DefaultTableModel)this.myResultsPreviewTable.getModel()).removeRow((Integer)entry.getKey());
                    }
                    catch (FindManager.MalformedReplacementStringException ex) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) break;
                        Messages.showErrorDialog((Component)((Object)this), (String)ex.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                        break;
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myResultsPreviewTable.getRowCount() > rowToSelect) {
                        this.myResultsPreviewTable.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
                    }
                    ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
                });
            }, FindBundle.message("find.replace.command", new Object[0]), null);
        });
        this.myOKButton.addActionListener(this.myOkActionListener);
        final boolean enterAsOK = Registry.is((String)"ide.find.enter.as.ok", (boolean)false);
        new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(e.getData(CommonDataKeys.EDITOR) == null || SwingUtilities.isDescendingFrom((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT), (Component)FindPopupPanel.this.myFileMaskField));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(1);
                }
                if (SwingUtilities.isDescendingFrom((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT), (Component)FindPopupPanel.this.myFileMaskField) && FindPopupPanel.this.myFileMaskField.isPopupVisible()) {
                    FindPopupPanel.this.myFileMaskField.hidePopup();
                    return;
                }
                if (FindPopupPanel.this.myScopeUI.hideAllPopups()) {
                    return;
                }
                if (enterAsOK) {
                    FindPopupPanel.this.myOkActionListener.actionPerformed(null);
                } else if (FindPopupPanel.this.myHelper.isReplaceState()) {
                    FindPopupPanel.this.myReplaceSelectedButton.doClick();
                } else {
                    FindPopupPanel.this.navigateToSelectedUsage(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$12";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER), (JComponent)((Object)this));
        DumbAwareAction.create(__ -> this.processCtrlEnter()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER_WITH_MODIFIERS), (JComponent)((Object)this));
        DumbAwareAction.create(__ -> this.myReplaceAllButton.doClick()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(REPLACE_ALL), (JComponent)((Object)this));
        this.myReplaceAllButton.setToolTipText(KeymapUtil.getKeystrokeText((KeyStroke)REPLACE_ALL));
        ArrayList navigationKeyStrokes = ContainerUtil.newArrayList();
        KeyStroke viewSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getViewSource());
        if (viewSourceKeyStroke != null && !Comparing.equal((Object)viewSourceKeyStroke, (Object)ENTER_WITH_MODIFIERS) && !Comparing.equal((Object)viewSourceKeyStroke, (Object)ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(viewSourceKeyStroke, null));
        }
        if ((editSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource())) != null && !Comparing.equal((Object)editSourceKeyStroke, (Object)ENTER_WITH_MODIFIERS) && !Comparing.equal((Object)editSourceKeyStroke, (Object)ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(editSourceKeyStroke, null));
        }
        if (!navigationKeyStrokes.isEmpty()) {
            DumbAwareAction.create(e -> this.navigateToSelectedUsage((AnActionEvent)e)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(navigationKeyStrokes.toArray(Shortcut.EMPTY_ARRAY)), (JComponent)((Object)this));
        }
        this.mySearchComponent = new JBTextArea();
        this.mySearchComponent.setColumns(25);
        this.mySearchComponent.setRows(1);
        this.myReplaceComponent = new JBTextArea();
        this.myReplaceComponent.setColumns(25);
        this.myReplaceComponent.setRows(1);
        this.mySearchTextArea = new SearchTextArea(this.mySearchComponent, true, true);
        this.myReplaceTextArea = new SearchTextArea(this.myReplaceComponent, false, false);
        this.mySearchTextArea.setMultilineEnabled(Registry.is((String)"ide.find.as.popup.allow.multiline"));
        this.myReplaceTextArea.setMultilineEnabled(Registry.is((String)"ide.find.as.popup.allow.multiline"));
        Pair<FindPopupScopeUI.ScopeType, JComponent>[] scopeComponents = this.myScopeUI.getComponents();
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.myScopeDetailsPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)(UIUtil.isUnderDefaultMacTheme() ? 0 : 3)));
        ArrayList<MySelectScopeToggleAction> scopeActions = new ArrayList<MySelectScopeToggleAction>(scopeComponents.length);
        for (Pair<FindPopupScopeUI.ScopeType, JComponent> scopeComponent : scopeComponents) {
            FindPopupScopeUI.ScopeType scopeType = (FindPopupScopeUI.ScopeType)scopeComponent.first;
            scopeActions.add(new MySelectScopeToggleAction(scopeType));
            this.myScopeDetailsPanel.add(scopeType.name, (Component)scopeComponent.second);
        }
        this.myScopeSelectionToolbar = FindPopupPanel.createToolbar(scopeActions.toArray(AnAction.EMPTY_ARRAY));
        this.myScopeSelectionToolbar.setMinimumButtonSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.mySelectedScope = (FindPopupScopeUI.ScopeType)scopeComponents[0].first;
        this.myResultsPreviewTable = new JBTable(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.getWidth(), 1 + this.getRowHeight() * 4);
            }
        };
        this.myResultsPreviewTable.setFocusable(false);
        this.myResultsPreviewTable.getEmptyText().setShowAboveCenter(false);
        this.myResultsPreviewTable.setShowColumns(false);
        this.myResultsPreviewTable.getSelectionModel().setSelectionMode(2);
        this.myResultsPreviewTable.setShowGrid(false);
        this.myResultsPreviewTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (event.getSource() != FindPopupPanel.this.myResultsPreviewTable) {
                    return false;
                }
                FindPopupPanel.this.navigateToSelectedUsage(null);
                return true;
            }
        }.installOn((Component)this.myResultsPreviewTable);
        this.myResultsPreviewTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FindPopupPanel.this.myResultsPreviewTable.transferFocus();
            }
        });
        FindPopupPanel.applyFont(JBUI.Fonts.label(), new Component[]{this.myCbCaseSensitive, this.myCbPreserveCase, this.myCbWholeWordsOnly, this.myCbRegularExpressions, this.myResultsPreviewTable});
        for (JComponent component : tableAware = new JComponent[]{this.mySearchComponent, this.myReplaceComponent, this.myReplaceSelectedButton}) {
            ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, (JComponent)component);
        }
        ActionListener helpAction = __ -> HelpManager.getInstance().invokeHelp("reference.dialogs.findinpath");
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 2);
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        Keymap keymap = activeKeymap = keymapManager2 != null ? keymapManager2.getActiveKeymap() : null;
        if (activeKeymap != null) {
            CustomShortcutSet findNextShortcutSet = new CustomShortcutSet(activeKeymap.getShortcuts("FindNext"));
            CustomShortcutSet findPreviousShortcutSet = new CustomShortcutSet(activeKeymap.getShortcuts("FindPrevious"));
            DumbAwareAction findNextAction = DumbAwareAction.create(event -> {
                int selectedRow = this.myResultsPreviewTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < this.myResultsPreviewTable.getRowCount() - 1) {
                    this.myResultsPreviewTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                    ScrollingUtil.ensureIndexIsVisible((JTable)this.myResultsPreviewTable, (int)(selectedRow + 1), (int)1);
                }
            });
            DumbAwareAction findPreviousAction = DumbAwareAction.create(event -> {
                int selectedRow = this.myResultsPreviewTable.getSelectedRow();
                if (selectedRow > 0 && selectedRow <= this.myResultsPreviewTable.getRowCount() - 1) {
                    this.myResultsPreviewTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                    ScrollingUtil.ensureIndexIsVisible((JTable)this.myResultsPreviewTable, (int)(selectedRow - 1), (int)1);
                }
            });
            for (JComponent component : tableAware) {
                findNextAction.registerCustomShortcutSet((ShortcutSet)findNextShortcutSet, component);
                findPreviousAction.registerCustomShortcutSet((ShortcutSet)findPreviousShortcutSet, component);
            }
        }
        this.myUsageViewPresentation = new UsageViewPresentation();
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, this.myUsageViewPresentation, Registry.is((String)"ide.find.as.popup.editable.code")){

            public Dimension getPreferredSize() {
                return new Dimension(FindPopupPanel.this.myResultsPreviewTable.getWidth(), Math.max(this.getHeight(), this.getLineHeight() * 15));
            }

            @NotNull
            protected EditorKind getEditorKind() {
                EditorKind editorKind = EditorKind.PREVIEW_UNDER_READ_ACTION;
                if (editorKind == null) {
                    16.$$$reportNull$$$0(0);
                }
                return editorKind;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel$16", "getEditorKind"));
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUsagePreviewPanel);
        final Runnable updatePreviewRunnable = () -> {
            if (Disposer.isDisposed((Disposable)this.myDisposable)) {
                return;
            }
            int[] selectedRows = this.myResultsPreviewTable.getSelectedRows();
            SmartList selection = new SmartList();
            VirtualFile file2 = null;
            for (int row2 : selectedRows) {
                UsageInfo2UsageAdapter adapter = (UsageInfo2UsageAdapter)this.myResultsPreviewTable.getModel().getValueAt(row2, 0);
                file2 = adapter.getFile();
                if (!adapter.isValid()) continue;
                selection.addAll(Arrays.asList(adapter.getMergedInfos()));
            }
            String title = this.getTitle(file2);
            this.myReplaceSelectedButton.setText(FindBundle.message("find.popup.replace.selected.button", selection.size()));
            FindInProjectUtil.setupViewPresentation(this.myUsageViewPresentation, FindSettings.getInstance().isShowResultsInSeparateView(), this.myHelper.getModel().clone());
            this.myUsagePreviewPanel.updateLayout((List)selection);
            if (this.myUsagePreviewPanel.getCannotPreviewMessage((List)selection) == null && title != null) {
                this.myUsagePreviewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false, (Insets)new JBInsets(8, 0, 0, 0)).setShowLine(false));
            } else {
                this.myUsagePreviewPanel.setBorder((Border)JBUI.Borders.empty());
            }
        };
        this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting() || Disposer.isDisposed((Disposable)this.myPreviewUpdater)) {
                return;
            }
            this.myPreviewUpdater.addRequest(updatePreviewRunnable, 50);
        });
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    17.$$$reportNull$$$0(0);
                }
                int maxRows = Math.max(1, Math.min(25, Registry.get((String)"ide.find.as.popup.max.rows").asInteger()));
                FindPopupPanel.this.mySearchComponent.setRows(Math.max(1, Math.min(maxRows, StringUtil.countChars((CharSequence)FindPopupPanel.this.mySearchComponent.getText(), (char)'\n') + 1)));
                FindPopupPanel.this.myReplaceComponent.setRows(Math.max(1, Math.min(maxRows, StringUtil.countChars((CharSequence)FindPopupPanel.this.myReplaceComponent.getText(), (char)'\n') + 1)));
                if (FindPopupPanel.this.myDialog == null) {
                    return;
                }
                if (e.getDocument() == FindPopupPanel.this.mySearchComponent.getDocument()) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
                if (e.getDocument() == FindPopupPanel.this.myReplaceComponent.getDocument()) {
                    FindPopupPanel.this.applyTo(FindPopupPanel.this.myHelper.getModel());
                    if (FindPopupPanel.this.myHelper.getModel().isRegularExpressions()) {
                        FindPopupPanel.this.myComponentValidator.updateInfo(FindPopupPanel.this.getValidationInfo(FindPopupPanel.this.myHelper.getModel()));
                    }
                    ApplicationManager.getApplication().invokeLater(updatePreviewRunnable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$17", "textChanged"));
            }
        };
        this.mySearchComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.myReplaceComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
        JBSplitter splitter = new JBSplitter(true, 0.33f);
        splitter.setSplitterProportionKey(SPLITTER_SERVICE_KEY);
        splitter.setDividerWidth(JBUI.scale((int)2));
        splitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myResultsPreviewTable){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.height = ((FindPopupPanel)FindPopupPanel.this).myResultsPreviewTable.getPreferredScrollableViewportSize().height;
                return size;
            }
        };
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        splitter.setFirstComponent((JComponent)scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 4 4 0 4, fillx, hidemode 3, gap 0"));
        bottomPanel.add(this.myTabResultsButton);
        this.myOKHintLabel = new JBLabel("");
        this.myOKHintLabel.setEnabled(false);
        this.myNavigationHintLabel = new JBLabel("");
        this.myNavigationHintLabel.setEnabled(false);
        this.myNavigationHintLabel.setFont((Font)JBUI.Fonts.smallFont());
        Insets insets = this.myOKButton.getInsets();
        String btnGapLeft = "gapleft " + Math.max(0, JBUI.scale((int)12) - insets.left - insets.right);
        bottomPanel.add((Component)this.myNavigationHintLabel, btnGapLeft);
        bottomPanel.add(Box.createHorizontalGlue(), "growx, pushx");
        bottomPanel.add((Component)this.myOKHintLabel);
        bottomPanel.add((Component)this.myOKButton, btnGapLeft);
        bottomPanel.add((Component)this.myReplaceAllButton, btnGapLeft);
        bottomPanel.add((Component)this.myReplaceSelectedButton, btnGapLeft);
        this.myCodePreviewComponent = this.myUsagePreviewPanel.createComponent();
        splitter.setSecondComponent(this.myCodePreviewComponent);
        JPanel scopesPanel = new JPanel((LayoutManager)new MigLayout("flowx, gap 26, ins 0"));
        scopesPanel.add(this.myScopeSelectionToolbar.getComponent());
        scopesPanel.add((Component)this.myScopeDetailsPanel, "growx, pushx");
        this.setLayout((LayoutManager)new MigLayout("flowx, ins 4, gap 0, fillx, hidemode 3"));
        this.myTitlePanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 0, gap 0, fillx, filly"));
        this.myTitlePanel.add(this.myTitleLabel);
        this.myTitlePanel.add((Component)this.myLoadingDecorator.getComponent(), "w 24, wmin 24");
        this.myTitlePanel.add(Box.createHorizontalGlue(), "growx, pushx");
        JPanel regexpPanel = new JPanel(new BorderLayout(JBUI.scale((int)4), 0));
        regexpPanel.add((Component)this.myCbRegularExpressions, "Center");
        regexpPanel.add((Component)RegExHelpPopup.createRegExLink("<html><body><b>?</b></body></html>", this.myCbRegularExpressions, LOG), "East");
        int gap = 16;
        AnAction[] actions = new AnAction[]{new DefaultCustomComponentAction(() -> this.myCbCaseSensitive), new DefaultCustomComponentAction(() -> (StateRestoringCheckBox)JBUI.Borders.emptyLeft((int)gap).wrap((JComponent)this.myCbPreserveCase)), new DefaultCustomComponentAction(() -> (StateRestoringCheckBox)JBUI.Borders.emptyLeft((int)gap).wrap((JComponent)this.myCbWholeWordsOnly)), new DefaultCustomComponentAction(() -> (JPanel)JBUI.Borders.emptyLeft((int)gap).wrap((JComponent)regexpPanel))};
        ActionToolbarImpl checkboxesToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)new DefaultActionGroup(actions), true);
        checkboxesToolbar.setForceShowFirstComponent(true);
        checkboxesToolbar.setSkipWindowAdjustments(true);
        this.add(this.myTitlePanel, "sx 2, growx, growx, growy");
        this.add(checkboxesToolbar, "gapright 8, growx 200, pushx, wmax pref, ax right");
        this.add(this.myCbFileFilter);
        this.add((Component)this.myFileMaskField, "gapleft 4, gapright 16");
        if (Registry.is((String)"ide.find.as.popup.allow.pin") || ApplicationManager.getApplication().isInternal()) {
            this.myIsPinned.set(UISettings.getInstance().getPinFindInPath());
            JPanel twoButtons = new JPanel(new GridLayout(1, 2, 4, 0));
            twoButtons.add(this.myFilterContextButton);
            twoButtons.add(this.myPinButton);
            this.add(twoButtons, "wrap");
        } else {
            this.add(this.myFilterContextButton, "wrap");
        }
        this.add((Component)((Object)this.mySearchTextArea), "pushx, growx, sx 10, gaptop 4, wrap");
        this.add((Component)((Object)this.myReplaceTextArea), "pushx, growx, sx 10, gaptop 4, wrap");
        this.add(scopesPanel, "sx 10, pushx, growx, ax left, wrap, gaptop 4, gapbottom 4");
        this.add((Component)splitter, "pushx, growx, growy, pushy, sx 10, wrap, pad -4 -4 4 4");
        this.add(bottomPanel, "pushx, growx, dock south, sx 10");
        MnemonicHelper.init((Component)((Object)this));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getFirstComponent(Container aContainer) {
                return FindPopupPanel.this.mySearchComponent;
            }

            @Override
            public Component getComponentAfter(Container container, Component c) {
                return c == FindPopupPanel.this.myResultsPreviewTable ? FindPopupPanel.this.mySearchComponent : super.getComponentAfter(container, c);
            }
        });
    }

    private void processCtrlEnter() {
        if (Registry.is((String)"ide.find.enter.as.ok", (boolean)false)) {
            this.navigateToSelectedUsage(null);
        } else {
            this.myOkActionListener.actionPerformed(null);
        }
    }

    private void onFileMaskChanged() {
        Object item = this.myFileMaskField.getEditor().getItem();
        if (item != null && !item.equals(this.myFileMaskField.getSelectedItem())) {
            this.myFileMaskField.setSelectedItem(item);
        }
        this.scheduleResultsUpdate();
    }

    private void closeImmediately() {
        if (this.canBeClosedImmediately() && this.myDialog != null && this.myDialog.isVisible()) {
            this.myIsPinned.set(false);
            this.myDialog.doCancelAction();
        }
    }

    private boolean canBeClosedImmediately() {
        boolean state = this.myIsPinned.get();
        this.myIsPinned.set(false);
        try {
            boolean bl = this.myDialog != null && this.canBeClosed();
            return bl;
        }
        finally {
            this.myIsPinned.set(state);
        }
    }

    private void doOK(boolean openInFindWindow) {
        if (!this.canBeClosedImmediately()) {
            return;
        }
        FindModel validateModel = this.myHelper.getModel().clone();
        this.applyTo(validateModel);
        ValidationInfo validationInfo = this.getValidationInfo(validateModel);
        if (validationInfo == null) {
            if (validateModel.isReplaceState() && !openInFindWindow && this.myResultsPreviewTable.getRowCount() > 1 && !ReplaceInProjectManager.getInstance(this.myProject).showReplaceAllConfirmDialog(this.myUsagesCount, this.getStringToFind(), this.myFilesCount, this.getStringToReplace())) {
                return;
            }
        } else {
            String message = validationInfo.message;
            Messages.showMessageDialog((Component)((Object)this), (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.myHelper.getModel().copyFrom(validateModel);
        this.myHelper.getModel().setPromptOnReplace(openInFindWindow);
        this.myHelper.doOKAction();
        this.myIsPinned.set(false);
        this.myDialog.doCancelAction();
    }

    @Nullable
    private String getTitle(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        String path = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)this.myProject.getBaseDir());
        if (path == null) {
            path = file2.getPath();
        }
        return "<html><body>&nbsp;&nbsp;&nbsp;" + path.replace(file2.getName(), "<b>" + file2.getName() + "</b>") + "</body></html>";
    }

    @NotNull
    private static StateRestoringCheckBox createCheckBox(String message) {
        StateRestoringCheckBox checkBox2 = new StateRestoringCheckBox(FindBundle.message(message, new Object[0]));
        checkBox2.setFocusable(false);
        StateRestoringCheckBox stateRestoringCheckBox = checkBox2;
        if (stateRestoringCheckBox == null) {
            FindPopupPanel.$$$reportNull$$$0(5);
        }
        return stateRestoringCheckBox;
    }

    public void addNotify() {
        super.addNotify();
        ApplicationManager.getApplication().invokeLater(() -> ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable), ModalityState.any());
        this.myScopeSelectionToolbar.updateActionsImmediately();
    }

    @Override
    public void initByModel() {
        FindModel myModel = this.myHelper.getModel();
        this.myCbCaseSensitive.setSelected(myModel.isCaseSensitive());
        this.myCbWholeWordsOnly.setSelected(myModel.isWholeWordsOnly());
        this.myCbRegularExpressions.setSelected(myModel.isRegularExpressions());
        this.mySelectedContextName = FindDialog.getSearchContextName(myModel);
        if (myModel.isReplaceState()) {
            this.myCbPreserveCase.setSelected(myModel.isPreserveCase());
        }
        this.mySelectedScope = this.myScopeUI.initByModel(myModel);
        boolean isThereFileFilter = myModel.getFileFilter() != null && !myModel.getFileFilter().isEmpty();
        try {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", Boolean.TRUE);
            this.myCbFileFilter.setSelected(isThereFileFilter);
        }
        finally {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", null);
        }
        this.myFileMaskField.removeAllItems();
        List<Object> variants = Arrays.asList(ArrayUtil.reverseArray((Object[])FindSettings.getInstance().getRecentFileMasks()));
        for (String string : variants) {
            this.myFileMaskField.addItem((Object)string);
        }
        if (!variants.isEmpty()) {
            this.myFileMaskField.setSelectedItem(variants.get(0));
        }
        this.myFileMaskField.setEnabled(isThereFileFilter);
        String toSearch = myModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
        if (StringUtil.isEmpty((String)toSearch)) {
            String[] history = findInProjectSettings.getRecentFindStrings();
            toSearch = history.length > 0 ? history[history.length - 1] : "";
        }
        this.mySearchComponent.setText(toSearch);
        String toReplace = myModel.getStringToReplace();
        if (StringUtil.isEmpty((String)toReplace)) {
            String[] history = findInProjectSettings.getRecentReplaceStrings();
            toReplace = history.length > 0 ? history[history.length - 1] : "";
        }
        this.myReplaceComponent.setText(toReplace);
        this.updateControls();
        this.updateScopeDetailsPanel();
        boolean isReplaceState = this.myHelper.isReplaceState();
        this.myTitleLabel.setText(this.myHelper.getTitle());
        this.myReplaceTextArea.setVisible(isReplaceState);
        this.myCbPreserveCase.setVisible(isReplaceState);
        if (Registry.is((String)"ide.find.enter.as.ok", (boolean)false)) {
            this.myOKHintLabel.setText(KeymapUtil.getKeystrokeText((KeyStroke)ENTER));
        } else {
            this.myOKHintLabel.setText(KeymapUtil.getKeystrokeText((KeyStroke)ENTER_WITH_MODIFIERS));
        }
        this.myOKButton.setText(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myReplaceAllButton.setVisible(isReplaceState);
        this.myReplaceSelectedButton.setVisible(isReplaceState);
    }

    private void updateControls() {
        FindModel myModel = this.myHelper.getModel();
        if (this.myCbRegularExpressions.isSelected()) {
            this.myCbWholeWordsOnly.makeUnselectable(false);
        } else {
            this.myCbWholeWordsOnly.makeSelectable();
        }
        if (myModel.isReplaceState()) {
            if (this.myCbRegularExpressions.isSelected() || this.myCbCaseSensitive.isSelected()) {
                this.myCbPreserveCase.makeUnselectable(false);
            } else {
                this.myCbPreserveCase.makeSelectable();
            }
            if (this.myCbPreserveCase.isSelected()) {
                this.myCbRegularExpressions.makeUnselectable(false);
                this.myCbCaseSensitive.makeUnselectable(false);
            } else {
                this.myCbRegularExpressions.makeSelectable();
                this.myCbCaseSensitive.makeSelectable();
            }
        }
        this.myReplaceAllButton.setVisible(this.myHelper.isReplaceState());
        this.myReplaceSelectedButton.setVisible(this.myHelper.isReplaceState());
        this.myNavigationHintLabel.setVisible(this.mySearchComponent.getText().contains("\n"));
        if (this.myNavigationHintLabel.isVisible()) {
            Keymap activeKeymap;
            this.myNavigationHintLabel.setText("");
            KeymapManager keymapManager2 = KeymapManager.getInstance();
            Keymap keymap = activeKeymap = keymapManager2 != null ? keymapManager2.getActiveKeymap() : null;
            if (activeKeymap != null) {
                String findNextText = KeymapUtil.getFirstKeyboardShortcutText((String)"FindNext");
                String findPreviousText = KeymapUtil.getFirstKeyboardShortcutText((String)"FindPrevious");
                if (!StringUtil.isEmpty((String)findNextText) && !StringUtil.isEmpty((String)findPreviousText)) {
                    this.myNavigationHintLabel.setText("Use " + findNextText + " and " + findPreviousText + " to select usages");
                }
            }
        }
    }

    private void updateScopeDetailsPanel() {
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.mySelectedScope.name);
        Component firstFocusableComponent = (Component)UIUtil.uiTraverser((Component)this.myScopeDetailsPanel).bfsTraversal().find(c -> c.isFocusable() && c.isEnabled() && c.isShowing() && (c instanceof JComboBox || c instanceof AbstractButton || c instanceof JTextComponent));
        this.myScopeDetailsPanel.revalidate();
        this.myScopeDetailsPanel.repaint();
        if (firstFocusableComponent != null) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(firstFocusableComponent, true));
        }
        if (firstFocusableComponent == null && !this.mySearchComponent.isFocusOwner() && !this.myReplaceComponent.isFocusOwner()) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchComponent, true));
        }
    }

    public void scheduleResultsUpdate() {
        if (this.myDialog == null || !this.myDialog.isVisible()) {
            return;
        }
        if (this.mySearchRescheduleOnCancellationsAlarm == null || this.mySearchRescheduleOnCancellationsAlarm.isDisposed()) {
            return;
        }
        this.updateControls();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.mySearchRescheduleOnCancellationsAlarm.addRequest(this::findSettingsChanged, 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    private void findSettingsChanged() {
        ProgressIndicatorBase progressIndicatorWhenSearchStarted;
        if (this.isShowing()) {
            ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
        }
        final ModalityState state = ModalityState.current();
        this.finishPreviousPreviewSearch();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.applyTo(this.myHelper.getModel());
        final FindModel findModel = new FindModel();
        findModel.copyFrom(this.myHelper.getModel());
        if (findModel.getStringToFind().contains("\n") && Registry.is((String)"ide.find.ignores.leading.whitespace.in.multiline.search")) {
            findModel.setMultiline(true);
        }
        ValidationInfo result2 = this.getValidationInfo(this.myHelper.getModel());
        this.myComponentValidator.updateInfo(result2);
        this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase(){

            @Override
            public void stop() {
                super.stop();
                FindPopupPanel.this.onStop(System.identityHashCode(this));
            }
        };
        final int hash = System.identityHashCode(this.myResultsPreviewSearchProgress);
        final DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row2, int column) {
                return false;
            }
        };
        model.addColumn("Usages");
        final LinkedHashSet<VirtualFile> filesToScanInitially = new LinkedHashSet<VirtualFile>();
        if (this.myHelper.myPreviousModel != null && this.myHelper.myPreviousModel.getStringToFind().length() < this.myHelper.getModel().getStringToFind().length()) {
            DefaultTableModel previousModel = (DefaultTableModel)this.myResultsPreviewTable.getModel();
            int len = previousModel.getRowCount();
            for (int i = 0; i < len; ++i) {
                UsageInfo2UsageAdapter usage = (UsageInfo2UsageAdapter)previousModel.getValueAt(i, 0);
                VirtualFile file2 = usage.getFile();
                if (file2 == null) continue;
                filesToScanInitially.add(file2);
            }
        }
        this.myHelper.myPreviousModel = this.myHelper.getModel().clone();
        this.myReplaceAllButton.setEnabled(false);
        this.myReplaceSelectedButton.setEnabled(false);
        this.myReplaceSelectedButton.setText(FindBundle.message("find.popup.replace.selected.button", 0));
        this.myCodePreviewComponent.setVisible(false);
        this.mySearchTextArea.setInfoText(null);
        this.myResultsPreviewTable.setModel((TableModel)model);
        if (result2 != null) {
            this.onStop(hash, result2.message);
            return;
        }
        GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope(FindInProjectUtil.getScopeFromModel(this.myProject, this.myHelper.myPreviousModel), this.myProject);
        this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new FindDialog.UsageTableCellRenderer(this.myCbFileFilter.isSelected(), false, scope));
        this.onStart(hash);
        final AtomicInteger resultsCount = new AtomicInteger();
        final AtomicInteger resultsFilesCount = new AtomicInteger();
        final FindSettings findSettings = FindSettings.getInstance();
        FindInProjectUtil.setupViewPresentation(this.myUsageViewPresentation, findSettings.isShowResultsInSeparateView(), findModel);
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myResultsPreviewSearchProgress, new ReadTask(){

            @Override
            public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    22.$$$reportNull$$$0(0);
                }
                boolean showPanelIfOnlyOneUsage = !findSettings.isSkipResultsWithOneUsage();
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(FindPopupPanel.this.myProject, showPanelIfOnlyOneUsage, FindPopupPanel.this.myUsageViewPresentation);
                ThreadLocal lastUsageFileRef = new ThreadLocal();
                ThreadLocal recentUsageRef = new ThreadLocal();
                FindInProjectUtil.findUsages(findModel, FindPopupPanel.this.myProject, processPresentation, filesToScanInitially, (Processor<? super UsageInfo>)((Processor)info -> {
                    boolean continueSearch;
                    boolean merged;
                    Usage recent;
                    if (this.isCancelled()) {
                        FindPopupPanel.this.onStop(hash);
                        return false;
                    }
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    VirtualFile file2 = (VirtualFile)lastUsageFileRef.get();
                    VirtualFile usageFile = info.getVirtualFile();
                    if (file2 == null || !file2.equals(usageFile)) {
                        resultsFilesCount.incrementAndGet();
                        lastUsageFileRef.set(usageFile);
                    }
                    UsageInfo2UsageAdapter recentAdapter = (recent = (Usage)recentUsageRef.get()) instanceof UsageInfo2UsageAdapter ? (UsageInfo2UsageAdapter)recent : null;
                    UsageInfo2UsageAdapter currentAdapter = usage instanceof UsageInfo2UsageAdapter ? (UsageInfo2UsageAdapter)usage : null;
                    boolean bl = merged = !FindPopupPanel.this.myHelper.isReplaceState() && currentAdapter != null && recentAdapter != null && recentAdapter.merge((MergeableUsage)currentAdapter);
                    if (!merged) {
                        recentUsageRef.set(usage);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isCancelled()) {
                            FindPopupPanel.this.onStop(hash);
                            return;
                        }
                        if (!merged) {
                            model.addRow(new Object[]{usage});
                        } else {
                            model.fireTableRowsUpdated(model.getRowCount() - 1, model.getRowCount() - 1);
                        }
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(true);
                        if (model.getRowCount() == 1 && FindPopupPanel.this.myResultsPreviewTable.getModel() == model) {
                            FindPopupPanel.this.myResultsPreviewTable.setRowSelectionInterval(0, 0);
                        }
                        int occurrences = resultsCount.get();
                        int filesWithOccurrences = resultsFilesCount.get();
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(occurrences > 0);
                        FindPopupPanel.this.myReplaceAllButton.setEnabled(occurrences > 0);
                        FindPopupPanel.this.myReplaceSelectedButton.setEnabled(occurrences > 0);
                        StringBuilder stringBuilder = new StringBuilder();
                        if (occurrences > 0) {
                            stringBuilder.append(Math.min(ShowUsagesAction.getUsagesPageSize(), occurrences));
                            boolean foundAllUsages = occurrences < ShowUsagesAction.getUsagesPageSize();
                            FindPopupPanel.this.myUsagesCount = String.valueOf(occurrences);
                            if (!foundAllUsages) {
                                stringBuilder.append("+");
                                FindPopupPanel.this.myUsagesCount = FindPopupPanel.this.myUsagesCount + "+";
                            }
                            stringBuilder.append(UIBundle.message((String)"message.matches", (Object[])new Object[]{occurrences}));
                            stringBuilder.append(" in ");
                            stringBuilder.append(filesWithOccurrences);
                            FindPopupPanel.this.myFilesCount = String.valueOf(filesWithOccurrences);
                            if (!foundAllUsages) {
                                stringBuilder.append("+");
                                FindPopupPanel.this.myFilesCount = FindPopupPanel.this.myFilesCount + "+";
                            }
                            stringBuilder.append(UIBundle.message((String)"message.files", (Object[])new Object[]{filesWithOccurrences}));
                        }
                        FindPopupPanel.this.mySearchTextArea.setInfoText(stringBuilder.toString());
                    }, state);
                    boolean bl2 = continueSearch = resultsCount.incrementAndGet() < ShowUsagesAction.getUsagesPageSize();
                    if (!continueSearch) {
                        FindPopupPanel.this.onStop(hash);
                    }
                    return continueSearch;
                }));
                return new ReadTask.Continuation(() -> {
                    if (!this.isCancelled() && resultsCount.get() == 0) {
                        FindPopupPanel.this.showEmptyText(null);
                    }
                    FindPopupPanel.this.onStop(hash);
                }, state);
            }

            boolean isCancelled() {
                return progressIndicatorWhenSearchStarted != FindPopupPanel.this.myResultsPreviewSearchProgress || progressIndicatorWhenSearchStarted.isCanceled();
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    22.$$$reportNull$$$0(1);
                }
                if (FindPopupPanel.this.isShowing() && progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "indicator";
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$22";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performInReadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCanceled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void showEmptyText(@Nullable String message) {
        StatusText emptyText = this.myResultsPreviewTable.getEmptyText();
        emptyText.clear();
        emptyText.setText(message != null ? UIBundle.message((String)"message.nothingToShow.with.problem", (Object[])new Object[]{message}) : UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
        if (this.mySelectedScope == FindPopupScopeUIImpl.DIRECTORY && !this.myHelper.getModel().isWithSubdirectories()) {
            emptyText.appendSecondaryText(FindBundle.message("find.recursively.hint", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> {
                this.myHelper.getModel().setWithSubdirectories(true);
                this.scheduleResultsUpdate();
            });
        }
    }

    private void onStart(int hash) {
        this.myLoadingHash = hash;
        this.myLoadingDecorator.startLoading(false);
        this.myResultsPreviewTable.getEmptyText().setText("Searching...");
    }

    private void onStop(int hash) {
        this.onStop(hash, null);
    }

    private void onStop(int hash, String message) {
        if (hash != this.myLoadingHash) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            this.showEmptyText(message);
            this.myLoadingDecorator.stopLoading();
        });
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        String mask = null;
        if (this.myCbFileFilter != null && this.myCbFileFilter.isSelected()) {
            mask = (String)this.myFileMaskField.getSelectedItem();
        }
        return mask;
    }

    @Nullable(value="null means OK")
    private ValidationInfo getValidationInfo(@NotNull FindModel model) {
        String mask;
        ValidationInfo scopeValidationInfo;
        if (model == null) {
            FindPopupPanel.$$$reportNull$$$0(6);
        }
        if ((scopeValidationInfo = this.myScopeUI.validate(model, this.mySelectedScope)) != null) {
            return scopeValidationInfo;
        }
        if (!this.myHelper.canSearchThisString()) {
            return new ValidationInfo(FindBundle.message("find.empty.search.text.error", new Object[0]), (JComponent)this.mySearchComponent);
        }
        if (model.isRegularExpressions()) {
            String toFind = model.getStringToFind();
            try {
                Pattern pattern = Pattern.compile(toFind, model.isCaseSensitive() ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.mySearchComponent);
                }
            }
            catch (PatternSyntaxException e) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e.getDescription()), (JComponent)this.mySearchComponent);
            }
            if (model.isReplaceState()) {
                Object value;
                if (this.myResultsPreviewTable.getRowCount() > 0 && (value = this.myResultsPreviewTable.getModel().getValueAt(0, 0)) instanceof Usage) {
                    try {
                        ReplaceInProjectManager.getInstance(this.myProject).replaceUsage((Usage)value, model, Collections.emptySet(), true);
                    }
                    catch (FindManager.MalformedReplacementStringException e) {
                        return new ValidationInfo(e.getMessage(), (JComponent)this.myReplaceComponent);
                    }
                }
                try {
                    String stringToReplace = this.getStringToReplace();
                    stringToReplace = stringToReplace.replaceAll("(\\\\U|\\\\L|\\\\u|\\\\l|\\\\E)", "\\\\$1");
                    Pattern.compile(stringToReplace);
                }
                catch (PatternSyntaxException e) {
                    return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", this.getStringToReplace(), e.getDescription()), (JComponent)this.myReplaceComponent);
                }
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), this.myFileMaskField);
            }
            if (mask.contains(";")) {
                return new ValidationInfo("File masks should be comma-separated", this.myFileMaskField);
            }
            try {
                FindPopupPanel.createFileMaskRegExp(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), this.myFileMaskField);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getStringToFind() {
        String string = this.mySearchComponent.getText();
        if (string == null) {
            FindPopupPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getStringToReplace() {
        String string = this.myReplaceComponent.getText();
        if (string == null) {
            FindPopupPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void applyTo(@NotNull FindModel model) {
        if (model == null) {
            FindPopupPanel.$$$reportNull$$$0(9);
        }
        model.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        if (model.isReplaceState()) {
            model.setPreserveCase(this.myCbPreserveCase.isSelected());
        }
        model.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        String selectedSearchContextInUi = this.mySelectedContextName;
        FindModel.SearchContext searchContext = FindDialog.parseSearchContext(selectedSearchContextInUi);
        model.setSearchContext(searchContext);
        model.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        model.setStringToFind(this.getStringToFind());
        if (model.isReplaceState()) {
            model.setStringToReplace(StringUtil.convertLineSeparators((String)this.getStringToReplace()));
        }
        model.setProjectScope(false);
        model.setDirectoryName(null);
        model.setModuleName(null);
        model.setCustomScopeName(null);
        model.setCustomScope(null);
        model.setCustomScope(false);
        this.myScopeUI.applyTo(model, this.mySelectedScope);
        model.setFindAll(false);
        String mask = this.getFileTypeMask();
        model.setFileFilter(mask);
    }

    private void navigateToSelectedUsage(@Nullable AnActionEvent e) {
        Navigatable[] navigatables;
        Navigatable[] navigatableArray = navigatables = e != null ? (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY) : null;
        if (navigatables != null) {
            this.myDialog.doCancelAction();
            OpenSourceUtil.navigate((Navigatable[])navigatables);
            return;
        }
        Map<Integer, Usage> usages = this.getSelectedUsages();
        if (usages != null) {
            this.myDialog.doCancelAction();
            boolean first = true;
            for (Usage usage : usages.values()) {
                if (first) {
                    usage.navigate(true);
                } else {
                    usage.highlightInEditor();
                }
                first = false;
            }
        }
    }

    @Nullable
    private Map<Integer, Usage> getSelectedUsages() {
        int[] rows = this.myResultsPreviewTable.getSelectedRows();
        LinkedHashMap result2 = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            int row2 = rows[i];
            Object valueAt = this.myResultsPreviewTable.getModel().getValueAt(row2, 0);
            if (!(valueAt instanceof Usage)) continue;
            if (result2 == null) {
                result2 = ContainerUtil.newLinkedHashMap();
            }
            result2.put(row2, (Usage)valueAt);
        }
        return result2;
    }

    public static ActionToolbarImpl createToolbar(AnAction ... actions) {
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        toolbar.setForceMinimumSize(true);
        toolbar.setLayoutPolicy(0);
        return toolbar;
    }

    private static void applyFont(JBFont font, Component ... components) {
        for (Component component : components) {
            component.setFont((Font)font);
        }
    }

    private static void createFileMaskRegExp(@Nullable String filter) throws PatternSyntaxException {
        if (filter == null) {
            return;
        }
        List strings = StringUtil.split((String)filter, (String)",");
        String pattern = strings.size() == 1 ? PatternUtil.convertToRegex((String)filter.trim()) : StringUtil.join((Collection)strings, s -> "(" + PatternUtil.convertToRegex((String)s.trim()) + ")", (String)"|");
        Pattern.compile(pattern, 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindPopupPanel";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindPopupPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanClose";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckBox";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToFind";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValidationInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyShowFilterPopupAction
    extends DumbAwareAction {
        private final DefaultActionGroup mySwitchContextGroup;

        MyShowFilterPopupAction() {
            super(FindBundle.message("find.popup.show.filter.popup", new Object[0]), null, AllIcons.General.Filter);
            LayeredIcon icon = (LayeredIcon)JBUI.scale((JBUI.JBIcon)new LayeredIcon(2));
            icon.setIcon(AllIcons.General.Filter, 0);
            icon.setIcon(AllIcons.General.Dropdown, 1, 3, 0);
            this.getTemplatePresentation().setIcon((Icon)icon);
            KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowFilterPopup");
            if (keyboardShortcut != null) {
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{keyboardShortcut}));
            }
            this.mySwitchContextGroup = new DefaultActionGroup();
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.ANY));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS));
            this.mySwitchContextGroup.setPopup(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowFilterPopupAction.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext()) == null) {
                return;
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.mySwitchContextGroup, e.getDataContext(), false, null, 10);
            listPopup.showUnderneathOf((Component)FindPopupPanel.this.myFilterContextButton);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$MyShowFilterPopupAction", "actionPerformed"));
        }
    }

    private class MySelectScopeToggleAction
    extends DumbAwareToggleAction {
        private final FindPopupScopeUI.ScopeType myScope;

        MySelectScopeToggleAction(FindPopupScopeUI.ScopeType scope) {
            super(scope.text, null, scope.icon);
            this.getTemplatePresentation().setHoveredIcon(scope.icon);
            this.getTemplatePresentation().setDisabledIcon(scope.icon);
            this.myScope = scope;
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(0);
            }
            return FindPopupPanel.this.mySelectedScope == this.myScope;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MySelectScopeToggleAction.$$$reportNull$$$0(1);
            }
            if (state) {
                FindPopupPanel.this.mySelectedScope = this.myScope;
                FindPopupPanel.this.myScopeSelectionToolbar.updateActionsImmediately();
                FindPopupPanel.this.updateScopeDetailsPanel();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySelectScopeToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySwitchContextToggleAction
    extends ToggleAction
    implements DumbAware {
        MySwitchContextToggleAction(FindModel.SearchContext context) {
            super(FindDialog.getPresentableName(context));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(0);
            }
            return Comparing.equal((String)FindPopupPanel.this.mySelectedContextName, (String)this.getTemplatePresentation().getText());
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MySwitchContextToggleAction.$$$reportNull$$$0(1);
            }
            if (state) {
                FindPopupPanel.this.mySelectedContextName = this.getTemplatePresentation().getText();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/find/impl/FindPopupPanel$MySwitchContextToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

