/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyIntentionAction
extends AnAction {
    private final IntentionAction myAction;
    private final Editor myEditor;
    private final PsiFile myFile;

    public ApplyIntentionAction(HighlightInfo.IntentionActionDescriptor descriptor, String text, Editor editor, PsiFile file2) {
        this(descriptor.getAction(), text, editor, file2);
    }

    public ApplyIntentionAction(IntentionAction action, String text, Editor editor, PsiFile file2) {
        super(text);
        this.getTemplatePresentation().setText(text, false);
        this.myAction = action;
        this.myEditor = editor;
        this.myFile = file2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyIntentionAction.$$$reportNull$$$0(0);
        }
        PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitAllDocuments();
        ShowIntentionActionsHandler.chooseActionAndInvoke(this.myFile, this.myEditor, this.myAction, this.myAction.getText());
    }

    public String getName() {
        return (String)ReadAction.compute(() -> this.myAction.getText());
    }

    @Nullable
    public static ApplyIntentionAction[] getAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        ShowIntentionsPass.IntentionsInfo info;
        if (editor == null) {
            ApplyIntentionAction.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ApplyIntentionAction.$$$reportNull$$$0(2);
        }
        if ((info = ShowIntentionsPass.getActionsToShow(editor, file2)).isEmpty()) {
            return null;
        }
        ArrayList<HighlightInfo.IntentionActionDescriptor> actions = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        actions.addAll(info.errorFixesToShow);
        actions.addAll(info.inspectionFixesToShow);
        actions.addAll(info.intentionsToShow);
        ApplyIntentionAction[] result2 = new ApplyIntentionAction[actions.size()];
        for (int i = 0; i < result2.length; ++i) {
            HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)actions.get(i);
            String actionText = (String)ReadAction.compute(() -> descriptor.getAction().getText());
            result2[i] = new ApplyIntentionAction(descriptor, actionText, editor, file2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ApplyIntentionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAvailableIntentions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

