/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.Version;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceInfo {
    @NotNull
    NameVersion databaseVersion = NameVersion.UNKNOWN;
    @NotNull
    NameVersion driverVersion = NameVersion.UNKNOWN;
    @NotNull
    String jdbcVersion = DasUtil.NO_NAME;
    @Nullable
    String identifierQuoteString;
    @Nullable
    String extraNameCharacters;
    @NotNull
    Casing casing = DasUtil.CASING_MIXED;
    Dbms dbms;
    Version exactVersion;
    Version exactDriverVersion;

    DataSourceInfo() {
    }

    void copyFrom(@NotNull DataSourceInfo info) {
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(0);
        }
        this.databaseVersion = info.databaseVersion;
        this.driverVersion = info.driverVersion;
        this.jdbcVersion = info.jdbcVersion;
        this.identifierQuoteString = info.identifierQuoteString;
        this.extraNameCharacters = info.extraNameCharacters;
        this.casing = info.casing;
    }

    public static void refreshDatabaseInfo(@NotNull LocalDataSource dataSource, @Nullable DatabaseConnection connection2) throws SQLException {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            return;
        }
        dataSource.getInfo().dbms = connection2.getDbms();
        dataSource.getInfo().exactVersion = connection2.getVersion();
        dataSource.getInfo().exactDriverVersion = connection2.getDriverVersion();
        DataSourceInfo.refreshDatabaseInfo(dataSource, connection2.getJdbcConnection());
    }

    private static void refreshDatabaseInfo(@NotNull LocalDataSource dataSource, @NotNull Connection connection2) throws SQLException {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(2);
        }
        if (connection2 == null) {
            DataSourceInfo.$$$reportNull$$$0(3);
        }
        DatabaseMetaData metaData = connection2.getMetaData();
        DataSourceInfo info = dataSource.getInfo();
        if (metaData == null) {
            info.copyFrom(new DataSourceInfo());
            return;
        }
        info.databaseVersion = new NameVersion(metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion());
        info.driverVersion = new NameVersion(metaData.getDriverName(), metaData.getDriverVersion());
        try {
            info.jdbcVersion = metaData.getJDBCMajorVersion() + "." + metaData.getJDBCMinorVersion();
        }
        catch (Throwable e) {
            try {
                metaData.getConnection();
                info.jdbcVersion = "2.1";
            }
            catch (Throwable e1) {
                info.jdbcVersion = "1.2";
            }
        }
        try {
            info.identifierQuoteString = metaData.getIdentifierQuoteString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.extraNameCharacters = metaData.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrSpaces((String)info.identifierQuoteString)) {
            info.identifierQuoteString = null;
        }
        if (StringUtil.isEmptyOrSpaces((String)info.extraNameCharacters)) {
            info.extraNameCharacters = null;
        }
        try {
            info.casing = DbImplUtil.getCasing(info.dbms, metaData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    private static RemoteConnection getRemoteConnection(@NotNull Connection connection2) {
        if (connection2 == null) {
            DataSourceInfo.$$$reportNull$$$0(4);
        }
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemote((Object)connection2, RemoteConnection.class);
        if (remoteConnection == null) {
            DataSourceInfo.$$$reportNull$$$0(5);
        }
        return remoteConnection;
    }

    @NotNull
    public static DetectedDbms getDetected(@NotNull Connection connection2) {
        if (connection2 == null) {
            DataSourceInfo.$$$reportNull$$$0(6);
        }
        RemoteConnection c2 = DataSourceInfo.getRemoteConnection(connection2);
        String dbms = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)c2).getDetectedDbmsName());
        String ver = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)c2).getDetectedDbmsVersion());
        String driverVersion = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)c2).getDriverVersion());
        DetectedDbms detectedDbms = new DetectedDbms(Dbms.fromString((String)dbms), (Version)ObjectUtils.notNull((Object)Version.parse((String)ver), (Object)Version.ZERO), (Version)ObjectUtils.notNull((Object)Version.parse((String)driverVersion), (Object)Version.ZERO));
        if (detectedDbms == null) {
            DataSourceInfo.$$$reportNull$$$0(7);
        }
        return detectedDbms;
    }

    static void initFamilyFromJdbc(@NotNull LocalDataSource dataSource, @NotNull DataSourceInfo info) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(8);
        }
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(9);
        }
        info.dbms = Dbms.forDataSource((DasDataSource)dataSource);
        JdbcHelper helper = DbImplUtil.getJdbcHelper(info.dbms);
        Version v = Version.parse((String)helper.parseVersion(info.databaseVersion.version));
        info.exactVersion = v == null ? Version.ZERO : v;
        info.exactDriverVersion = Version.ZERO;
    }

    public static void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(10);
        }
        dataSource.getInfo().copyFrom(new DataSourceInfo());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteConnection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshDatabaseInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteConnection";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDetected";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initFamilyFromJdbc";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DetectedDbms {
        public final Dbms dbms;
        public final Version version;
        public final Version driverVersion;

        private DetectedDbms(@NotNull Dbms dbms, @NotNull Version version, @NotNull Version driverVersion) {
            if (dbms == null) {
                DetectedDbms.$$$reportNull$$$0(0);
            }
            if (version == null) {
                DetectedDbms.$$$reportNull$$$0(1);
            }
            if (driverVersion == null) {
                DetectedDbms.$$$reportNull$$$0(2);
            }
            this.dbms = dbms;
            this.version = version;
            this.driverVersion = driverVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "driverVersion";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DataSourceInfo$DetectedDbms";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

