/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericIntrospectorLegacyModelUtils {
    @Nullable
    public static Pair<String, Short> fixProcedureName(@Nullable String schema, @NotNull Dbms dbms, @Nullable String name) {
        int tmpPos;
        int idx;
        if (dbms == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(0);
        }
        short pos = 1;
        if ((dbms.isSybase() || dbms == Dbms.HIVE) && name != null && schema != null && GenericIntrospectorLegacyModelUtils.startsWithQualifier(name, schema)) {
            name = name.substring(schema.length() + 1);
        }
        if (dbms.isTransactSql() && name != null && (idx = name.indexOf(59)) > -1 && (tmpPos = StringUtil.parseInt((String)name.substring(idx + 1), (int)-1)) >= 0) {
            name = name.substring(0, idx);
            pos = (short)tmpPos;
        }
        return name == null ? null : Pair.create((Object)name, (Object)pos);
    }

    public static boolean startsWithQualifier(@NotNull String name, @NotNull String schema) {
        if (name == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(1);
        }
        if (schema == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(2);
        }
        return name.startsWith(schema) && name.length() > schema.length() + 1 && name.charAt(schema.length()) == '.';
    }

    @Nullable
    public static String fixDefaultValue(@NotNull Dbms dbms, @NotNull BasicTypedElement column2, @Nullable String defaultValue) {
        int jdbc;
        if (dbms == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(3);
        }
        if (column2 == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(4);
        }
        if (defaultValue == null) {
            return null;
        }
        int reportedJdbc = column2.getDataType().jdbcType;
        int n = jdbc = reportedJdbc == 1111 || reportedJdbc == 0 ? JdbcUtil.guessJdbcTypeByName((String)column2.getDataType().typeName) : reportedJdbc;
        if (jdbc == 1 || jdbc == 2005 || jdbc == 12 || jdbc == -15 || jdbc == 2011 || jdbc == -9 || jdbc == 91 || jdbc == 92 || jdbc == 93) {
            if (dbms.isOracle()) {
                return defaultValue;
            }
            if (dbms.isPostgres()) {
                int dotIndex = defaultValue.indexOf("::");
                if (dotIndex == -1) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("('") && dotIndex > 4) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("''") && defaultValue.endsWith("'")) {
                    return defaultValue.substring(1, dotIndex);
                }
                return defaultValue.substring(0, dotIndex);
            }
            if ((jdbc == 91 || jdbc == 92 || jdbc == 93) && defaultValue.length() > 0 && Character.isLetter(defaultValue.charAt(0))) {
                return defaultValue;
            }
            if (!StringUtil.startsWithChar((CharSequence)defaultValue, (char)'\'')) {
                return '\'' + defaultValue + '\'';
            }
        } else if (jdbc == -7) {
            if (defaultValue.contains("\u0000")) {
                return "0";
            }
            if (defaultValue.contains("\u0001")) {
                return "1";
            }
        }
        return defaultValue;
    }

    public static <T extends BasicModNamedElement> ModNamingFamily<T> familyOf(@Nullable BasicModElement element2, @NotNull ObjectKind kind) {
        if (kind == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(5);
        }
        return DbImplUtil.familyOf(element2, kind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/generic/introspector/GenericIntrospectorLegacyModelUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixProcedureName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWithQualifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fixDefaultValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "familyOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

