/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;

public enum JdbcTableType {
    TABLE("table"),
    VIEW("view"),
    SEQUENCE("sequence"),
    SYNONYM("synonym"),
    INDEX("index"),
    TYPE("type"),
    SYSTEM_TABLE("system table"),
    SYSTEM_VIEW("system view"),
    SYSTEM_INDEX("system index"),
    LOCAL_TEMPORARY("local temporary table"),
    GLOBAL_TEMPORARY("global temporary table"),
    ALIAS("table alias");

    final String myTitle;

    private JdbcTableType(String title) {
        this.myTitle = title;
    }

    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public static JdbcTableType findByName(String name) {
        if ("BASE TABLE".equals(name)) {
            JdbcTableType jdbcTableType = TABLE;
            if (jdbcTableType == null) {
                JdbcTableType.$$$reportNull$$$0(0);
            }
            return jdbcTableType;
        }
        if ("ALIAS".equals(name)) {
            JdbcTableType jdbcTableType = ALIAS;
            if (jdbcTableType == null) {
                JdbcTableType.$$$reportNull$$$0(1);
            }
            return jdbcTableType;
        }
        for (JdbcTableType type : JdbcTableType.values()) {
            if (!Comparing.equal((String)type.getTitle(), (String)name, (boolean)false)) continue;
            JdbcTableType jdbcTableType = type;
            if (jdbcTableType == null) {
                JdbcTableType.$$$reportNull$$$0(2);
            }
            return jdbcTableType;
        }
        JdbcTableType jdbcTableType = TABLE;
        if (jdbcTableType == null) {
            JdbcTableType.$$$reportNull$$$0(3);
        }
        return jdbcTableType;
    }

    @NotNull
    public ObjectKind getKind() {
        switch (this) {
            case TABLE: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(4);
                }
                return objectKind;
            }
            case VIEW: {
                ObjectKind objectKind = ObjectKind.VIEW;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(5);
                }
                return objectKind;
            }
            case SEQUENCE: {
                ObjectKind objectKind = ObjectKind.SEQUENCE;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(6);
                }
                return objectKind;
            }
            case SYNONYM: {
                ObjectKind objectKind = ObjectKind.SYNONYM;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(7);
                }
                return objectKind;
            }
            case INDEX: {
                ObjectKind objectKind = ObjectKind.INDEX;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(8);
                }
                return objectKind;
            }
            case TYPE: {
                ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(9);
                }
                return objectKind;
            }
            case SYSTEM_TABLE: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(10);
                }
                return objectKind;
            }
            case SYSTEM_VIEW: {
                ObjectKind objectKind = ObjectKind.VIEW;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(11);
                }
                return objectKind;
            }
            case SYSTEM_INDEX: {
                ObjectKind objectKind = ObjectKind.INDEX;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(12);
                }
                return objectKind;
            }
            case LOCAL_TEMPORARY: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(13);
                }
                return objectKind;
            }
            case GLOBAL_TEMPORARY: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(14);
                }
                return objectKind;
            }
            case ALIAS: {
                ObjectKind objectKind = ObjectKind.SYNONYM;
                if (objectKind == null) {
                    JdbcTableType.$$$reportNull$$$0(15);
                }
                return objectKind;
            }
        }
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            JdbcTableType.$$$reportNull$$$0(16);
        }
        return objectKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/model/properties/JdbcTableType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findByName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

