/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.transport;

import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.ConnectionMonitor;
import com.trilead.ssh2.DHGexParameters;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.crypto.CryptoWishList;
import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.digest.MAC;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketDisconnect;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.transport.ClientServerHello;
import com.trilead.ssh2.transport.KexManager;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.SocketFactory;
import com.trilead.ssh2.transport.TransportConnection;
import com.trilead.ssh2.util.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Vector;

public class TransportManager {
    private static final Logger log = Logger.getLogger(TransportManager.class);
    private final Vector asynchronousQueue = new Vector();
    private Thread asynchronousThread = null;
    String hostname;
    int port;
    Socket sock = new Socket();
    Object connectionSemaphore = new Object();
    boolean flagKexOngoing = false;
    boolean connectionClosed = false;
    Throwable reasonClosedCause = null;
    TransportConnection tc;
    KexManager km;
    Vector messageHandlers = new Vector();
    Thread receiveThread;
    Vector connectionMonitors = new Vector();
    boolean monitorsWereInformed = false;
    private ClientServerHello myCsh;

    static InetAddress createInetAddress(String host) throws UnknownHostException {
        InetAddress addr = TransportManager.parseIPv4Address(host);
        if (addr != null) {
            return addr;
        }
        return InetAddress.getByName(host);
    }

    private static InetAddress parseIPv4Address(String host) throws UnknownHostException {
        if (host == null) {
            return null;
        }
        String[] quad = Tokenizer.parseTokens(host, '.');
        if (quad == null || quad.length != 4) {
            return null;
        }
        byte[] addr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int part = 0;
            if (quad[i].length() == 0 || quad[i].length() > 3) {
                return null;
            }
            for (int k = 0; k < quad[i].length(); ++k) {
                char c = quad[i].charAt(k);
                if (c < '0' || c > '9') {
                    return null;
                }
                part = part * 10 + (c - 48);
            }
            if (part > 255) {
                return null;
            }
            addr[i] = (byte)part;
        }
        return InetAddress.getByAddress(host, addr);
    }

    public TransportManager(String host, int port) throws IOException {
        this.hostname = host;
        this.port = port;
    }

    public int getPacketOverheadEstimate() {
        return this.tc.getPacketOverheadEstimate();
    }

    public void setTcpNoDelay(boolean state) throws IOException {
        this.sock.setTcpNoDelay(state);
    }

    public void setSoTimeout(int timeout) throws IOException {
        this.sock.setSoTimeout(timeout);
    }

    public ConnectionInfo getConnectionInfo(int kexNumber) throws IOException {
        return this.km.getOrWaitForConnectionInfo(kexNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            return this.reasonClosedCause;
        }
    }

    public byte[] getSessionIdentifier() {
        return this.km.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable cause, boolean useDisconnectPacket) {
        if (!useDisconnectPacket) {
            try {
                this.sock.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        Object ignore = this.connectionSemaphore;
        synchronized (ignore) {
            if (!this.connectionClosed) {
                if (useDisconnectPacket) {
                    try {
                        byte[] msg = new PacketDisconnect(11, cause.getMessage(), "").getPayload();
                        if (this.tc != null) {
                            this.tc.sendMessage(msg);
                        }
                    }
                    catch (IOException ignore2) {
                        // empty catch block
                    }
                    try {
                        this.sock.close();
                    }
                    catch (IOException ignore3) {
                        // empty catch block
                    }
                }
                this.connectionClosed = true;
                this.reasonClosedCause = cause;
            }
            this.connectionSemaphore.notifyAll();
        }
        Vector monitors = null;
        TransportManager ignore3 = this;
        synchronized (ignore3) {
            if (!this.monitorsWereInformed) {
                this.monitorsWereInformed = true;
                monitors = (Vector)this.connectionMonitors.clone();
            }
        }
        if (monitors != null) {
            for (int i = 0; i < monitors.size(); ++i) {
                try {
                    ConnectionMonitor cmon = (ConnectionMonitor)monitors.elementAt(i);
                    cmon.connectionLost(this.reasonClosedCause);
                    continue;
                }
                catch (Exception ignore4) {
                    // empty catch block
                }
            }
        }
    }

    public void initialize(CryptoWishList cwl, ServerHostKeyVerifier verifier, DHGexParameters dhgex, int connectTimeout, SecureRandom rnd, ProxyData proxyData) throws IOException {
        this.sock = SocketFactory.open(this.hostname, this.port, proxyData, connectTimeout);
        this.myCsh = new ClientServerHello(this.sock.getInputStream(), this.sock.getOutputStream());
        this.tc = new TransportConnection(this.sock.getInputStream(), this.sock.getOutputStream(), rnd);
        this.km = new KexManager(this, this.myCsh, cwl, this.hostname, this.port, verifier, rnd);
        this.km.initiateKEX(cwl, dhgex);
        this.receiveThread = new Thread(new Runnable(){

            public void run() {
                block9: {
                    try {
                        TransportManager.this.receiveLoop();
                    }
                    catch (IOException e) {
                        TransportManager.this.close(e, false);
                        if (!log.isEnabled()) break block9;
                        log.log(10, "Receive thread: error in receiveLoop: " + e.getMessage());
                    }
                }
                if (log.isEnabled()) {
                    log.log(50, "Receive thread: back from receiveLoop");
                }
                if (TransportManager.this.km != null) {
                    try {
                        TransportManager.this.km.handleMessage(null, 0);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < TransportManager.this.messageHandlers.size(); ++i) {
                    HandlerEntry he = (HandlerEntry)TransportManager.this.messageHandlers.elementAt(i);
                    try {
                        he.mh.handleMessage(null, 0);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(MessageHandler mh, int low, int high) {
        HandlerEntry he = new HandlerEntry();
        he.mh = mh;
        he.low = low;
        he.high = high;
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            this.messageHandlers.addElement(he);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler mh, int low, int high) {
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (he.mh != mh || he.low != low || he.high != high) continue;
                this.messageHandlers.removeElementAt(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKexMessage(byte[] msg) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
            }
            this.flagKexOngoing = true;
            try {
                this.tc.sendMessage(msg);
            }
            catch (IOException e) {
                this.close(e, false);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kexFinished() throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            this.flagKexOngoing = false;
            this.connectionSemaphore.notifyAll();
        }
    }

    public void forceKeyExchange(CryptoWishList cwl, DHGexParameters dhgex) throws IOException {
        this.km.initiateKEX(cwl, dhgex);
    }

    public void changeRecvCipher(BlockCipher bc, MAC mac) {
        this.tc.changeRecvCipher(bc, mac);
    }

    public void changeSendCipher(BlockCipher bc, MAC mac) {
        this.tc.changeSendCipher(bc, mac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsynchronousMessage(byte[] msg) throws IOException {
        Vector vector = this.asynchronousQueue;
        synchronized (vector) {
            this.asynchronousQueue.addElement(msg);
            if (this.asynchronousQueue.size() > 100) {
                throw new IOException("Error: the peer is not consuming our asynchronous replies.");
            }
            if (this.asynchronousThread == null) {
                this.asynchronousThread = new AsynchronousWorker();
                this.asynchronousThread.setDaemon(true);
                this.asynchronousThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionMonitors(Vector monitors) {
        TransportManager transportManager = this;
        synchronized (transportManager) {
            this.connectionMonitors = (Vector)monitors.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] msg) throws IOException {
        if (Thread.currentThread() == this.receiveThread) {
            throw new IOException("Assertion error: sendMessage may never be invoked by the receiver thread!");
        }
        Object object = this.connectionSemaphore;
        synchronized (object) {
            while (true) {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
                }
                if (!this.flagKexOngoing) break;
                try {
                    this.connectionSemaphore.wait();
                }
                catch (InterruptedException e) {}
            }
            try {
                this.tc.sendMessage(msg);
            }
            catch (IOException e) {
                this.close(e, false);
                throw e;
            }
        }
    }

    public void receiveLoop() throws IOException {
        byte[] msg = new byte[35000];
        while (true) {
            TypesReader tr;
            int msglen = this.tc.receiveMessage(msg, 0, msg.length);
            int type = msg[0] & 0xFF;
            if (type == 2) continue;
            if (type == 4) {
                if (!log.isEnabled()) continue;
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                tr.readBoolean();
                StringBuffer debugMessageBuffer = new StringBuffer();
                debugMessageBuffer.append(tr.readString("UTF-8"));
                for (int i = 0; i < debugMessageBuffer.length(); ++i) {
                    char c = debugMessageBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    debugMessageBuffer.setCharAt(i, '\ufffd');
                }
                log.log(50, "DEBUG Message from remote: '" + debugMessageBuffer.toString() + "'");
                continue;
            }
            if (type == 3) {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            if (type == 1) {
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                int reason_code = tr.readUINT32();
                StringBuffer reasonBuffer = new StringBuffer();
                reasonBuffer.append(tr.readString("UTF-8"));
                if (reasonBuffer.length() > 255) {
                    reasonBuffer.setLength(255);
                    reasonBuffer.setCharAt(254, '.');
                    reasonBuffer.setCharAt(253, '.');
                    reasonBuffer.setCharAt(252, '.');
                }
                for (int i = 0; i < reasonBuffer.length(); ++i) {
                    char c = reasonBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    reasonBuffer.setCharAt(i, '\ufffd');
                }
                throw new IOException("Peer sent DISCONNECT message (reason code " + reason_code + "): " + reasonBuffer.toString());
            }
            if (type == 20 || type == 21 || type >= 30 && type <= 49) {
                this.km.handleMessage(msg, msglen);
                continue;
            }
            MessageHandler mh = null;
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (he.low > type || type > he.high) continue;
                mh = he.mh;
                break;
            }
            if (mh == null) {
                throw new IOException("Unexpected SSH message (type " + type + ")");
            }
            mh.handleMessage(msg, msglen);
        }
    }

    public ClientServerHello getClientServerHello() {
        return this.myCsh;
    }

    class AsynchronousWorker
    extends Thread {
        AsynchronousWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                byte[] msg = null;
                Vector vector = TransportManager.this.asynchronousQueue;
                synchronized (vector) {
                    if (TransportManager.this.asynchronousQueue.size() == 0) {
                        try {
                            TransportManager.this.asynchronousQueue.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TransportManager.this.asynchronousQueue.size() == 0) {
                            TransportManager.this.asynchronousThread = null;
                            return;
                        }
                    }
                    msg = (byte[])TransportManager.this.asynchronousQueue.remove(0);
                }
                try {
                    TransportManager.this.sendMessage(msg);
                }
                catch (IOException e) {
                    return;
                }
            }
        }
    }

    class HandlerEntry {
        MessageHandler mh;
        int low;
        int high;

        HandlerEntry() {
        }
    }
}

