/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addattribute;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.addattribute.AddAttributeDialog;
import com.sixrr.xrp.addattribute.AddAttributeProcessor;
import com.sixrr.xrp.base.BaseTagRefactoringHandler;
import com.sixrr.xrp.context.Context;

class AddAttributeHandler
extends BaseTagRefactoringHandler {
    AddAttributeHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.addAttribute";
    }

    @Override
    protected String getRefactoringName() {
        return "Add Attribute";
    }

    @Override
    protected void handleTag(XmlTag tag, Project project) {
        AddAttributeDialog dialog = new AddAttributeDialog(tag);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        String attributeName = dialog.getAttributeName();
        String attributeValue = dialog.getAttributeValue();
        boolean previewUsages = dialog.isPreviewUsages();
        boolean addOnlyIfAbsent = dialog.getAddOnlyIfAbsent();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            AddAttributeProcessor processor = new AddAttributeProcessor(tag, attributeName, attributeValue, addOnlyIfAbsent, context);
            processor.setPreviewUsages(previewUsages);
            processor.run();
        }, "Add Attribute", null);
    }
}

