/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPresentationUtil {
    @NotNull
    public static final String FILE_SEPARATOR = "/";
    public static final char FILE_SEPARATOR_CHAR = '/';

    private PhpPresentationUtil() {
    }

    public static ItemPresentation getPresentation(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpPresentationUtil.$$$reportNull$$$0(0);
        }
        String location = PhpPresentationUtil.getPresentablePathForFile(element.getContainingFile().getVirtualFile(), element.getProject());
        return new PresentationData(element.getName(), location, element.getIcon(), null);
    }

    private static String getPresentablePathForClass(@Nullable PhpClass klass) {
        if (klass == null) {
            return "?";
        }
        VirtualFile classRoot = klass.getContainingFile().getVirtualFile();
        if (klass.getName() != null) {
            String[] fileNames;
            for (String fileName : fileNames = (String[])ArrayUtil.reverseArray((Object[])klass.getName().split("_"))) {
                if (!fileName.equals(classRoot.getNameWithoutExtension()) || (classRoot = classRoot.getParent()) == null) break;
            }
        }
        return PhpPresentationUtil.getPresentablePathForFile(classRoot, klass.getProject());
    }

    public static String getPresentablePathForFile(@Nullable VirtualFile file, Project project) {
        if (file == null) {
            return "";
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
        if (contentRoot != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
            StringBuilder pathPresentationBuilder = new StringBuilder();
            pathPresentationBuilder.append("...").append(FILE_SEPARATOR);
            if (projectRootManager.getContentRoots().length > 1) {
                pathPresentationBuilder.append(contentRoot.getName()).append(FILE_SEPARATOR);
            }
            pathPresentationBuilder.append(relativePath);
            return pathPresentationBuilder.toString();
        }
        VirtualFile[] roots = projectRootManager.getContentRoots();
        String location = "";
        for (VirtualFile root : roots) {
            if (!file.getUrl().startsWith(root.getUrl())) continue;
            location = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
        }
        if (location != null && location.isEmpty()) {
            location = file.getCanonicalPath();
        }
        return location == null ? ".../" : location;
    }

    public static ItemPresentation getClassPresentation(@NotNull PhpClass klass) {
        if (klass == null) {
            PhpPresentationUtil.$$$reportNull$$$0(1);
        }
        String location = PhpPresentationUtil.getPresentablePathForClass(klass);
        return new PresentationData(klass.getName() + "   " + StringUtil.trimEnd((String)klass.getNamespaceName(), (String)"\\"), location, klass.getIcon(), null);
    }

    public static ItemPresentation getDirectoryPresentation(PsiDirectory directory) {
        String pathForFile = PhpPresentationUtil.getPresentablePathForFile(directory.getVirtualFile(), directory.getProject());
        return new PresentationData(directory.getName(), pathForFile, PhpIcons.FOLDER_ICON, null);
    }

    public static ItemPresentation getVarPresentation(@NotNull Variable variable) {
        if (variable == null) {
            PhpPresentationUtil.$$$reportNull$$$0(2);
        }
        String location = PhpPresentationUtil.getPresentablePathForFile(variable.getContainingFile().getVirtualFile(), variable.getProject());
        return new PresentationData(variable.getName(), location, variable.getIcon(), null);
    }

    public static ItemPresentation getMethodPresentation(@NotNull Method method) {
        if (method == null) {
            PhpPresentationUtil.$$$reportNull$$$0(3);
        }
        PhpClass parent = method.getContainingClass();
        String location = (parent != null ? parent.getName() : "?") + " " + PhpPresentationUtil.getPresentablePathForClass(parent);
        return new PresentationData(method.getName(), location, method.getIcon(), null);
    }

    public static ItemPresentation getFieldPresentation(@NotNull Field field) {
        if (field == null) {
            PhpPresentationUtil.$$$reportNull$$$0(4);
        }
        PhpClass parent = field.getContainingClass();
        String location = (parent != null ? parent.getName() : "?") + " " + PhpPresentationUtil.getPresentablePathForClass(parent);
        return new PresentationData(field.getName(), location, field.getIcon(), null);
    }

    public static ItemPresentation getFunctionPresentation(@NotNull Function function) {
        if (function == null) {
            PhpPresentationUtil.$$$reportNull$$$0(5);
        }
        String location = PhpPresentationUtil.getPresentablePathForFile(function.getContainingFile().getVirtualFile(), function.getProject());
        return new PresentationData(function.getName(), location, function.getIcon(), null);
    }

    public static ItemPresentation getConstantPresentation(@NotNull Constant constant) {
        if (constant == null) {
            PhpPresentationUtil.$$$reportNull$$$0(6);
        }
        String location = PhpPresentationUtil.getPresentablePathForFile(constant.getContainingFile().getVirtualFile(), constant.getProject());
        return new PresentationData(constant.getName(), location, constant.getIcon(), null);
    }

    public static ItemPresentation getFilePresentation(@NotNull PhpFile phpFile) {
        if (phpFile == null) {
            PhpPresentationUtil.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = phpFile.getVirtualFile();
        assert (virtualFile != null);
        String location = PhpPresentationUtil.getPresentablePathForFile(virtualFile, phpFile.getProject());
        return new PresentationData(phpFile.getName(), location, phpFile.getIcon(0), null);
    }

    public static PresentationData getNamespacePresentation(@NotNull PhpNamespace phpNamespace) {
        if (phpNamespace == null) {
            PhpPresentationUtil.$$$reportNull$$$0(8);
        }
        String location = PhpPresentationUtil.getPresentablePathForFile(phpNamespace.getContainingFile().getVirtualFile(), phpNamespace.getProject());
        String fqn = phpNamespace.getFQN();
        String presentableText = fqn == null ? phpNamespace.getName() : ("\\".equals(fqn) ? fqn : PhpLangUtil.toPresentableFQN(fqn));
        return new PresentationData(presentableText, location, phpNamespace.getIcon(), null);
    }

    public static Icon getAccessIcon(PhpModifier.Access modifier) {
        if (modifier == PhpModifier.Access.PRIVATE) {
            return PhpIcons.PRIVATE;
        }
        if (modifier == PhpModifier.Access.PROTECTED) {
            return PhpIcons.PROTECTED;
        }
        return PhpIcons.PUBLIC;
    }

    @NotNull
    public static Object getParameterPresentation(@NotNull Parameter p) {
        String t;
        if (p == null) {
            PhpPresentationUtil.$$$reportNull$$$0(9);
        }
        StringBuilder s = new StringBuilder();
        if (p.isOptional()) {
            s.append('[');
        }
        if (p.isPassByRef()) {
            s.append('&');
        }
        if (p.isVariadic()) {
            s.append("...");
        }
        s.append(p.getName());
        PhpType type = p.getType();
        if (!(type.isEmpty() || type.isUndefined() || PhpType.NULL.equals((Object)type) || DumbService.getInstance((Project)p.getProject()).isDumb() || (t = type.global(p.getProject()).toStringResolved()).length() <= 0)) {
            s.append(" : ").append(t);
        }
        if (p.isOptional()) {
            String def = p.getDefaultValuePresentation();
            if (def != null) {
                s.append(" = ");
                s.append(def);
            }
            s.append(']');
        }
        String string = s.toString();
        if (string == null) {
            PhpPresentationUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static String formatFunction(@NotNull Function function) {
        if (function == null) {
            PhpPresentationUtil.$$$reportNull$$$0(11);
        }
        StringBuilder b = new StringBuilder().append(function.getName());
        PhpPresentationUtil.formatParameters(b, function.getParameters());
        try {
            PhpType phpType = function.getLocalType(false).global(function.getProject());
            if (!(phpType.isEmpty() || function instanceof Method && ((Method)function).getMethodType(true) == Method.MethodType.CONSTRUCTOR)) {
                b.append(":");
                b.append(phpType.toStringRelativized(function.getNamespaceName()));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return b.toString();
    }

    public static void formatType(@NotNull StringBuilder builder, @NotNull PhpNamedElement e) {
        PhpType phpType;
        if (builder == null) {
            PhpPresentationUtil.$$$reportNull$$$0(12);
        }
        if (e == null) {
            PhpPresentationUtil.$$$reportNull$$$0(13);
        }
        if (!(phpType = e.getType().global(e.getProject())).isEmpty()) {
            builder.append(":");
            builder.append(phpType.toStringRelativized("\\"));
        }
    }

    @NotNull
    public static StringBuilder formatParameters(@Nullable StringBuilder b, @NotNull Parameter[] parameters) {
        if (parameters == null) {
            PhpPresentationUtil.$$$reportNull$$$0(14);
        }
        if (b == null) {
            b = new StringBuilder();
        }
        b.append('(');
        for (int i = 0; i < parameters.length; ++i) {
            b.append(PhpPresentationUtil.getParameterPresentation(parameters[i]));
            if (parameters.length - i <= 1) continue;
            b.append(", ");
        }
        b.append(')');
        StringBuilder stringBuilder = b;
        if (stringBuilder == null) {
            PhpPresentationUtil.$$$reportNull$$$0(15);
        }
        return stringBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpNamespace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpPresentationUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpPresentationUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPresentation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVarPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFieldPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConstantPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilePresentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacePresentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterPresentation";
                break;
            }
            case 10: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatFunction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

