/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.RowIcon;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpClassMemberIconProvider;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.completion.ClassUsageContext;
import com.jetbrains.php.completion.PhpFqnLookupElement;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.UsageContext;
import com.jetbrains.php.completion.insert.PhpClassConstructorInsertHandler;
import com.jetbrains.php.completion.insert.PhpClassStaticInsertHandler;
import com.jetbrains.php.completion.insert.PhpFieldInsertHandler;
import com.jetbrains.php.completion.insert.PhpFunctionInsertHandler;
import com.jetbrains.php.completion.insert.PhpMethodInsertHandler;
import com.jetbrains.php.completion.insert.PhpNamespaceInsertHandler;
import com.jetbrains.php.completion.insert.PhpOverriddenFieldInsertHandler;
import com.jetbrains.php.completion.insert.PhpOverriddenMethodInsertHandler;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.completion.insert.PhpVariableInsertHandler;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugRuntimeEnvironment;
import com.jetbrains.php.debug.common.PhpRuntimeVariable;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariantsUtil {
    private PhpVariantsUtil() {
    }

    @Nullable
    public static PhpLookupElement getLookupItemForClass(@NotNull PhpClass phpClass, @NotNull ClassUsageContext context) {
        if (phpClass == null) {
            PhpVariantsUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpVariantsUtil.$$$reportNull$$$0(1);
        }
        if (!PhpVariantsUtil.lookupItemForClassAvailable(phpClass, context)) {
            return null;
        }
        PhpLookupElement lookupItem = PhpVariantsUtil.fqcnCompletionEnabled() ? new PhpFqnLookupElement((PhpNamedElement)phpClass) : new PhpLookupElement((PhpNamedElement)phpClass);
        lookupItem.handler = PhpVariantsUtil.getInsertHandlerForClassContext(context);
        return lookupItem;
    }

    public static boolean lookupItemForClassAvailable(@NotNull PhpClass phpClass, @NotNull ClassUsageContext context) {
        if (phpClass == null) {
            PhpVariantsUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PhpVariantsUtil.$$$reportNull$$$0(3);
        }
        if (PhpLangUtil.isObject(phpClass)) {
            return false;
        }
        return context.isGeneric() || context.isInInstanceof() || context.isInExtends() || context.isInImplements() && phpClass.isInterface() || context.isStatic() && (PhpVariantsUtil.hasFeature(phpClass.getProject(), PhpLanguageFeature.CLASS_NAME_CONST) || phpClass.hasStaticMembers()) || context.isInNew() && !phpClass.isAbstract() || context.isInClassUse() && phpClass.isTrait();
    }

    public static boolean fqcnCompletionEnabled() {
        return Registry.is((String)"php.fqcn.completion", (boolean)true);
    }

    private static boolean hasFeature(@NotNull Project project, @NotNull PhpLanguageFeature languageFeature) {
        if (project == null) {
            PhpVariantsUtil.$$$reportNull$$$0(4);
        }
        if (languageFeature == null) {
            PhpVariantsUtil.$$$reportNull$$$0(5);
        }
        return PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(languageFeature);
    }

    @NotNull
    public static InsertHandler<LookupElement> getInsertHandlerForClassContext(ClassUsageContext context) {
        PhpReferenceInsertHandler handler = context.isInNew() ? PhpClassConstructorInsertHandler.getInstance() : (context.isStatic() ? PhpClassStaticInsertHandler.getInstance() : PhpReferenceInsertHandler.getInstance());
        PhpClassConstructorInsertHandler phpClassConstructorInsertHandler = handler;
        if (phpClassConstructorInsertHandler == null) {
            PhpVariantsUtil.$$$reportNull$$$0(6);
        }
        return phpClassConstructorInsertHandler;
    }

    public static List<LookupElement> getLookupItems(Collection<? extends PhpNamedElement> elements, boolean includeMagic, @Nullable UsageContext context) {
        Collection<? extends PhpNamedElement> filtered;
        if (context != null) {
            filtered = new ArrayList<PhpNamedElement>();
            block0: for (PhpNamedElement phpNamedElement : elements) {
                if (phpNamedElement instanceof PhpElementWithModifier) {
                    PhpClass classForAccessFilter;
                    PhpModifier phpModifier;
                    if (PhpVariantsUtil.isDirectClone(phpNamedElement, context.getState()) || !PhpVariantsUtil.shouldBeShown(phpNamedElement, phpModifier = ((PhpElementWithModifier)phpNamedElement).getModifier(), includeMagic, context)) continue;
                    if (phpModifier.isPublic()) {
                        filtered.add((PhpNamedElement)phpNamedElement);
                        continue;
                    }
                    PhpClass elementClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)phpNamedElement, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (elementClass == null || (classForAccessFilter = context.getClassForAccessFilter()) == null) continue;
                    for (PhpClass contextClass = classForAccessFilter; contextClass != null; contextClass = contextClass.getSuperClass()) {
                        if (PhpClassHierarchyUtils.classesEqual((PhpClass)elementClass, (PhpClass)contextClass) || PhpClassHierarchyUtils.isMyTrait((PhpClass)contextClass, (PhpClass)elementClass, null) || contextClass.isTrait() && context.getTraitUsers().contains(elementClass)) {
                            filtered.add((PhpNamedElement)phpNamedElement);
                            continue block0;
                        }
                        if (!phpModifier.isProtected()) continue block0;
                    }
                    continue;
                }
                filtered.add((PhpNamedElement)phpNamedElement);
            }
        } else {
            filtered = elements;
        }
        ArrayList<LookupElement> items = new ArrayList<LookupElement>();
        for (PhpNamedElement phpNamedElement : filtered) {
            if (!includeMagic && StringUtil.startsWith((CharSequence)phpNamedElement.getNameCS(), (CharSequence)"__")) continue;
            items.add(PhpVariantsUtil.getLookupItem(phpNamedElement, context));
        }
        return items;
    }

    private static boolean isDirectClone(@NotNull PhpNamedElement element, PhpModifier.State contextState) {
        if (element == null) {
            PhpVariantsUtil.$$$reportNull$$$0(7);
        }
        return element instanceof Method && PhpLangUtil.equalsMethodNames(element.getNameCS(), "__clone") && !contextState.equals((Object)PhpModifier.State.PARENT);
    }

    private static boolean shouldBeShown(@NotNull PhpNamedElement element, @NotNull PhpModifier modifier, boolean allowAnyMethod, @NotNull UsageContext context) {
        boolean haveParentClassReference;
        if (element == null) {
            PhpVariantsUtil.$$$reportNull$$$0(8);
        }
        if (modifier == null) {
            PhpVariantsUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PhpVariantsUtil.$$$reportNull$$$0(10);
        }
        boolean targetAndAccessClassAreEqual = PhpClassHierarchyUtils.classesEqual((PhpClass)context.getClassForAccessFilter(), (PhpClass)context.getTargetObjectClass());
        boolean bl = haveParentClassReference = context.getState() == PhpModifier.State.PARENT;
        if (element instanceof Field) {
            if (!context.havePredecessorClassReference()) {
                return ((Field)element).isConstant() || modifier.isStatic() || context.getScope() == PhpModifier.State.DYNAMIC;
            }
            if (haveParentClassReference) {
                return modifier.isStatic();
            }
            return modifier.isStatic() == context.getState().isStatic();
        }
        if (allowAnyMethod) {
            return true;
        }
        if (targetAndAccessClassAreEqual) {
            if (!context.havePredecessorClassReference()) {
                return !modifier.isDynamic() || context.getScope() != PhpModifier.State.STATIC;
            }
            if (context.isThis() || context.isStaticOrSelfKeyword()) {
                return !context.getState().isDynamic() || !modifier.isStatic() || context.isTestClass();
            }
        }
        return haveParentClassReference || context.getState() == modifier.getState();
    }

    public static PhpLookupElement getLookupItem(PhpNamedElement element, @Nullable UsageContext context) {
        PhpLookupElement item = new PhpLookupElement(element);
        if (context != null) {
            PhpClass objectClass = context.getTargetObjectClass();
            if (PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) == objectClass) {
                item.bold = true;
            }
        }
        if (element instanceof Field) {
            item.typeText = element.getType().toString();
            if (!((Field)element).isConstant() && context != null && !context.getState().isDynamic()) {
                item.lookupString = "$" + item.lookupString;
            }
        } else if (element instanceof Method) {
            item.typeText = element.getType().toString();
        }
        item.handler = PhpVariantsUtil.getInsertHandler(element);
        return item;
    }

    @Nullable
    public static LookupElement getLookupElementForVariable(@NotNull PhpNamedElement element) {
        String name;
        if (element == null) {
            PhpVariantsUtil.$$$reportNull$$$0(11);
        }
        if ((name = element.getName()).length() > 0 && !name.endsWith("IntellijIdeaRulezzz")) {
            PhpLookupElement phpLookupElement = new PhpLookupElement(element);
            phpLookupElement.handler = PhpVariantsUtil.getInsertHandler(element);
            return phpLookupElement;
        }
        return null;
    }

    @Nullable
    public static InsertHandler getInsertHandler(PhpNamedElement element) {
        if (element instanceof Method) {
            return PhpMethodInsertHandler.getInstance();
        }
        if (element instanceof Field) {
            return PhpFieldInsertHandler.getInstance();
        }
        if (element instanceof Function) {
            return PhpFunctionInsertHandler.getInstance();
        }
        if (element instanceof PhpNamespace) {
            return PhpNamespaceInsertHandler.getInstance();
        }
        if (element instanceof Constant) {
            return PhpReferenceInsertHandler.getInstance();
        }
        if (element instanceof Parameter || element instanceof Variable || element instanceof PhpDocVariable) {
            return PhpVariableInsertHandler.getInstance();
        }
        return null;
    }

    @NotNull
    public static Collection<LookupElement> getLookupItemsToSuggestName(@NotNull PhpClassMember classMember, boolean includeMagic) {
        PhpClass currentClass;
        if (classMember == null) {
            PhpVariantsUtil.$$$reportNull$$$0(12);
        }
        Collection<LookupElement> collection = (currentClass = classMember.getContainingClass()) != null ? PhpVariantsUtil.getLookupItemsToSuggestName(currentClass, classMember, includeMagic) : Collections.emptyList();
        if (collection == null) {
            PhpVariantsUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public static Collection<LookupElement> getLookupItemsToSuggestName(@NotNull PhpClass currentClass, @Nullable PhpClassMember classMember, boolean includeMagic) {
        PhpModifier positionModifier;
        if (currentClass == null) {
            PhpVariantsUtil.$$$reportNull$$$0(14);
        }
        ArrayList filtered = ContainerUtil.newArrayList();
        PhpModifier phpModifier = positionModifier = classMember != null ? classMember.getModifier() : null;
        if (classMember == null || !positionModifier.isPrivate() || includeMagic) {
            PhpClass superClass = ((PhpClass)CompletionUtil.getOriginalOrSelf((PsiElement)currentClass)).getSuperClass();
            ArrayList members = ContainerUtil.newArrayList();
            if (classMember == null || classMember instanceof Method) {
                Object object;
                if (superClass != null) {
                    members.addAll(superClass.getMethods());
                }
                if (includeMagic && (object = PhpClassHierarchyUtils.getObject((Project)currentClass.getProject())) != null) {
                    members.addAll(object.getMethods());
                }
                for (PhpClass phpClass : currentClass.getImplementedInterfaces()) {
                    members.addAll(phpClass.getMethods());
                }
                for (PhpClass phpClass : currentClass.getTraits()) {
                    members.addAll(phpClass.getMethods());
                }
            }
            if (classMember == null || classMember instanceof Field) {
                if (superClass != null) {
                    for (Field field : superClass.getFields()) {
                        PhpClass containingClass = field.getContainingClass();
                        if (containingClass == null || containingClass.isInterface()) continue;
                        members.add(field);
                    }
                }
                for (PhpClass phpClass : currentClass.getTraits()) {
                    members.addAll(phpClass.getFields());
                }
            }
            if (!members.isEmpty()) {
                ArrayList ownMembers = ContainerUtil.newArrayList();
                if (classMember == null || classMember instanceof Method) {
                    ownMembers.addAll(Arrays.asList(currentClass.getOwnMethods()));
                }
                if (classMember == null || classMember instanceof Field) {
                    ownMembers.addAll(Arrays.asList(currentClass.getOwnFields()));
                }
                HashSet ownMembersNames = ContainerUtil.newHashSet((int)ownMembers.size());
                for (PhpNamedElement phpNamedElement : ownMembers) {
                    ownMembersNames.add(phpNamedElement.getName());
                }
                for (PhpClassMember phpClassMember : members) {
                    PhpModifier memberModifier = phpClassMember.getModifier();
                    String memberName = phpClassMember.getName();
                    if (memberModifier.isFinal() || memberModifier.isPrivate() || ownMembersNames.contains(memberName) || classMember != null && (memberModifier.isStatic() != positionModifier.isStatic() || memberModifier.getAccess().isWeakerThan(positionModifier.getAccess()) && (!includeMagic || !memberName.startsWith("__")) || PhpVariantsUtil.isConstant(phpClassMember) != PhpVariantsUtil.isConstant(classMember))) continue;
                    filtered.add(PhpVariantsUtil.getLookupItemToSuggestName(currentClass, phpClassMember, classMember != null));
                }
            }
        }
        ArrayList arrayList = filtered;
        if (arrayList == null) {
            PhpVariantsUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static LookupElement getLookupItemToSuggestName(@NotNull PhpClass currentClass, @NotNull PhpClassMember member, boolean hasModifiers) {
        if (currentClass == null) {
            PhpVariantsUtil.$$$reportNull$$$0(16);
        }
        if (member == null) {
            PhpVariantsUtil.$$$reportNull$$$0(17);
        }
        PhpClass clazz = member.getContainingClass();
        if (member instanceof Method) {
            return (hasModifiers ? LookupElementBuilder.create((Object)member, (String)member.getName()).withBoldness(currentClass == clazz) : LookupElementBuilder.create((Object)member, (String)(PhpVariantsUtil.getModifiers(member) + member.getName()).trim())).withTailText("()" + (currentClass.isInterface() ? "" : "{...}"), true).withIcon(PhpVariantsUtil.createOverridingIcon(PhpClassMemberIconProvider.getMethodIcon((Method)member), clazz != null && clazz.isInterface())).withInsertHandler((InsertHandler)PhpOverriddenMethodInsertHandler.getInstance());
        }
        if (member instanceof Field) {
            boolean constant = ((Field)member).isConstant();
            String fieldName = (constant ? "" : "$") + member.getName();
            return (hasModifiers ? LookupElementBuilder.create((Object)member, (String)fieldName).withBoldness(currentClass == clazz) : LookupElementBuilder.create((Object)member, (String)(PhpVariantsUtil.getModifiers(member) + fieldName))).withIcon(PhpVariantsUtil.createOverridingIcon(PhpClassMemberIconProvider.getFieldIcon((Field)member), false)).withInsertHandler((InsertHandler)PhpOverriddenFieldInsertHandler.getInstance());
        }
        throw new IllegalStateException("Unexpected class member " + member.getClass().getName());
    }

    @NotNull
    private static String getModifiers(@NotNull PhpClassMember member) {
        if (member == null) {
            PhpVariantsUtil.$$$reportNull$$$0(18);
        }
        StringBuilder result = new StringBuilder();
        PhpModifier modifier = member.getModifier();
        if (modifier.isPrivate()) {
            result.append("private ");
        } else if (modifier.isProtected()) {
            result.append("protected ");
        } else if (!(member instanceof Field) || !((Field)member).isConstant() || PhpVariantsUtil.hasFeature(member.getProject(), PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY)) {
            result.append("public ");
        }
        if (!(!modifier.isStatic() || member instanceof Field && ((Field)member).isConstant())) {
            result.append("static ");
        }
        if (member instanceof Method) {
            result.append("function ");
        } else if (member instanceof Field && ((Field)member).isConstant()) {
            result.append("const ");
        }
        String string = result.toString();
        if (string == null) {
            PhpVariantsUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static Icon createOverridingIcon(@NotNull Icon icon, boolean implemented) {
        if (icon == null) {
            PhpVariantsUtil.$$$reportNull$$$0(20);
        }
        Icon overriding = implemented ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod;
        RowIcon rowIcon = new RowIcon(new Icon[]{icon instanceof RowIcon ? ((RowIcon)icon).getIcon(0) : icon, overriding});
        if (rowIcon == null) {
            PhpVariantsUtil.$$$reportNull$$$0(21);
        }
        return rowIcon;
    }

    private static boolean isConstant(PhpClassMember member) {
        return member instanceof Field && ((Field)member).isConstant();
    }

    @NotNull
    public static Collection<LookupElement> getVariableVariants(@NotNull PsiElement position, boolean includeGlobals, boolean includeSuperGlobals, @NotNull PrefixMatcher prefixMatcher) {
        if (position == null) {
            PhpVariantsUtil.$$$reportNull$$$0(22);
        }
        if (prefixMatcher == null) {
            PhpVariantsUtil.$$$reportNull$$$0(23);
        }
        ArrayList variants = ContainerUtil.newArrayList();
        variants.addAll(Arrays.asList(VariableImpl.getVariableVariants(position, includeGlobals)));
        PsiFile containingFile = position.getContainingFile();
        if (containingFile instanceof PhpExpressionCodeFragment) {
            PhpDebugRuntimeEnvironment environment = PhpDebugUtil.getCurrentRuntimeEnvironment(position.getProject());
            if (environment != null) {
                Collection<PhpRuntimeVariable> runtimeVariables = environment.getDefinedVariables();
                for (PhpRuntimeVariable variable : runtimeVariables) {
                    LookupElementBuilder lookupElement = LookupElementBuilder.create((String)variable.getPresentableName()).withIcon(PhpIcons.VARIABLE).withTypeText(variable.getType().toStringResolved()).withInsertHandler((InsertHandler)PhpVariableInsertHandler.getInstance());
                    variants.add(lookupElement);
                }
            } else {
                PsiElement positionContext = containingFile.getContext();
                if (positionContext != null) {
                    variants.addAll(Arrays.asList(VariableImpl.getVariableVariants(positionContext, includeGlobals)));
                }
            }
        }
        if (includeSuperGlobals) {
            PsiFile include;
            VirtualFile superglobals = PhpRuntimeLibraryRootsProvider.findFile("_superglobals.php", position.getProject());
            PsiFile psiFile = include = superglobals != null ? position.getManager().findFile(superglobals) : null;
            if (include != containingFile && include instanceof PhpFile) {
                ((PhpFile)include).getTopLevelDefs().values().stream().filter(v -> v instanceof Variable).forEach(v -> variants.add(PhpVariantsUtil.getLookupItem(v, null)));
            }
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            PhpVariantsUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageFeature";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpVariantsUtil";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpVariantsUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertHandlerForClassContext";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupItemsToSuggestName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverridingIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLookupItemForClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lookupItemForClassAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasFeature";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectClone";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeShown";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElementForVariable";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLookupItemsToSuggestName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLookupItemToSuggestName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getModifiers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createOverridingIcon";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getVariableVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

