/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class PhpMemberInplaceRenamer
extends MemberInplaceRenamer {
    public PhpMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        if (elementToRename == null) {
            PhpMemberInplaceRenamer.$$$reportNull$$$0(0);
        }
        super(elementToRename, substituted, editor);
    }

    public PhpMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
        if (elementToRename == null) {
            PhpMemberInplaceRenamer.$$$reportNull$$$0(1);
        }
        super(elementToRename, substituted, editor, initialName, oldName);
    }

    protected boolean isIdentifier(String newName, Language language) {
        if (this.myElementToRename instanceof Method) {
            return PhpNameUtil.isValidMethodName(newName);
        }
        if (this.myElementToRename instanceof Field) {
            return PhpNameUtil.isValidFieldName(newName);
        }
        if (this.myElementToRename instanceof Function) {
            return PhpNameUtil.isValidFunctionName(newName);
        }
        if (this.myElementToRename instanceof Constant) {
            return PhpNameUtil.isValidConstantName(newName);
        }
        return PhpLangUtil.isPhpIdentifier(newName) && !PhpLangUtil.isPhpReservedKeyword(newName);
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        PsiElement substituted;
        CommonProcessors.CollectProcessor<PsiReference> mainProcessor = new CommonProcessors.CollectProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                return PhpMemberInplaceRenamer.this.acceptReference(reference);
            }
        };
        ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope, (boolean)false).forEach((Processor)mainProcessor);
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(mainProcessor.getResults());
        PsiNamedElement variable = this.getVariable();
        if (variable != null && (substituted = this.getSubstituted()) != null && substituted != variable) {
            CommonProcessors.CollectProcessor<PsiReference> processor = new CommonProcessors.CollectProcessor<PsiReference>(){

                protected boolean accept(PsiReference reference) {
                    if (reference instanceof ClassReference) {
                        return !PhpLangUtil.isClassNameSpecial(((ClassReference)reference).getName());
                    }
                    return true;
                }
            };
            ReferencesSearch.search((PsiElement)substituted, (SearchScope)referencesSearchScope, (boolean)false).forEach((Processor)processor);
            references.addAll(processor.getResults());
        }
        return references;
    }

    protected void performOnInvalidIdentifier(String newName, LinkedHashSet<String> nameSuggestions) {
        PsiNamedElement variable = this.getVariable();
        if (variable != null) {
            PsiReference caret = PhpRefactoringUtil.getReferenceAtCaret((PsiElement)variable, this.myEditor);
            if (caret == null || !caret.isReferenceTo((PsiElement)variable)) {
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)PhpBundle.message("validation.invalid.identifier.with.no.identifier", new Object[0]), (String)"", null);
                return;
            }
            super.performOnInvalidIdentifier(newName, nameSuggestions);
        }
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        PhpMemberInplaceRenamer phpMemberInplaceRenamer = new PhpMemberInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
        if (phpMemberInplaceRenamer == null) {
            PhpMemberInplaceRenamer.$$$reportNull$$$0(2);
        }
        return phpMemberInplaceRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/inplace/PhpMemberInplaceRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpMemberInplaceRenamer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInplaceRenamerToRestart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

