/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterPackage {
    public static final String INTERPRETER = "node.js.path.for.package.";
    public static final String PACKAGE = "node.js.selected.package.";
    private static final String PACKAGE_DETECTED = "node.js.detected.package.";
    public static final Key<String> TEST_DEFAULT_NPM_PACKAGE = Key.create((String)"JavaScript.Npm.Default.Npm.Package");
    @NotNull
    private final PropertiesComponent myPropertiesComponent;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myPackageName;
    @NotNull
    private NodeJsInterpreterRef myInterpreter;
    @NotNull
    private String myPackagePath;
    @NotNull
    private final String myInterpreterKey;
    @NotNull
    private final String myPackageKey;

    public JSLinterPackage(@NotNull Project project, @NotNull String packageName) {
        if (project == null) {
            JSLinterPackage.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            JSLinterPackage.$$$reportNull$$$0(1);
        }
        this.myInterpreter = NodeJsInterpreterRef.createProjectRef();
        this.myPackagePath = "";
        this.myProject = project;
        this.myPackageName = packageName;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myInterpreterKey = INTERPRETER + this.myPackageName;
        this.myPackageKey = PACKAGE + this.myPackageName;
    }

    public void force(@Nullable NodeJsInterpreterRef interpreter, @Nullable String packagePath) {
        if (interpreter != null) {
            this.myPropertiesComponent.setValue(this.myInterpreterKey, interpreter.getReferenceName());
            this.myInterpreter = interpreter;
        }
        if (packagePath != null) {
            this.myPropertiesComponent.setValue(this.myPackageKey, packagePath);
            this.myPackagePath = packagePath;
        }
    }

    public void readOrDetect() {
        this.myInterpreter = this.loadInterpreterRef();
        this.myPackagePath = this.detectPackage();
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreter() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreter;
        if (nodeJsInterpreterRef == null) {
            JSLinterPackage.$$$reportNull$$$0(2);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getPackagePath() {
        String string = this.myPackagePath;
        if (string == null) {
            JSLinterPackage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private String detectPackage() {
        String packagePath = this.myPropertiesComponent.getValue(this.myPackageKey, "");
        boolean detected = this.myPropertiesComponent.getBoolean(PACKAGE_DETECTED + this.myPackageName);
        if (StringUtil.isEmptyOrSpaces((String)packagePath) || !this.myProject.isDefault() && !detected) {
            NodePackage pkg = this.findDefaultPackage();
            if (pkg != null) {
                packagePath = pkg.getSystemDependentPath();
                if (!this.isLocal(pkg)) {
                    packagePath = this.localPackageIfInDependencies(packagePath);
                }
            } else {
                packagePath = this.localPackageIfInDependencies(packagePath);
            }
            if (!this.myProject.isDefault()) {
                this.myPropertiesComponent.setValue(PACKAGE_DETECTED + this.myPackageName, true);
            }
        }
        this.myPropertiesComponent.setValue(this.myPackageKey, packagePath);
        String string = packagePath;
        if (string == null) {
            JSLinterPackage.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private NodePackage findDefaultPackage() {
        String testPath;
        NodePackage pkg = ApplicationManager.getApplication().isUnitTestMode() && (testPath = (String)this.myProject.getUserData(TEST_DEFAULT_NPM_PACKAGE)) != null ? (StringUtil.isEmptyOrSpaces((String)testPath) ? null : new NodePackage(testPath)) : NodePackage.findDefaultPackage(this.myProject, this.myPackageName, this.myInterpreter.resolve(this.myProject));
        return pkg;
    }

    @NotNull
    private String localPackageIfInDependencies(@NotNull String packagePath) {
        if (packagePath == null) {
            JSLinterPackage.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDefault() || this.myProject.getBasePath() == null) {
            String string = packagePath;
            if (string == null) {
                JSLinterPackage.$$$reportNull$$$0(6);
            }
            return string;
        }
        PackageJsonData data = PackageJsonUtil.getTopLevelPackageJsonData(this.myProject);
        if (data != null && data.getAllDependencies().contains(this.myPackageName)) {
            String basePath = FileUtil.toSystemDependentName((String)this.myProject.getBasePath());
            packagePath = (basePath.endsWith(File.separator) ? basePath : basePath + File.separator) + "node_modules" + File.separator + this.myPackageName;
        }
        String string = packagePath;
        if (string == null) {
            JSLinterPackage.$$$reportNull$$$0(7);
        }
        return string;
    }

    private boolean isLocal(@NotNull NodePackage nodePackage) {
        if (nodePackage == null) {
            JSLinterPackage.$$$reportNull$$$0(8);
        }
        if (this.myProject.isDefault()) {
            return false;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile packageVf = lfs.findFileByPathIfCached(nodePackage.getSystemIndependentPath());
        if (packageVf == null) {
            packageVf = lfs.refreshAndFindFileByIoFile(new File(nodePackage.getSystemDependentPath()));
        }
        if (packageVf == null) {
            return false;
        }
        return packageVf.getParent() != null && "node_modules".equals(packageVf.getParent().getName()) && VfsUtilCore.isAncestor((VirtualFile)this.myProject.getBaseDir(), (VirtualFile)packageVf, (boolean)true);
    }

    @NotNull
    private NodeJsInterpreterRef loadInterpreterRef() {
        String interpreterRefName = this.myPropertiesComponent.getValue(this.myInterpreterKey);
        if (interpreterRefName != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(interpreterRefName);
            if (nodeJsInterpreterRef == null) {
                JSLinterPackage.$$$reportNull$$$0(9);
            }
            return nodeJsInterpreterRef;
        }
        NodeJsInterpreterRef ref = NodeJsInterpreterRef.createProjectRef();
        this.myPropertiesComponent.setValue(this.myInterpreterKey, ref.getReferenceName());
        NodeJsInterpreterRef nodeJsInterpreterRef = ref;
        if (nodeJsInterpreterRef == null) {
            JSLinterPackage.$$$reportNull$$$0(10);
        }
        return nodeJsInterpreterRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/JSLinterPackage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/JSLinterPackage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detectPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "localPackageIfInDependencies";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInterpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "localPackageIfInDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

