/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.CommandLineUtil;
import com.intellij.webcore.util.JsonUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTaskStructureUtil {
    private static final Logger LOG = Logger.getInstance(GruntTaskStructureUtil.class);
    private static final String GRUNT_TASK_STRUCTURE_FETCHER_TASK_NAME = "_intellij_grunt_tasks_fetcher";
    private static final String NAME_PROP = "name";
    private static final String INFO_PROP = "info";
    private static final String FILE_PATH_PROP = "filePath";
    private static final String MULTI_PROP = "multi";
    private static final String DEPENDENCIES_PROP = "dependencies";
    private static final String TARGETS_PROP = "targets";

    private GruntTaskStructureUtil() {
    }

    @NotNull
    public static GruntfileStructure fetchStructure(@Nullable NodeJsInterpreter interpreter, @NotNull String nodeOptions, @NotNull NodePackage gruntCliPackage, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData) throws JsbtTaskFetchException {
        GruntfileStructure gruntfileStructure;
        List<JsbtInvalidSetting> invalidSettings;
        if (nodeOptions == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(0);
        }
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(1);
        }
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(2);
        }
        if (envData == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(3);
        }
        if (!(invalidSettings = GruntTaskStructureUtil.checkSettings(interpreter, gruntCliPackage)).isEmpty()) {
            throw JsbtTaskFetchException.newInvalidSettings(gruntfile, invalidSettings);
        }
        interpreter = Objects.requireNonNull(interpreter);
        try {
            gruntfileStructure = GruntTaskStructureUtil.fetchStructure(interpreter, nodeOptions, gruntCliPackage, gruntfile, envData, false);
        }
        catch (JsbtTaskFetchException e) {
            LOG.info("Failed to fetch tasks: " + e.getDescription() + ". Re-fetching in verbose mode to present a detailed error");
            GruntfileStructure gruntfileStructure2 = GruntTaskStructureUtil.fetchStructure(interpreter, nodeOptions, gruntCliPackage, gruntfile, envData, true);
            if (gruntfileStructure2 == null) {
                GruntTaskStructureUtil.$$$reportNull$$$0(5);
            }
            return gruntfileStructure2;
        }
        if (gruntfileStructure == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(4);
        }
        return gruntfileStructure;
    }

    private static GruntfileStructure fetchStructure(@NotNull NodeJsInterpreter interpreter, @NotNull String nodeOptions, @NotNull NodePackage gruntCliPackage, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData, boolean verboseMode) throws JsbtTaskFetchException {
        CapturingProcessHandler processHandler;
        if (interpreter == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(6);
        }
        if (nodeOptions == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(7);
        }
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(8);
        }
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(9);
        }
        if (envData == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(10);
        }
        GeneralCommandLine commandLine = GruntTaskStructureUtil.createCommandLine(nodeOptions, gruntCliPackage, gruntfile, envData, verboseMode);
        try {
            NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        }
        catch (ExecutionException e) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, e.getMessage(), commandLine, e, null, null);
        }
        LOG.info("Fetching grunt tasks: " + commandLine.getCommandLineString());
        long startTimeMillis = System.currentTimeMillis();
        try {
            processHandler = new CapturingProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot fetch grunt tasks: cannot run " + commandLine.getCommandLineString(), (Throwable)e);
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "cannot execute command", commandLine, e, null, null);
        }
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput.getExitCode() != 0) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "process finished with exit code " + processOutput.getExitCode() + " (a non-zero exit code means an error)", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        GruntfileStructure structure = GruntTaskStructureUtil.parseStructure(gruntfile, processOutput.getStdout());
        if (structure == null) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "failed to parse tasks from json", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        LOG.info(String.format("%s: %d alias tasks and %d core tasks listed in %d ms", gruntfile.getPath(), structure.getAliasTasks().size(), structure.getCoreTasks().size(), System.currentTimeMillis() - startTimeMillis));
        return structure;
    }

    @NotNull
    private static List<JsbtInvalidSetting> checkSettings(@Nullable NodeJsInterpreter interpreter, @NotNull NodePackage gruntCliPackage) {
        JsbtInvalidSetting gruntCliPackageError;
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(11);
        }
        ArrayList errorInfos = ContainerUtil.newArrayListWithCapacity((int)2);
        String interpreterErrorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter);
        if (interpreterErrorMessage != null) {
            errorInfos.add(new JsbtInvalidSetting("Node interpreter", null, interpreterErrorMessage));
        }
        if ((gruntCliPackageError = JsbtUtil.validatePackageDir(gruntCliPackage, "Grunt-cli package", "grunt-cli")) != null) {
            errorInfos.add(gruntCliPackageError);
        }
        ArrayList arrayList = errorInfos;
        if (arrayList == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile gruntfile, @NotNull String message, @NotNull GeneralCommandLine commandLine, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(13);
        }
        if (message == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(14);
        }
        if (commandLine == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(15);
        }
        JsbtTaskFetchException jsbtTaskFetchException = JsbtTaskFetchException.newFetchFail(gruntfile, GruntService.getInstance(), "grunt", JavaScriptLanguageIcons.BuildTools.Grunt.Grunt, message, commandLine, "grunt <list tasks>", executionException, processHandler, processOutput);
        if (jsbtTaskFetchException == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(16);
        }
        return jsbtTaskFetchException;
    }

    @Nullable
    private static GruntfileStructure parseStructure(@NotNull VirtualFile gruntfile, @NotNull String stdout) {
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(17);
        }
        if (stdout == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(18);
        }
        Iterable lines = Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)stdout);
        for (String line : lines) {
            if ((line.startsWith("Reading ") || line.startsWith("Loading ")) && line.endsWith("ERROR")) {
                return null;
            }
            GruntfileStructure structure = GruntTaskStructureUtil.parseStructureFromLine(gruntfile, line);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static GruntfileStructure parseStructureFromLine(@NotNull VirtualFile gruntfile, @NotNull String line) {
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(19);
        }
        if (line == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(20);
        }
        if (!line.startsWith("{")) {
            return null;
        }
        JsonParser parser = new JsonParser();
        JsonReader jsonReader = null;
        try {
            jsonReader = new JsonReader((Reader)new StringReader(line));
            jsonReader.setLenient(false);
            JsonElement rootElement = parser.parse(jsonReader);
            if (rootElement.isJsonObject()) {
                GruntfileStructure gruntfileStructure = GruntTaskStructureUtil.parseStructureFromElement(gruntfile, rootElement.getAsJsonObject());
                return gruntfileStructure;
            }
            GruntfileStructure gruntfileStructure = null;
            return gruntfileStructure;
        }
        catch (Exception e) {
            GruntfileStructure gruntfileStructure = null;
            return gruntfileStructure;
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    LOG.warn("Can't close jsonReader", (Throwable)e);
                }
            }
        }
    }

    private static GruntfileStructure parseStructureFromElement(@NotNull VirtualFile gruntfile, @NotNull JsonObject rootObject) {
        JsonArray aliasTaskArray;
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(21);
        }
        if (rootObject == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(22);
        }
        if ((aliasTaskArray = JsonUtil.getChildAsArray((JsonObject)rootObject, (String)"aliasTasks")) == null) {
            return null;
        }
        JsonArray coreTaskArray = JsonUtil.getChildAsArray((JsonObject)rootObject, (String)"coreTasks");
        if (coreTaskArray == null) {
            return null;
        }
        GruntfileStructure structure = new GruntfileStructure(gruntfile);
        ArrayList aliasTasks = ContainerUtil.newArrayList();
        for (JsonElement aliasElement : aliasTaskArray) {
            if (!aliasElement.isJsonObject()) continue;
            JsonObject aliasObject = aliasElement.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)aliasObject, (String)NAME_PROP);
            String info = JsonUtil.getChildAsString((JsonObject)aliasObject, (String)INFO_PROP);
            String filePath = JsonUtil.getChildAsString((JsonObject)aliasObject, (String)FILE_PATH_PROP);
            boolean multi = JsonUtil.getChildAsBoolean((JsonObject)aliasObject, (String)MULTI_PROP, (boolean)false);
            List<String> dependencies = JsonUtil.getChildAsStringList((JsonObject)aliasObject, (String)DEPENDENCIES_PROP);
            if (dependencies == null) {
                dependencies = Collections.emptyList();
            }
            if (name == null) continue;
            aliasTasks.add(new GruntAliasTask(structure, name, info, filePath, multi, dependencies));
        }
        ArrayList coreTasks = ContainerUtil.newArrayList();
        for (JsonElement coreTaskElement : coreTaskArray) {
            if (!coreTaskElement.isJsonObject()) continue;
            JsonObject coreTaskObject = coreTaskElement.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)NAME_PROP);
            String info = JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)INFO_PROP);
            String filePath = JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)FILE_PATH_PROP);
            boolean multi = JsonUtil.getChildAsBoolean((JsonObject)coreTaskObject, (String)MULTI_PROP, (boolean)false);
            List<String> targets = JsonUtil.getChildAsStringList((JsonObject)coreTaskObject, (String)TARGETS_PROP);
            if (targets == null) {
                targets = Collections.emptyList();
            }
            if (name == null) continue;
            coreTasks.add(new GruntCoreTask(structure, name, info, filePath, multi, targets));
        }
        structure.setTasks(aliasTasks, coreTasks);
        return structure;
    }

    @NotNull
    private static File findGruntJsDir() {
        String jarPath = PathUtil.getJarPathForClass(GruntTaskStructureUtil.class);
        if (!jarPath.endsWith(".jar")) {
            String packageName = GruntTaskStructureUtil.class.getPackage().getName() + ".grunt_js";
            File file2 = new File(jarPath, packageName.replace('.', File.separatorChar));
            if (file2 == null) {
                GruntTaskStructureUtil.$$$reportNull$$$0(23);
            }
            return file2;
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file not found");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        File file3 = new File(pluginBaseDir, "grunt_js");
        if (file3 == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(24);
        }
        return file3;
    }

    @NotNull
    public static File getTasksDir() {
        File jsDir = GruntTaskStructureUtil.findGruntJsDir();
        File file2 = new File(jsDir, "tasks");
        if (file2 == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(25);
        }
        return file2;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull String nodeOptions, @NotNull NodePackage gruntCliPackage, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData, boolean verboseMode) {
        if (nodeOptions == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(26);
        }
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(27);
        }
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(28);
        }
        if (envData == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(29);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        envData.configureCommandLine(commandLine, true);
        File gruntfileDir = VfsUtilCore.virtualToIoFile((VirtualFile)gruntfile).getParentFile();
        CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)gruntfileDir, (boolean)true);
        nodeOptions = nodeOptions.trim();
        if (StringUtil.isNotEmpty((String)nodeOptions)) {
            commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        }
        commandLine.addParameter(GruntTaskStructureUtil.getGruntCliMainFilePath(gruntCliPackage));
        commandLine.addParameter("--no-color");
        if (verboseMode) {
            commandLine.addParameter("--verbose");
        }
        commandLine.addParameter("--gruntfile");
        commandLine.addParameter(FileUtil.toSystemDependentName((String)gruntfile.getPath()));
        commandLine.addParameter("--tasks");
        File tasksDir = GruntTaskStructureUtil.getTasksDir();
        commandLine.addParameter(tasksDir.getAbsolutePath());
        commandLine.addParameter(GRUNT_TASK_STRUCTURE_FETCHER_TASK_NAME);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(30);
        }
        return generalCommandLine;
    }

    @NotNull
    public static String getGruntCliMainFilePath(@NotNull NodePackage gruntCliPackage) {
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(31);
        }
        File gruntBinFile = new File(gruntCliPackage.getSystemDependentPath(), "bin" + File.separator + "grunt");
        String string = gruntBinFile.getAbsolutePath();
        if (string == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntCliPackage";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntfile";
                break;
            }
            case 3: 
            case 10: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchStructure";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSettings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newFetchFail";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findGruntJsDir";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksDir";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getGruntCliMainFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fetchStructure";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkSettings";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newFetchFail";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseStructure";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseStructureFromLine";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseStructureFromElement";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getGruntCliMainFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

