/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootException;
import com.intellij.cvsSupport2.connections.CvsRootSettingsBuilder;
import com.intellij.cvsSupport2.connections.RootFormatter;
import com.intellij.cvsSupport2.connections.ext.ExtConnectionCvsSettings;
import com.intellij.cvsSupport2.connections.local.LocalConnectionSettings;
import com.intellij.cvsSupport2.connections.pserver.PServerCvsSettings;
import com.intellij.cvsSupport2.connections.pserver.PServerLoginProvider;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionSettings;

public class IDEARootFormatter
implements CvsRootSettingsBuilder<CvsConnectionSettings> {
    private final CvsRootConfiguration myCvsRootConfiguration;

    public IDEARootFormatter(CvsRootConfiguration cvsRootConfiguration) {
        this.myCvsRootConfiguration = cvsRootConfiguration;
    }

    public CvsConnectionSettings createConfiguration() {
        return (CvsConnectionSettings)new RootFormatter((CvsRootSettingsBuilder)this).createConfiguration(this.myCvsRootConfiguration.getCvsRootAsString(), true);
    }

    public CvsConnectionSettings createSettings(CvsMethod method, String cvsRootAsString) {
        if (method == null) {
            throw new CvsRootException(CvsBundle.message((String)"message.error.missing.cvs.root", (Object[])new Object[]{cvsRootAsString}));
        }
        if (method.equals(CvsMethod.LOCAL_METHOD)) {
            return new LocalConnectionSettings(this.myCvsRootConfiguration);
        }
        if (method.equals(CvsMethod.PSERVER_METHOD)) {
            return new PServerCvsSettings(this.myCvsRootConfiguration);
        }
        if (method.equals(CvsMethod.EXT_METHOD)) {
            return new ExtConnectionCvsSettings(this.myCvsRootConfiguration);
        }
        if (method.equals(CvsMethod.SSH_METHOD)) {
            return new SshConnectionSettings(this.myCvsRootConfiguration);
        }
        throw new CvsRootException(CvsBundle.message((String)"exception.text.unsupported.method", (Object[])new Object[]{method, cvsRootAsString}));
    }

    public String getPServerPassword(String cvsRoot) {
        return PServerLoginProvider.getInstance().getScrambledPasswordForCvsRoot(cvsRoot);
    }
}

