/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.configurationStore.StringDataWriter;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J'\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0010\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/XmlDataWriter;", "Lcom/intellij/configurationStore/StringDataWriter;", "rootElementName", "", "elements", "", "Lorg/jdom/Element;", "rootAttributes", "", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Lcom/intellij/openapi/components/PathMacroManager;)V", "hasData", "", "filter", "Lcom/intellij/configurationStore/DataWriterFilter;", "write", "", "writer", "Ljava/io/Writer;", "lineSeparator", "write$intellij_platform_configurationStore_impl", "intellij.platform.configurationStore.impl"})
public final class XmlDataWriter
extends StringDataWriter {
    private final String rootElementName;
    private final List<Element> elements;
    private final Map<String, String> rootAttributes;
    private final PathMacroManager macroManager;

    @Override
    public boolean hasData(@NotNull DataWriterFilter filter) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
            Iterable $receiver$iv = this.elements;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Element it = (Element)element$iv;
                    if (!filter.hasData(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void write$intellij_platform_configurationStore_impl(@NotNull Writer writer, @NotNull String lineSeparator, @Nullable DataWriterFilter filter) {
        PathMacroFilter macroFilter;
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        String lineSeparatorWithIndent = lineSeparator;
        boolean hasRootElement = this.rootElementName != null;
        PathMacroManager pathMacroManager = this.macroManager;
        ReplacePathToMacroMap replacePathMap = pathMacroManager != null ? pathMacroManager.getReplacePathMap() : null;
        PathMacroManager pathMacroManager2 = this.macroManager;
        Object object = macroFilter = pathMacroManager2 != null ? pathMacroManager2.getMacroFilter() : null;
        if (hasRootElement) {
            lineSeparatorWithIndent = lineSeparatorWithIndent + "  ";
            writer.append('<').append(this.rootElementName);
            Map<String, String> map = this.rootAttributes;
            for (Map.Entry entry : map.entrySet()) {
                writer.append(' ');
                writer.append((CharSequence)entry.getKey());
                writer.append('=');
                writer.append('\"');
                String value = (String)entry.getValue();
                if (replacePathMap != null) {
                    String string = replacePathMap.substitute(JDOMUtil.escapeText((String)value, (boolean)false, (boolean)true), SystemInfoRt.isFileSystemCaseSensitive);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"replacePathMap.substitut\u2026sFileSystemCaseSensitive)");
                    value = string;
                }
                writer.append(JDOMUtil.escapeText((String)value, (boolean)false, (boolean)true));
                writer.append('\"');
            }
            if (this.elements.isEmpty()) {
                writer.append(" />");
                return;
            }
            writer.append('>');
        }
        DataWriterFilter dataWriterFilter = filter;
        JbXmlOutputter xmlOutputter = new JbXmlOutputter(lineSeparatorWithIndent, (JDOMUtil.ElementOutputFilter)(dataWriterFilter != null ? dataWriterFilter.toElementFilter() : null), replacePathMap, macroFilter);
        for (Element element : this.elements) {
            if (hasRootElement) {
                writer.append(lineSeparatorWithIndent);
            }
            xmlOutputter.printElement(writer, element, 0);
        }
        if (this.rootElementName != null) {
            writer.append(lineSeparator);
            writer.append("</").append(this.rootElementName).append('>');
        }
    }

    public XmlDataWriter(@Nullable String rootElementName, @NotNull List<? extends Element> elements, @NotNull Map<String, String> rootAttributes, @Nullable PathMacroManager macroManager) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(rootAttributes, (String)"rootAttributes");
        this.rootElementName = rootElementName;
        this.elements = elements;
        this.rootAttributes = rootAttributes;
        this.macroManager = macroManager;
    }
}

