/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDividerDrawUtil {
    public static final BasicStroke BOLD_DOTTED_STROKE = new BasicStroke(2.3f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

    @NotNull
    public static Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider, @NotNull Component base) {
        if (g == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(0);
        }
        if (divider == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(1);
        }
        if (base == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(2);
        }
        int width = divider.getWidth();
        int editorHeight = base.getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = base.getLocationOnScreen().y;
        Graphics2D graphics2D = (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
        if (graphics2D == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(3);
        }
        return graphics2D;
    }

    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(4);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(6);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(7);
        }
        List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerSeparator polygon : polygons) {
            polygon.paint(gg, width);
        }
        config2.restore();
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(8);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(9);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(10);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(11);
        }
        DiffDividerDrawUtil.paintPolygons(gg, width, true, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean curved, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(12);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(14);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(15);
        }
        List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width, curved);
        }
        config2.restore();
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(final @NotNull Editor editor1, final @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(16);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(17);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(18);
        }
        final ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        final Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        final LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        final LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DividerPaintable.Handler(){

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
                if (leftInterval.start > endLine1 && rightInterval.start > endLine2) {
                    return true;
                }
                if (leftInterval.end < startLine1 && rightInterval.end < startLine2) {
                    return false;
                }
                if (DiffDividerDrawUtil.isIntervalVisible(editor1, startLine1, endLine1) || DiffDividerDrawUtil.isIntervalVisible(editor2, startLine2, endLine2)) {
                    polygons.add(DiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, fillColor, borderColor, dottedBorder));
                }
                return true;
            }
        });
        ArrayList<DividerPolygon> arrayList = polygons;
        if (arrayList == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static boolean isIntervalVisible(@NotNull Editor editor, int startLine, int endLine) {
        TextRange range2;
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(20);
        }
        return !FoldingUtil.isTextRangeFolded(editor, range2 = DiffUtil.getLinesRange(editor.getDocument(), startLine, endLine));
    }

    @NotNull
    public static List<DividerSeparator> createVisibleSeparators(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(21);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(22);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(23);
        }
        ArrayList<DividerSeparator> separators = new ArrayList<DividerSeparator>();
        Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        int height1 = editor1.getLineHeight();
        int height2 = editor2.getLineHeight();
        EditorColorsScheme scheme2 = editor1.getColorsScheme();
        paintable.process((line1, line2) -> {
            if (leftInterval.start > line1 + 1 && rightInterval.start > line2 + 1) {
                return true;
            }
            if (leftInterval.end < line1 && rightInterval.end < line2) {
                return false;
            }
            separators.add(DiffDividerDrawUtil.createSeparator(transformations, line1, line2, height1, height2, scheme2));
            return true;
        });
        ArrayList<DividerSeparator> arrayList = separators;
        if (arrayList == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static Transformation getTransformation(@NotNull Editor editor) {
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(25);
        }
        Transformation transformation = line -> {
            if (editor == null) {
                DiffDividerDrawUtil.$$$reportNull$$$0(33);
            }
            int yOffset = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
            JComponent header = editor.getHeaderComponent();
            int headerOffset = header == null ? 0 : header.getHeight();
            return yOffset - editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
        };
        if (transformation == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(26);
        }
        return transformation;
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
        if (transformations == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(27);
        }
        int start1 = transformations[0].transform(startLine1);
        int end1 = transformations[0].transform(endLine1);
        int start2 = transformations[1].transform(startLine2);
        int end2 = transformations[1].transform(endLine2);
        DividerPolygon dividerPolygon = new DividerPolygon(start1, start2, end1, end2, fillColor, borderColor, dottedBorder);
        if (dividerPolygon == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(28);
        }
        return dividerPolygon;
    }

    @NotNull
    private static DividerSeparator createSeparator(@NotNull Transformation[] transformations, int line1, int line2, int height1, int height2, @Nullable EditorColorsScheme scheme2) {
        if (transformations == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(29);
        }
        int start1 = transformations[0].transform(line1);
        int start2 = transformations[1].transform(line2);
        DividerSeparator dividerSeparator = new DividerSeparator(start1, start2, start1 + height1, start2 + height2, scheme2);
        if (dividerSeparator == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(30);
        }
        return dividerSeparator;
    }

    @NotNull
    private static LineRange getVisibleInterval(Editor editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        if (area.height < 0) {
            LineRange lineRange = new LineRange(0, 0);
            if (lineRange == null) {
                DiffDividerDrawUtil.$$$reportNull$$$0(31);
            }
            return lineRange;
        }
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        LineRange lineRange = new LineRange(position1.line, position2.line);
        if (lineRange == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(32);
        }
        return lineRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "divider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gg";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor1";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor2";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintable";
                break;
            }
            case 20: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerGraphics";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisiblePolygons";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleSeparators";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformation";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createPolygon";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparator";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleInterval";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDividerGraphics";
                break;
            }
            case 3: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paintSeparators";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygons";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createVisiblePolygons";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isIntervalVisible";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleSeparators";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTransformation";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createPolygon";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createSeparator";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTransformation$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DividerSeparator {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final EditorColorsScheme myScheme;

        public DividerSeparator(int start1, int start2, int end1, int end2, @Nullable EditorColorsScheme scheme2) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myScheme = scheme2;
        }

        public void paint(Graphics2D g, int width) {
            DiffLineSeparatorRenderer.drawConnectorLine(g, 0, width, this.myStart1, this.myStart2, this.myEnd1 - this.myStart1, this.myScheme);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> ";
        }
    }

    public static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final Color myFillColor;
        @Nullable
        private final Color myBorderColor;
        private final boolean myDottedBorder;

        public DividerPolygon(int start1, int start2, int end1, int end2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myFillColor = fillColor;
            this.myBorderColor = borderColor;
            this.myDottedBorder = dottedBorder;
        }

        public void paint(Graphics2D g, int width, boolean curve) {
            int endY2;
            int startY2;
            int endY1;
            int startY1;
            if (this.myEnd1 - this.myStart1 < 2) {
                startY1 = this.myStart1 - 1;
                endY1 = this.myStart1;
            } else {
                startY1 = this.myStart1;
                endY1 = this.myEnd1 - 1;
            }
            if (this.myEnd2 - this.myStart2 < 2) {
                startY2 = this.myStart2 - 1;
                endY2 = this.myStart2;
            } else {
                startY2 = this.myStart2;
                endY2 = this.myEnd2 - 1;
            }
            Stroke oldStroke = g.getStroke();
            if (this.myDottedBorder) {
                g.setStroke(BOLD_DOTTED_STROKE);
            }
            if (curve) {
                DiffDrawUtil.drawCurveTrapezium(g, 0, width, startY1, endY1, startY2, endY2, this.myFillColor, this.myBorderColor);
            } else {
                DiffDrawUtil.drawTrapezium(g, 0, width, startY1, endY1, startY2, endY2, this.myFillColor, this.myBorderColor);
            }
            g.setStroke(oldStroke);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myFillColor + ", " + this.myBorderColor;
        }
    }

    public static interface DividerSeparatorPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2);
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static abstract class Handler {
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                if (color == null) {
                    Handler.$$$reportNull$$$0(0);
                }
                return this.process(startLine1, endLine1, startLine2, endLine2, color, null, false);
            }

            public boolean processResolvable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Editor editor, @NotNull TextDiffType type, boolean resolved) {
                if (editor == null) {
                    Handler.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    Handler.$$$reportNull$$$0(2);
                }
                Color color = type.getColor(editor);
                return this.process(startLine1, endLine1, startLine2, endLine2, resolved ? null : color, resolved ? color : null, resolved);
            }

            public boolean processExcludable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Editor editor, @NotNull TextDiffType type, boolean excluded) {
                if (editor == null) {
                    Handler.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    Handler.$$$reportNull$$$0(4);
                }
                Color borderColor = excluded ? type.getColor(editor) : null;
                Color fillColor = excluded ? type.getIgnoredColor(editor) : type.getColor(editor);
                return this.process(startLine1, endLine1, startLine2, endLine2, fillColor, borderColor, false);
            }

            public abstract boolean process(int var1, int var2, int var3, int var4, @Nullable Color var5, @Nullable Color var6, boolean var7);

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "color";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintable$Handler";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processResolvable";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processExcludable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

