/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.externalDependencies.impl.CheckRequiredPluginsActivity;
import com.intellij.externalDependencies.impl.DependencyOnPluginState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalDependencies", storages={@Storage(value="externalDependencies.xml")})
public class ExternalDependenciesManagerImpl
extends ExternalDependenciesManager
implements PersistentStateComponent<ExternalDependenciesState> {
    private final Project myProject;
    private static final Comparator<ProjectExternalDependency> DEPENDENCY_COMPARATOR = (o1, o2) -> {
        int i = o1.getClass().getSimpleName().compareToIgnoreCase(o2.getClass().getSimpleName());
        if (i != 0) {
            return i;
        }
        return ((Comparable)((Object)o1)).compareTo(o2);
    };
    private final List<ProjectExternalDependency> myDependencies = new ArrayList<ProjectExternalDependency>();

    public ExternalDependenciesManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public <T extends ProjectExternalDependency> List<T> getDependencies(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(0);
        }
        List list2 = ContainerUtil.collect(this.myDependencies.iterator(), (FilteringIterator.InstanceOf)FilteringIterator.instanceOf(aClass));
        if (list2 == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ProjectExternalDependency> getAllDependencies() {
        List<ProjectExternalDependency> list2 = Collections.unmodifiableList(this.myDependencies);
        if (list2 == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void setAllDependencies(@NotNull List<ProjectExternalDependency> dependencies) {
        if (dependencies == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(3);
        }
        this.myDependencies.clear();
        this.myDependencies.addAll(dependencies);
        Collections.sort(this.myDependencies, DEPENDENCY_COMPARATOR);
    }

    @Nullable
    public ExternalDependenciesState getState() {
        ExternalDependenciesState state = new ExternalDependenciesState();
        for (ProjectExternalDependency dependency : this.myDependencies) {
            state.myDependencies.add(new DependencyOnPluginState((DependencyOnPlugin)dependency));
        }
        return state;
    }

    public void loadState(@NotNull ExternalDependenciesState state) {
        if (state == null) {
            ExternalDependenciesManagerImpl.$$$reportNull$$$0(4);
        }
        ArrayList<ProjectExternalDependency> oldDependencies = new ArrayList<ProjectExternalDependency>(this.myDependencies);
        this.myDependencies.clear();
        for (DependencyOnPluginState dependency : state.myDependencies) {
            this.myDependencies.add(new DependencyOnPlugin(dependency.myId, dependency.myMinVersion, dependency.myMaxVersion));
        }
        if (!oldDependencies.equals(this.myDependencies) && !this.myDependencies.isEmpty()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> CheckRequiredPluginsActivity.runCheck(this.myProject)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAllDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExternalDependenciesState {
        @Property(surroundWithTag=false)
        @XCollection
        public List<DependencyOnPluginState> myDependencies = new ArrayList<DependencyOnPluginState>();
    }
}

