/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffElement;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.util.text.DateFormatUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffElementImpl
implements DirDiffElement {
    private final DTree myParent;
    private DiffType myType;
    private DiffElement mySource;
    private long mySourceLength;
    private DiffElement myTarget;
    private long myTargetLength;
    private final String myName;
    private DirDiffOperation myOperation;
    private DirDiffOperation myDefaultOperation;
    private final DTree myNode;

    private DirDiffElementImpl(DTree parent, @Nullable DiffElement source, @Nullable DiffElement target2, DiffType type, String name, @Nullable DirDiffOperation defaultOperation) {
        this.myParent = parent.getParent();
        this.myNode = parent;
        this.myType = type;
        this.mySource = source;
        this.mySourceLength = source == null || source.isContainer() ? -1L : source.getSize();
        this.myTarget = target2;
        this.myTargetLength = target2 == null || target2.isContainer() ? -1L : target2.getSize();
        this.myName = name;
        if (defaultOperation != null) {
            this.myDefaultOperation = defaultOperation;
        } else if (type == DiffType.ERROR) {
            this.myDefaultOperation = DirDiffOperation.NONE;
        } else if (this.isSource()) {
            this.myDefaultOperation = DirDiffOperation.COPY_TO;
        } else if (this.isTarget()) {
            this.myDefaultOperation = DirDiffOperation.COPY_FROM;
        } else if (type == DiffType.EQUAL) {
            this.myDefaultOperation = DirDiffOperation.EQUAL;
        } else if (type == DiffType.CHANGED) {
            assert (source != null);
            this.myDefaultOperation = DirDiffOperation.MERGE;
        }
    }

    public String getSourceModificationDate() {
        return this.mySource == null ? "" : DirDiffElementImpl.getLastModification(this.mySource);
    }

    public String getTargetModificationDate() {
        return this.myTarget == null ? "" : DirDiffElementImpl.getLastModification(this.myTarget);
    }

    public void updateTargetData() {
        this.myTargetLength = this.myTarget != null && !this.myTarget.isContainer() ? this.myTarget.getSize() : -1L;
    }

    private static String getLastModification(DiffElement file2) {
        long timeStamp = file2.getTimeStamp();
        return timeStamp < 0L ? "" : DateFormatUtil.formatDateTime((long)timeStamp);
    }

    public static DirDiffElementImpl createChange(DTree parent, @NotNull DiffElement source, @NotNull DiffElement target2, @Nullable DirDiffSettings.CustomSourceChooser customSourceChooser) {
        if (source == null) {
            DirDiffElementImpl.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            DirDiffElementImpl.$$$reportNull$$$0(1);
        }
        DirDiffOperation defaultOperation = null;
        if (customSourceChooser != null) {
            DiffElement chosenSource = customSourceChooser.chooseSource(source, target2);
            if (chosenSource == source) {
                defaultOperation = DirDiffOperation.COPY_TO;
            } else if (chosenSource == target2) {
                defaultOperation = DirDiffOperation.COPY_FROM;
            }
        }
        return new DirDiffElementImpl(parent, source, target2, DiffType.CHANGED, source.getPresentableName(), defaultOperation);
    }

    public static DirDiffElementImpl createError(DTree parent, @Nullable DiffElement source, @Nullable DiffElement target2) {
        return new DirDiffElementImpl(parent, source, target2, DiffType.ERROR, source == null ? target2.getPresentableName() : source.getPresentableName(), null);
    }

    public static DirDiffElementImpl createSourceOnly(DTree parent, @NotNull DiffElement source) {
        if (source == null) {
            DirDiffElementImpl.$$$reportNull$$$0(2);
        }
        return new DirDiffElementImpl(parent, source, null, DiffType.SOURCE, null, null);
    }

    public static DirDiffElementImpl createTargetOnly(DTree parent, @NotNull DiffElement target2) {
        if (target2 == null) {
            DirDiffElementImpl.$$$reportNull$$$0(3);
        }
        return new DirDiffElementImpl(parent, null, target2, DiffType.TARGET, null, null);
    }

    public static DirDiffElementImpl createDirElement(DTree parent, DiffElement src, DiffElement trg, String name) {
        return new DirDiffElementImpl(parent, src, trg, DiffType.SEPARATOR, name, null);
    }

    public static DirDiffElementImpl createEqual(DTree parent, @NotNull DiffElement source, @NotNull DiffElement target2) {
        if (source == null) {
            DirDiffElementImpl.$$$reportNull$$$0(4);
        }
        if (target2 == null) {
            DirDiffElementImpl.$$$reportNull$$$0(5);
        }
        return new DirDiffElementImpl(parent, source, target2, DiffType.EQUAL, source.getPresentableName(), null);
    }

    public DiffType getType() {
        return this.myType;
    }

    public DiffElement getSource() {
        return this.mySource;
    }

    public DiffElement getTarget() {
        return this.myTarget;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getSourceName() {
        return this.mySource == null ? null : this.mySource.getName();
    }

    @Nullable
    public String getSourcePresentableName() {
        return this.mySource == null ? null : this.mySource.getPresentableName();
    }

    @Nullable
    public String getSourceSize() {
        return this.mySourceLength < 0L ? null : String.valueOf(this.mySourceLength);
    }

    public DirDiffOperation getDefaultOperation() {
        return this.myDefaultOperation;
    }

    @Nullable
    public String getTargetName() {
        return this.myTarget == null ? null : this.myTarget.getName();
    }

    @Nullable
    public String getTargetPresentableName() {
        return this.myTarget == null ? null : this.myTarget.getPresentableName();
    }

    @Nullable
    public String getTargetSize() {
        return this.myTargetLength < 0L ? null : String.valueOf(this.myTargetLength);
    }

    public boolean isSeparator() {
        return this.myType == DiffType.SEPARATOR;
    }

    public boolean isSource() {
        return this.myType == DiffType.SOURCE;
    }

    public boolean isTarget() {
        return this.myType == DiffType.TARGET;
    }

    public DirDiffOperation getOperation() {
        return this.myOperation == null ? this.myDefaultOperation : this.myOperation;
    }

    public void updateSourceFromTarget(DiffElement target2) {
        this.myTarget = target2;
        this.myTargetLength = this.mySourceLength;
        this.myDefaultOperation = DirDiffOperation.EQUAL;
        this.myOperation = DirDiffOperation.EQUAL;
        this.myType = DiffType.EQUAL;
    }

    public void updateTargetFromSource(DiffElement source) {
        this.mySource = source;
        this.mySourceLength = this.myTargetLength;
        this.myDefaultOperation = DirDiffOperation.EQUAL;
        this.myOperation = DirDiffOperation.EQUAL;
        this.myType = DiffType.EQUAL;
    }

    public void setNextOperation() {
        DirDiffOperation op = this.getOperation();
        if (this.myType == DiffType.SOURCE) {
            this.myOperation = op == DirDiffOperation.COPY_TO ? DirDiffOperation.DELETE : (op == DirDiffOperation.DELETE ? DirDiffOperation.NONE : DirDiffOperation.COPY_TO);
        } else if (this.myType == DiffType.TARGET) {
            this.myOperation = op == DirDiffOperation.COPY_FROM ? DirDiffOperation.DELETE : (op == DirDiffOperation.DELETE ? DirDiffOperation.NONE : DirDiffOperation.COPY_FROM);
        } else if (this.myType == DiffType.CHANGED) {
            this.myOperation = op == DirDiffOperation.MERGE ? DirDiffOperation.COPY_TO : (op == DirDiffOperation.COPY_TO ? DirDiffOperation.COPY_FROM : DirDiffOperation.MERGE);
        }
    }

    public void setOperation(@NotNull DirDiffOperation operation) {
        if (operation == null) {
            DirDiffElementImpl.$$$reportNull$$$0(6);
        }
        if (this.myType == DiffType.EQUAL || this.myType == DiffType.SEPARATOR) {
            return;
        }
        if (this.myType == DiffType.TARGET && operation == DirDiffOperation.COPY_TO) {
            return;
        }
        if (this.myType == DiffType.SOURCE && operation == DirDiffOperation.COPY_FROM) {
            return;
        }
        if (this.myType == DiffType.CHANGED && operation == DirDiffOperation.DELETE) {
            return;
        }
        this.myOperation = operation;
    }

    public Icon getSourceIcon() {
        return DirDiffElementImpl.getIcon(this.mySource);
    }

    public Icon getTargetIcon() {
        return DirDiffElementImpl.getIcon(this.myTarget);
    }

    private static Icon getIcon(DiffElement element) {
        return element != null ? element.getIcon() : null;
    }

    public DTree getParentNode() {
        return this.myParent;
    }

    public DTree getNode() {
        return this.myNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffElementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createChange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createSourceOnly";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createTargetOnly";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createEqual";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

