/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.AbstractStringEnumerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;

class LazyStubData {
    private final AbstractStringEnumerator myStorage;
    private final MostlyUShortIntList myParentsAndStarts;
    private final byte[] mySerializedStubs;
    private final BitSet myAllStarts;

    LazyStubData(AbstractStringEnumerator storage2, MostlyUShortIntList parentsAndStarts, byte[] serializedStubs, BitSet allStarts) {
        this.myStorage = storage2;
        this.myParentsAndStarts = parentsAndStarts;
        this.mySerializedStubs = serializedStubs;
        this.myAllStarts = allStarts;
    }

    int getParentIndex(int index) {
        return this.myParentsAndStarts.get(index * 2);
    }

    private int getDataStart(int index) {
        return this.myParentsAndStarts.get(index * 2 + 1);
    }

    StubBase<?> deserializeStub(int index, StubBase<?> parent, IStubElementType<?, ?> type) throws IOException {
        StubInputStream stream = new StubInputStream((InputStream)this.stubBytes(index), this.myStorage);
        StubBase stub = (StubBase)type.deserialize(stream, parent);
        int available = stream.available();
        if (available > 0) {
            assert (available == 1) : "Stub serializer/deserializer mismatch in " + type;
            stub.markDangling();
        }
        return stub;
    }

    private ByteArrayInputStream stubBytes(int index) {
        int start2 = this.getDataStart(index);
        if (start2 == 0) {
            return new ByteArrayInputStream(ArrayUtil.EMPTY_BYTE_ARRAY);
        }
        int end = this.myAllStarts.nextSetBit(start2 + 1);
        if (end < 0) {
            end = this.mySerializedStubs.length + 1;
        }
        return new ByteArrayInputStream(this.mySerializedStubs, start2 - 1, end - start2);
    }
}

