/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.RenameFileActionProvider;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import org.jetbrains.annotations.NotNull;

public class RenameFileAction
extends AnAction {
    public static final String RENAME_FILE = "Rename File...";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RenameFileAction.$$$reportNull$$$0(0);
        }
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file2 != null);
        VirtualFile virtualFile = file2.getVirtualFile();
        assert (virtualFile != null);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        PsiElementRenameHandler.invoke((PsiElement)file2, project, (PsiElement)file2, null);
    }

    public boolean startInTransaction() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RenameFileAction.$$$reportNull$$$0(1);
        }
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Presentation presentation = e.getPresentation();
        String place = e.getPlace();
        boolean enabled = file2 != null && (this.enabledInProjectView(file2) || !"ProjectViewPopup".equals(place)) && place != "EditorPopup" && e.getData(CommonDataKeys.PROJECT) != null;
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
        if (enabled) {
            presentation.setText(RENAME_FILE);
            presentation.setDescription("Rename selected file");
        }
    }

    protected boolean enabledInProjectView(@NotNull PsiFile file2) {
        if (file2 == null) {
            RenameFileAction.$$$reportNull$$$0(2);
        }
        for (RenameFileActionProvider provider : RenameFileActionProvider.EP_NAME.getExtensionList()) {
            if (!provider.enabledInProjectView(file2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/actions/RenameFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enabledInProjectView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

