/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.handler;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.BadRequestException;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotAcceptableException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.netty.handler.HttpRequestProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.Closeable;
import java.nio.charset.Charset;

public class HttpResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private HttpResponse response;
    private ByteBuf errorBody = Unpooled.buffer();
    private HttpRequestProvider requestProvider;
    private ResultCallback<?> resultCallback;

    public HttpResponseHandler(HttpRequestProvider requestProvider, ResultCallback<?> resultCallback) {
        super(false);
        this.requestProvider = requestProvider;
        this.resultCallback = resultCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void channelRead0(final ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpResponse) {
            this.response = (HttpResponse)msg;
            this.resultCallback.onStart(new Closeable(){

                @Override
                public void close() {
                    ctx.channel().close();
                }
            });
            return;
        }
        if (!(msg instanceof HttpContent)) return;
        HttpContent content = (HttpContent)msg;
        ByteBuf byteBuf = content.content();
        switch (this.response.status().code()) {
            case 200: 
            case 201: 
            case 204: {
                ctx.fireChannelRead((Object)byteBuf);
                break;
            }
            default: {
                this.errorBody.writeBytes(byteBuf);
            }
        }
        if (!(content instanceof LastHttpContent)) return;
        try {
            switch (this.response.status().code()) {
                case 101: 
                case 200: 
                case 201: 
                case 204: {
                    return;
                }
                case 301: 
                case 302: {
                    if (!this.response.headers().contains((CharSequence)HttpHeaderNames.LOCATION)) return;
                    String location = this.response.headers().get((CharSequence)HttpHeaderNames.LOCATION);
                    HttpRequest redirected = this.requestProvider.getHttpRequest(location);
                    ctx.channel().writeAndFlush((Object)redirected);
                    return;
                }
                case 304: {
                    throw new NotModifiedException(this.getBodyAsMessage(this.errorBody));
                }
                case 400: {
                    throw new BadRequestException(this.getBodyAsMessage(this.errorBody));
                }
                case 401: {
                    throw new UnauthorizedException(this.getBodyAsMessage(this.errorBody));
                }
                case 404: {
                    throw new NotFoundException(this.getBodyAsMessage(this.errorBody));
                }
                case 406: {
                    throw new NotAcceptableException(this.getBodyAsMessage(this.errorBody));
                }
                case 409: {
                    throw new ConflictException(this.getBodyAsMessage(this.errorBody));
                }
                case 500: {
                    throw new InternalServerErrorException(this.getBodyAsMessage(this.errorBody));
                }
                default: {
                    throw new DockerException(this.getBodyAsMessage(this.errorBody), this.response.status().code());
                }
            }
        }
        catch (Throwable e) {
            this.resultCallback.onError(e);
            return;
        }
        finally {
            this.resultCallback.onComplete();
        }
    }

    private String getBodyAsMessage(ByteBuf body) {
        String result = body.readBytes(body.readableBytes()).toString(Charset.forName("UTF-8"));
        body.discardReadBytes();
        body.release();
        return result;
    }
}

