/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.containers.WeakStringInterner;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;

abstract class FQNBase
implements FQN {
    static final String SYMBOL_DELIMITER = "::";
    static final WeakStringInterner INTERNER = new WeakStringInterner();
    private volatile int myHashCode = -1;

    FQNBase() {
    }

    @NotNull
    protected abstract SerializationFactory getSerializationFactory();

    @NotNull
    abstract List<String> getRawPath();

    @NotNull
    abstract byte[] getPathColors();

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        List<String> thisPath = this.getRawPath();
        List<String> thatPath = ((FQNBase)o).getRawPath();
        if (thisPath.size() != thatPath.size()) {
            return false;
        }
        Iterator<String> thisIterator = thisPath.iterator();
        Iterator<String> thatIterator = thatPath.iterator();
        while (thisIterator.hasNext()) {
            if (thisIterator.next() == thatIterator.next()) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        if (this.myHashCode != -1) {
            return this.myHashCode;
        }
        this.myHashCode = this.getRawPath().hashCode();
        return this.myHashCode;
    }

    protected static interface SerializationFactory {
        public void serialize(@NotNull FQN var1, @NotNull StubOutputStream var2) throws IllegalArgumentException, IOException;

        @NotNull
        public FQN deserialize(@NotNull StubInputStream var1) throws IllegalArgumentException, IOException;
    }
}

