/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DiagramNodeContainer
extends CellRendererPanel {
    private final GradientFilledPanel myHeader;
    private final JPanel myBody;
    private final DiagramNode myNode;
    private final DiagramNodeBodyComponent myNodeBodyComponent;
    private final DiagramBuilder myBuilder;
    private SoftReference<BufferedImage> myCache;
    private double myCacheScaleX;
    private double myCacheScaleY;
    private int myCacheWidth;
    private int myCacheHeight;
    private Boolean myCacheSelected;
    private Icon myCacheIcon;

    public DiagramNodeContainer(DiagramNode node, DiagramBuilder builder, Point point) {
        this.myBuilder = builder;
        this.setLayout(new BorderLayout(0, 0));
        this.setFocusable(false);
        this.setBorder((Border)JBUI.Borders.empty());
        this.myNode = node;
        this.myHeader = new DiagramNodeHeaderComponent(node, builder);
        this.myBody = new CellRendererPanel();
        this.myBody.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myBody.setBorder((Border)JBUI.Borders.empty());
        this.myNodeBodyComponent = new DiagramNodeBodyComponent(this.myNode, builder, point);
        this.myBody.add((Component)((Object)this.myNodeBodyComponent));
        if (UIUtil.isUnderDarcula() && this.myNodeBodyComponent.getComponentCount() > 0) {
            this.myHeader.setBorder((Border)new CustomLineBorder((Color)(GraphViewUtil.isPrintMode() ? Gray._168 : Gray._90), 0, 0, 1, 0));
        }
        if (GraphViewUtil.isPrintMode() && this.myNodeBodyComponent.getComponentCount() == 0) {
            this.myHeader.setBorder((Border)JBUI.Borders.empty());
        }
        this.add(this.getHeader(), "North");
        if (this.getBody().getComponentCount() > 0) {
            this.add(this.getBody(), "Center");
        }
        for (JComponent c : UIUtil.uiTraverser((Component)((Object)this)).filter(JComponent.class)) {
            UIUtil.putClientProperty((JComponent)c, (Key)IdeBackgroundUtil.NO_BACKGROUND, (Object)true);
        }
    }

    public JPanel getHeader() {
        return this.myHeader;
    }

    public JPanel getBody() {
        return this.myBody;
    }

    public DiagramNodeBodyComponent getNodeBodyComponent() {
        return this.myNodeBodyComponent;
    }

    public void paint(Graphics g) {
        boolean tooLargeToCache;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Boolean isSelected = (Boolean)this.myNode.getUserData(DiagramNode.SELECTED_NODE_KEY);
        Rectangle visibleRect = this.myBuilder.getView().getVisibleRect();
        boolean bl = tooLargeToCache = visibleRect.width <= width || visibleRect.height <= height;
        if (GraphViewUtil.isPrintMode() || GraphViewUtil.isExportMode() || tooLargeToCache || UIUtil.isPrinting((Graphics)g) || this.getClientProperty("cell.editor") == Boolean.TRUE) {
            this.doPaint(g, isSelected);
            return;
        }
        Icon icon = this.myNode.getIcon();
        Graphics2D g2d = (Graphics2D)g;
        float sysScale = JBUI.sysScale((Graphics2D)g2d);
        double scaleX = g2d.getTransform().getScaleX() / (double)sysScale;
        double scaleY = g2d.getTransform().getScaleY() / (double)sysScale;
        BufferedImage image = (BufferedImage)SoftReference.dereference(this.myCache);
        if (image == null || this.myCacheWidth != width || this.myCacheHeight != height || Math.abs(scaleX - this.myCacheScaleX) > 0.01 || Math.abs(scaleY - this.myCacheScaleY) > 0.01 || !Comparing.equal((Object)this.myCacheSelected, (Object)isSelected) || !Comparing.equal((Object)this.myCacheIcon, (Object)icon)) {
            image = UIUtil.createImage((Graphics)g, (int)((int)Math.round((double)width * scaleX)), (int)((int)Math.round((double)height * scaleY)), (int)1);
            this.doPaint(image, isSelected, scaleX, scaleY);
            this.myCacheWidth = width;
            this.myCacheHeight = height;
            this.myCacheScaleX = scaleX;
            this.myCacheScaleY = scaleY;
            this.myCacheSelected = isSelected;
            this.myCacheIcon = icon;
            this.myCache = new SoftReference((Object)image);
        }
        ((Graphics2D)g).scale(1.0 / scaleX, 1.0 / scaleY);
        UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
        ((Graphics2D)g).scale(scaleX, 1.0 / scaleY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaint(BufferedImage image, Boolean isSelected, double scaleX, double scaleY) {
        boolean wasDoubleBuffered = this.isDoubleBuffered();
        if (wasDoubleBuffered) {
            this.setDoubleBuffered(false);
        }
        Graphics2D g = image.createGraphics();
        g.scale(scaleX, scaleY);
        try {
            if (SystemInfo.isJetBrainsJvm) {
                g.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, DiagramNodeContainer.getContrastForColor(this.getForeground()));
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            GraphicsUtil.setupAntialiasing((Graphics)g);
            this.doPaint(g, isSelected);
        }
        finally {
            g.dispose();
        }
        if (wasDoubleBuffered) {
            this.setDoubleBuffered(true);
        }
    }

    private static int getContrastForColor(Color color) {
        int yiqValue = (color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114) / 1000;
        return yiqValue * 150 / 255 + 100;
    }

    private void doPaint(Graphics g, Boolean isSelected) {
        Color color = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(color);
        if (isSelected != null && !isSelected.booleanValue()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        super.paint(g);
    }
}

