/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.presentation;

public enum VisibilityLevel {
    PUBLIC,
    PACKAGE,
    PROTECTED,
    PRIVATE;

    private static final String ALL = "All";

    public static VisibilityLevel fromString(String name) {
        if (name == null || name.equalsIgnoreCase(ALL)) {
            return PRIVATE;
        }
        for (VisibilityLevel level : VisibilityLevel.values()) {
            if (!level.name().equalsIgnoreCase(name)) continue;
            return level;
        }
        return PRIVATE;
    }

    public String toString() {
        return this == PRIVATE ? ALL : VisibilityLevel.capitalizeFirstLetter(this.name().toLowerCase());
    }

    private static String capitalizeFirstLetter(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public boolean weakerThan(VisibilityLevel level) {
        return this.compareTo(level) <= 0;
    }
}

