/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementFactory;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public class GherkinScenarioToScenarioOutlineInspection
extends GherkinInspection {
    private static final ConvertScenarioToOutlineFix CONVERT_SCENARIO_TO_OUTLINE_FIX = new ConvertScenarioToOutlineFix();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GherkinScenarioToScenarioOutlineInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GherkinScenarioToScenarioOutlineInspection.$$$reportNull$$$0(1);
        }
        GherkinElementVisitor gherkinElementVisitor = new GherkinElementVisitor(){

            @Override
            public void visitScenario(GherkinScenario scenario) {
                if (scenario instanceof GherkinScenarioOutline) {
                    return;
                }
                if (Stream.of(scenario.getChildren()).anyMatch(p -> PsiUtilCore.getElementType((PsiElement)p) == GherkinElementTypes.EXAMPLES_BLOCK)) {
                    holder.registerProblem((PsiElement)scenario, scenario.getFirstChild().getTextRangeInParent(), CucumberBundle.message("inspection.gherkin.scenario.with.examples.section.error.message", new Object[0]), new LocalQuickFix[]{CONVERT_SCENARIO_TO_OUTLINE_FIX});
                }
            }
        };
        if (gherkinElementVisitor == null) {
            GherkinScenarioToScenarioOutlineInspection.$$$reportNull$$$0(2);
        }
        return gherkinElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/GherkinScenarioToScenarioOutlineInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/GherkinScenarioToScenarioOutlineInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertScenarioToOutlineFix
    implements LocalQuickFix {
        private ConvertScenarioToOutlineFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CucumberBundle.message("inspection.gherkin.scenario.with.examples.section.quickfix.name", new Object[0]);
            if (string == null) {
                ConvertScenarioToOutlineFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ConvertScenarioToOutlineFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertScenarioToOutlineFix.$$$reportNull$$$0(2);
            }
            GherkinScenario scenario = (GherkinScenario)descriptor.getPsiElement();
            String language = GherkinKeywordTable.getFeatureLanguage(scenario.getContainingFile());
            GherkinKeywordTable keywordsTable = JsonGherkinKeywordProvider.getKeywordProvider().getKeywordsTable(language);
            Collection<String> scenarioKeywords = keywordsTable.getScenarioKeywords();
            String scenarioRegexp = StringUtil.join(scenarioKeywords, (String)"|");
            String scenarioOutlineKeyword = keywordsTable.getScenarioOutlineKeyword();
            String scenarioOutlineText = scenario.getText().replaceFirst(scenarioRegexp, scenarioOutlineKeyword);
            GherkinScenarioOutline scenarioOutline = (GherkinScenarioOutline)GherkinElementFactory.createScenarioFromText(project, language, scenarioOutlineText);
            scenario.replace(scenarioOutline);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/GherkinScenarioToScenarioOutlineInspection$ConvertScenarioToOutlineFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/GherkinScenarioToScenarioOutlineInspection$ConvertScenarioToOutlineFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

