/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ScriptGenerator {
    private final String myPrefix;
    private final Class myMainClass;
    private final ArrayList<String> myPaths = new ArrayList();
    private final ArrayList<String> myInternalParameters = new ArrayList();

    public ScriptGenerator(String prefix, Class mainClass) {
        this.myPrefix = prefix;
        this.myMainClass = mainClass;
        this.addClasses(this.myMainClass);
    }

    public ScriptGenerator addClasses(Class ... classes) {
        for (Class c : classes) {
            this.addPath(PathUtil.getJarPathForClass((Class)c));
        }
        return this;
    }

    private void addPath(String path) {
        if (!this.myPaths.contains(path)) {
            this.myPaths.add(path);
        }
    }

    public ScriptGenerator addResource(Class base, @NonNls String resource) {
        this.addPath(ScriptGenerator.getJarForResource(base, resource));
        return this;
    }

    public ScriptGenerator addInternal(String ... parameters) {
        ContainerUtil.addAll(this.myInternalParameters, (Object[])parameters);
        return this;
    }

    @NotNull
    private static File generateBatch(@NotNull String fileName, @NotNull String commandLine) throws IOException {
        if (fileName == null) {
            ScriptGenerator.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            ScriptGenerator.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@echo off").append("\n");
        sb.append(commandLine).append(" %*").append("\n");
        File file = ScriptGenerator.createTempExecutable(fileName + ".bat", sb.toString());
        if (file == null) {
            ScriptGenerator.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    private static File generateShell(@NotNull String fileName, @NotNull String commandLine) throws IOException {
        if (fileName == null) {
            ScriptGenerator.$$$reportNull$$$0(3);
        }
        if (commandLine == null) {
            ScriptGenerator.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/sh").append("\n");
        sb.append(commandLine).append(" \"$@\"").append("\n");
        File file = ScriptGenerator.createTempExecutable(fileName + ".sh", sb.toString());
        if (file == null) {
            ScriptGenerator.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    private static File createTempExecutable(@NotNull String fileName, @NotNull String content) throws IOException {
        if (fileName == null) {
            ScriptGenerator.$$$reportNull$$$0(6);
        }
        if (content == null) {
            ScriptGenerator.$$$reportNull$$$0(7);
        }
        File file = new File(PathManager.getTempPath(), fileName);
        if (SystemInfo.isWindows && file.getPath().contains(" ")) {
            file = new File(FileUtil.getTempDirectory(), fileName);
        }
        FileUtil.writeToFile((File)file, (String)content);
        FileUtil.setExecutableAttribute((String)file.getPath(), (boolean)true);
        File file2 = file;
        if (file2 == null) {
            ScriptGenerator.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @NotNull
    public File generate(boolean useBatchFile) throws IOException {
        String commandLine = this.commandLine();
        File file = useBatchFile ? ScriptGenerator.generateBatch(this.myPrefix, commandLine) : ScriptGenerator.generateShell(this.myPrefix, commandLine);
        if (file == null) {
            ScriptGenerator.$$$reportNull$$$0(9);
        }
        return file;
    }

    public String commandLine() {
        StringBuilder cmd = new StringBuilder();
        cmd.append('\"').append(System.getProperty("java.home")).append(File.separatorChar).append("bin").append(File.separatorChar).append("java\" -cp \"");
        boolean first = true;
        for (String p : this.myPaths) {
            if (!first) {
                cmd.append(File.pathSeparatorChar);
            } else {
                first = false;
            }
            cmd.append(p);
        }
        cmd.append("\" ");
        cmd.append(this.myMainClass.getName());
        for (String p : this.myInternalParameters) {
            cmd.append(' ');
            cmd.append(p);
        }
        String line = cmd.toString();
        if (SystemInfo.isWindows) {
            line = line.replace('\\', '/');
        }
        return line;
    }

    public static String getJarForResource(Class context, String res) {
        String resourceRoot = PathManager.getResourceRoot((Class)context, (String)res);
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/git4idea/util/ScriptGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/git4idea/util/ScriptGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateBatch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateShell";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempExecutable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateBatch";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateShell";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTempExecutable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

