/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.adapters;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.lang.puppet.adapters.PuppetDependencyManagerAdapter;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetAbstractLibrarianAdapter
extends PuppetDependencyManagerAdapter {
    public static final String LIBRARIAN_EXECUTABLE_NAME = "librarian-puppet";
    public static final String LIBRARIAN_EXECUTABLE_WIN_NAME = "librarian-puppet.bat";
    private static final String LIBRARIAN_INTERNAL_DIR_NAME = ".librarian";

    @NotNull
    protected abstract Logger getLogger();

    @Override
    public boolean isApplicable(@NotNull PuppetEntity entity) {
        if (entity == null) {
            PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(0);
        }
        return entity.getPuppetFile() != null || entity instanceof PuppetModule && !((PuppetModule)entity).isHeadless();
    }

    @Nullable
    protected List<String> createLibrarianArguments(@NotNull PuppetEntity entity) {
        if (entity == null) {
            PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(1);
        }
        return Arrays.asList("install", "--verbose", "--path=" + entity.getLibrarianDependenciesRootName());
    }

    protected void configureEnvironment(@NotNull Map<String, String> env) {
        if (env == null) {
            PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(2);
        }
        String librarianCachePath = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{FileUtil.getTempDirectory(), LIBRARIAN_INTERNAL_DIR_NAME}));
        this.getLogger().info(MessageFormat.format("Using {0} as librarian cache directory", librarianCachePath));
        env.put("LIBRARIAN_PUPPET_TMP", librarianCachePath);
    }

    @Nullable
    protected static VirtualFile getLibrarianInternalDir(@NotNull VirtualFile root) {
        if (root == null) {
            PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!root.isValid()) {
            return null;
        }
        return root.findChild(LIBRARIAN_INTERNAL_DIR_NAME);
    }

    public static void excludeVirtualFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(5);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (project == null) {
                PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(6);
            }
            if (file == null) {
                PuppetAbstractLibrarianAdapter.$$$reportNull$$$0(7);
            }
            if (project.isDisposed() || !file.isValid()) {
                return;
            }
            Module currentModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (currentModule == null) {
                return;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)currentModule).getModifiableModel();
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)file);
            if (entry == null) {
                return;
            }
            entry.addExcludeFolder(file);
            application.runWriteAction(() -> model.commit());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/adapters/PuppetAbstractLibrarianAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createLibrarianArguments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configureEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibrarianInternalDir";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeVirtualFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$excludeVirtualFile$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

