/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PuppetProjectFilesListener
implements BulkFileListener {
    private static final Set<String> KEY_FILE_NAMES = new THashSet(Arrays.asList("environment.conf", "Puppetfile", "metadata.json", ".fixtures.yml"));
    @NotNull
    protected final Project myProject;
    @NotNull
    private final PuppetProjectManager myProjectManager;

    PuppetProjectFilesListener(@NotNull Project project) {
        if (project == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProjectManager = PuppetProjectManager.getInstance(project);
    }

    private static boolean isOurFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(1);
        }
        return PuppetProjectFilesListener.isOurFile(virtualFile.isDirectory(), virtualFile.getName());
    }

    private static boolean isOurFile(boolean isDirectory, String name) {
        return !isDirectory && KEY_FILE_NAMES.contains(name);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(2);
        }
        THashSet dirsToUpdateMetadata = new THashSet();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent che = (VFileContentChangeEvent)vFileEvent;
                file = che.getFile();
                if (!PuppetProjectFilesListener.isOurFile(file)) continue;
                dirsToUpdateMetadata.add(file.getParent());
                continue;
            }
            if (vFileEvent instanceof VFileDeleteEvent) {
                VFileDeleteEvent de = (VFileDeleteEvent)vFileEvent;
                file = de.getFile();
                if (!KEY_FILE_NAMES.contains(file.getName())) continue;
                dirsToUpdateMetadata.add(file.getParent());
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                VirtualFile dependencyOwnerRoot;
                VFileCreateEvent ce = (VFileCreateEvent)vFileEvent;
                if (PuppetProjectFilesListener.isOurFile(ce.isDirectory(), ce.getChildName())) {
                    dirsToUpdateMetadata.add(ce.getParent());
                    continue;
                }
                if (!ce.isDirectory() || (dependencyOwnerRoot = this.getPossibleDependencyOwnerRoot(ce.getParent())) == null) continue;
                dirsToUpdateMetadata.add(dependencyOwnerRoot);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            this.myProjectManager.rescanProjectStructure();
            return;
        }
        if (!dirsToUpdateMetadata.isEmpty()) {
            for (VirtualFile virtualFile : dirsToUpdateMetadata) {
                this.myProjectManager.updateMetadata(virtualFile);
            }
            this.myProjectManager.projectUpdated();
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(3);
        }
        THashSet rootsToClear = new THashSet();
        PuppetProjectManager puppetProjectManager = PuppetProjectManager.getInstance(this.myProject);
        for (VFileEvent vFileEvent : events) {
            VFileDeleteEvent de;
            VirtualFile file;
            if (!(vFileEvent instanceof VFileDeleteEvent) || !(file = (de = (VFileDeleteEvent)vFileEvent).getFile()).isDirectory()) continue;
            for (VirtualFile root : puppetProjectManager.getAllRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)root, (boolean)false)) continue;
                rootsToClear.add(root);
            }
        }
        if (!rootsToClear.isEmpty()) {
            for (VirtualFile virtualFile : rootsToClear) {
                this.myProjectManager.clearMetaData(virtualFile);
            }
            this.myProjectManager.projectUpdated();
        }
    }

    @Nullable
    private VirtualFile getPossibleDependencyOwnerRoot(@NotNull VirtualFile possibleDependencyRoot) {
        PuppetEntity containingEntity;
        if (possibleDependencyRoot == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(4);
        }
        if ((containingEntity = PuppetProjectManager.getInstance(this.myProject).findExplicitModuleOrEnvironmentForFile(possibleDependencyRoot)) == null || !containingEntity.isValid()) {
            return null;
        }
        for (VirtualFile dependencyRoot : containingEntity.getAllDependenciesRoots()) {
            if (!possibleDependencyRoot.equals(dependencyRoot)) continue;
            return containingEntity.getRoot();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleDependencyRoot";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/project/PuppetProjectFilesListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isOurFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPossibleDependencyOwnerRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

