/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.psi.SlimLanguageLevel;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;
import org.jetbrains.plugins.slim.settings.SlimLanguageCodeStyleSettingsProvider;

public final class _SlimLexer
implements FlexLexer,
SlimTokenTypes {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int IN_CODE_COMMENT = 2;
    public static final int IN_HTML_COMMENT = 4;
    public static final int IN_DOCTYPE = 6;
    public static final int IN_TAG_STATE = 8;
    public static final int IN_ID_STATE = 10;
    public static final int IN_CLASS_STATE = 12;
    public static final int IN_SHORTCUT_STATE = 14;
    public static final int AFTER_TAG_STATE = 16;
    public static final int IN_ATTR_STATE = 18;
    public static final int IN_ATTR_VALUE_STATE = 20;
    public static final int AFTER_ATTRS_STATE = 22;
    public static final int RUBY_CALL_STATE = 24;
    public static final int IN_RUBY_CALL_STATE = 26;
    public static final int AFTER_RUBY_CALL_STATE = 28;
    public static final int IN_STATIC_CONTENT = 30;
    public static final int IN_WRAPPED_STATIC_CONTENT = 32;
    public static final int IN_WRAPPED_ATTR_VALUE = 34;
    public static final int IN_WRAPPED_ATTRS_LIST_STATE = 36;
    public static final int IN_FILTER_STATE = 38;
    public static final int IN_SPLAT_STATE = 40;
    public static final int IN_SINGLE_QUOTED_STRING_LITERAL = 42;
    public static final int IN_DOUBLE_QUOTED_STRING_LITERAL = 44;
    public static final int BAD_CHARS_STATE = 46;
    public static final int IN_IMPLICIT_TAG_STATE = 48;
    public static final int BEFORE_TAG_NAME_STATE = 50;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24};
    static final char[] ZZ_CMAP_Z = _SlimLexer.zzUnpackCMap("\u0001\u0000\u0001@\u0001\u0080\u010d@");
    static final char[] ZZ_CMAP_Y = _SlimLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0001\u0002}\u0003\u0001\u0004?\u0003");
    static final char[] ZZ_CMAP_A = _SlimLexer.zzUnpackCMap("\t\u0000\u0001\u0001\u0001\u0002\u0003\u0003\u0012\u0000\u0001\u0001\u0001\u0006\u00010\u0001+\u0001\u0000\u0002\u0013\u0001*\u0001.\u0001\u0007\u0001\u0012\u0001\u0000\u00013\u0001\u0011\u0001-\u0001\u0004\n\u0010\u0001\u0019\u0001\u0000\u0001\u0014\u0001/\u0001\u0015\u0001\u0000\u0001\u0013\u001a\u000f\u0001\u0005\u00011\u0001\u0007\u0001\u0013\u0001\u000f\u0001\u0000\u0001\u001b\u0001\u0018\u0001\n\u0001\b\u0001\u000e\u0001(\u0001'\u0001\u001f\u0001\u001e\u0001\u001a\u0001#\u0001!\u0001 \u0001%\u0001\t\u0001\r\u0001\"\u0001\u0016\u0001\u001d\u0001\u000b\u0001\u0017\u0001\u001c\u0001$\u0001&\u0001\f\u0001\u000f\u0001,\u0001)\u00012\u0007\u0000\u0001\u0003\u00a2\u0000\u0002\u0003\u0016\u0000");
    private static final int[] ZZ_ACTION = _SlimLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0010\u0000\u0002\u0002\u0003\u0000\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0003\u0005\u0006\u0001\u0007\u0001\u0003\u0001\b\b\u0006\u0001\t\u0001\b\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u0004\u0001\u000f\u0001\u0004\u0001\u0010\u0001\u0011\u0002\u0003\u0002\u0001\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0004\u0001\u0015\u0001\u0012\u0001\u0016\u0001\u0003\u0001\u0017\u0001\u0018\u0001\u0017\u0001\u0019\u0006\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u0019\u0001\u001f\u0001 \u0001!\u0003\"\u0001#\u0001$\u0001%\u0001&\u0001'\u0001(\u0002)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u00010\u00012\u00013\u00014\u00015\u0001\u0002\u00016\u0003\u0002\u00017\u00018\u00019\u0001:\u0001\u0000\u0001;\u0002<\u0001=\u0001>\u0006\u0006\u0001?\u000b\u0006\u0002\n\u0001@\u0002A\u0004\u0000\u00010\u0001B\u0002C\u0001D\u0001E\u0001F\u0001G\u0001H\u0001I\u00012\u00014\u0001\u0002\u0001J\r\u0006\u0002@\u0001K\u0001D\u0001L\u0002\u0006\u0001M\u0018\u0006\u0001N\u0002\u0006";
    private static final int[] ZZ_ROWMAP = _SlimLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00004\u0000h\u0000\u009c\u0000\u00d0\u0000\u0104\u0000\u0138\u0000\u016c\u0000\u01a0\u0000\u01d4\u0000\u0208\u0000\u023c\u0000\u0270\u0000\u02a4\u0000\u02d8\u0000\u030c\u0000\u0340\u0000\u0374\u0000\u03a8\u0000\u03dc\u0000\u0410\u0000\u0444\u0000\u0478\u0000\u04ac\u0000\u04e0\u0000\u0514\u0000\u0548\u0000\u0514\u0000\u057c\u0000\u05b0\u0000\u05e4\u0000\u0618\u0000\u064c\u0000\u0680\u0000\u0514\u0000\u06b4\u0000\u06e8\u0000\u071c\u0000\u0750\u0000\u0784\u0000\u07b8\u0000\u07ec\u0000\u0820\u0000\u0854\u0000\u0888\u0000\u0514\u0000\u0514\u0000\u08bc\u0000\u08f0\u0000\u0924\u0000\u0958\u0000\u098c\u0000\u09c0\u0000\u0514\u0000\u09f4\u0000\u0514\u0000\u0514\u0000\u0a28\u0000\u0a5c\u0000\u0a90\u0000\u0514\u0000\u0ac4\u0000\u0514\u0000\u0514\u0000\u0af8\u0000\u0b2c\u0000\u0514\u0000\u0b60\u0000\u0b94\u0000\u0514\u0000\u0bc8\u0000\u0a28\u0000\u0514\u0000\u0514\u0000\u0bfc\u0000\u0c30\u0000\u0c64\u0000\u0a5c\u0000\u0ac4\u0000\u0514\u0000\u0c98\u0000\u0514\u0000\u0ccc\u0000\u0d00\u0000\u0514\u0000\u0514\u0000\u0514\u0000\u0514\u0000\u0d34\u0000\u0a5c\u0000\u0d68\u0000\u0d9c\u0000\u0514\u0000\u0514\u0000\u0514\u0000\u0dd0\u0000\u0e04\u0000\u0e38\u0000\u0e6c\u0000\u0ea0\u0000\u0ed4\u0000\u0514\u0000\u0f08\u0000\u0514\u0000\u0f3c\u0000\u0514\u0000\u0f70\u0000\u0fa4\u0000\u0fd8\u0000\u100c\u0000\u0514\u0000\u1040\u0000\u0514\u0000\u1074\u0000\u10a8\u0000\u10dc\u0000\u1110\u0000\u0514\u0000\u0514\u0000\u1144\u0000\u1178\u0000\u0514\u0000\u11ac\u0000\u0514\u0000\u11e0\u0000\u1214\u0000\u1248\u0000\u127c\u0000\u12b0\u0000\u12e4\u0000\u1318\u0000\u134c\u0000\u0514\u0000\u1380\u0000\u13b4\u0000\u13e8\u0000\u141c\u0000\u1450\u0000\u1484\u0000\u14b8\u0000\u14ec\u0000\u1520\u0000\u1554\u0000\u1588\u0000\u15bc\u0000\u0514\u0000\u15f0\u0000\u0514\u0000\u0a5c\u0000\u1624\u0000\u0bfc\u0000\u0c30\u0000\u1658\u0000\u0514\u0000\u0514\u0000\u0514\u0000\u0d34\u0000\u168c\u0000\u0514\u0000\u0514\u0000\u16c0\u0000\u0514\u0000\u16f4\u0000\u1728\u0000\u175c\u0000\u0514\u0000\u1790\u0000\u17c4\u0000\u17f8\u0000\u182c\u0000\u1860\u0000\u1894\u0000\u18c8\u0000\u18fc\u0000\u1930\u0000\u1964\u0000\u1998\u0000\u19cc\u0000\u1a00\u0000\u1a34\u0000\u1a68\u0000\u0514\u0000\u0514\u0000\u0514\u0000\u0514\u0000\u1a9c\u0000\u1ad0\u0000\u0514\u0000\u1b04\u0000\u1b38\u0000\u1b6c\u0000\u1ba0\u0000\u1bd4\u0000\u1c08\u0000\u1c3c\u0000\u1c70\u0000\u1ca4\u0000\u1cd8\u0000\u1d0c\u0000\u1d40\u0000\u1d74\u0000\u1da8\u0000\u1ddc\u0000\u1e10\u0000\u1e44\u0000\u1e78\u0000\u1eac\u0000\u1ee0\u0000\u1f14\u0000\u1f48\u0000\u1f7c\u0000\u1fb0\u0000\u0514\u0000\u1fe4\u0000\u2018";
    private static final int[] ZZ_TRANS = _SlimLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001a\u0001\u001d\u0003\u001a\u0001\u001e\u0001\u001f\u0001 \u0001!\u0002\u001f\u0001\"\u0001\u001f\u0001\u001a\u0001#\u0001$\u0001%\u0002\u001a\u0001&\u0001\u001f\u0001'\u0001\u001a\u0001(\u0002\u001f\u0001)\u0001\u001f\u0001*\u0001+\u0001,\u0003\u001f\u0001-\u0003\u001f\u0002.\u0001/\u0001\u001a\u0001/\u0001\u001a\u00010\u0004\u001a\u00011\u00012\u0001311\u00014\u00015\u0001614\u0001\u001a\u00017\u00018\u0002\u001a\u00019\f\u001a\u0001:\u0001;\u0001<\u0001=\u0003\u001a\u0001>\u000f\u001a\u0002.\u0001?\u00019\u0001@\u00019\u00010\u0005\u001a\u0001A\u00018\u0002\u001a\u00019\u0002\u001a\bB\u0002\u001a\u0001:\u0003\u001a\u0003B\u0001C\u000fB\u0003\u001a\u00019\u0001\u001a\u00019\u0006\u001a\u0001A\u00018\u0002\u001a\u00019\u0002\u001a\bD\u0001\u001a\u0001E\u0001:\u0003\u001a\u0003D\u0001C\u000fD\u0003\u001a\u00019\u0001\u001a\u00019\u0005\u001a\u0001F\u0001A\u00018\u0002F\u00019\u0002F\bG\u0002F\u0001H\u0003F\u0003G\u0001F\u000fG\u0003F\u00019\u0001F\u00019\u0001I\u0004F\u0001J\u0001K\u00018\u0005J\bL\u0002J\u0001M\u0001N\u0002J\u0003L\u0001O\u000fL\u000bJ\u0001P\u0001Q\u0001R\u0005P\bS\u0006P\u0003S\u0001P\u000fS\u0006P\u0001T\u0004P\u0001U\u0001Q\u0001R'U\u0001V\u0005U\u0001W\u0003U\u0001X\u0001Y\u00018\u0010X\u0001Z\u0005X\u0001>\u0015X\u00010\u0004X\u0002[\u0001\\1[\u0002]\u0001^/]\u0001_\u0001]\u0002P\u0001\u001a/P\u0001`\u0001P\u0001a\u0001b\u0001c(a\u0001d\ta\u0001e\u0001c(a\u0001d\ba\u0001f\u0001g\u000181f\u0001h\u0001i\u0001\u001c\u0004h\u0001j\bk\u0006h\u0003k\u0001h\u000fk\th\u0001j\u0001h\u0001l\u0001m\u0001n1l,\u001a\u0001o\u0007\u001a\u0002p\u00018'p\u0001q\u0001d\u0005p\u0001r\u0002p\u0002s\u00018(s\u0001d\u0004s\u0001q\u0001t\u0002s\u0002u\u0001v1u\u0002w\u0001\u00001w\b\u0000\bx\u0002\u0000\u0001y\u0003\u0000\u0003x\u0001\u0000\u000fx@\u0000\u0001\u001b-\u0000\u0001z\u0004\u0000\u0002{\u0001|\u0002{\u0001}\u0001~-{\b\u0000\u0001\u001f\u0001\u007f\b\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0001\u001f\u0001\u0080\b\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0003\u001f\u0001\u0081\u000b\u001f\u0013\u0000\u0006\u001f\u0001\u0082\u0003\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u0083\u0002\u001f\u0001\u0000\u000f\u001f\u0013\u0000\b\u0084\u0006\u0000\u0003\u0084\u0001\u0000\u000f\u0084\u0003\u0000\u0001\u0085\u001a\u0000\u0001%(\u0000\u0001\u0086\t\u001f\u0004\u0000\u0001\u001f\u0001\u0087\u0001\u001f\u0001\u0000\u0001\u001f\u0001\u0088\r\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u001f\u0001\u0089\u0001\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0001\u001f\u0001\u008a\r\u001f\u0013\u0000\u0002\u001f\u0001\u008b\u0001\u008c\u0006\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0001\u001f\u0001\u008b\r\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0001\u001f\u0001\u008d\r\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0001\u001f\u0001\u008e\r\u001f\u0013\u0000\u0006\u001f\u0001\u008b\u0003\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u008f\n\u001f\u0013\u0000\u0001\u001f\u0001\u0090\b\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u001f\u0000\u0001\u0091\u0001\u0092\u0014\u0000\u0001\u0092\u0004\u0000\u0001\u0093\u0004\u0000\u00021\u0002\u000001\u0001\u0000\u000123\u0000\u000132\u0000\u00014\u0002\u000014\u0001\u0000\u000153\u0000\u00017\u0003\u0000\u00019&\u0000\u00019\u0001\u0000\u00019\u0001z0\u0000\u0001\u0085\u0007\u0000\u0001\u0094\u0002\u0000\u0010\u0094\u0001\u0095 \u0094\u0015\u0000\u0001=&\u0000\b\u0096\u0006\u0000\u0003\u0096\u0001\u0000\u000f\u0096\f\u0000\u0001A\u0003\u0000\u00019&\u0000\u00019\u0001\u0000\u00019\r\u0000\nB\u0004\u0000\u0003B\u0001\u0000\u000fB\u0013\u0000\nD\u0004\u0000\u0003D\u0001\u0000\u000fD\u0013\u0000\bD\u0006\u0000\u0003D\u0001\u0000\u000fD\u0013\u0000\nG\u0004\u0000\u0003G\u0001\u0000\u000fG\f\u0000\u0001\u0097\u0006\u0000\b\u0098\u0006\u0000\u0003\u0098\u0001\u0000\u000f\u0098\f\u0000\u0001\u0099\u0006\u0000\n\u0098\u0004\u0000\u0003\u0098\u0001\u0000\u000f\u0098\u0006\u0000\u0001\u009a\u0004\u0000\u0001\u009b\u0002\u00001\u009b\u0001\u0000\u0001Q:\u0000\nS\u0004\u0000\u0003S\u0001\u0000\u000fS:\u0000\u0001I\u0004\u0000\u0001\u009c\u0001\u009d-\u009c\u0001z\u0004\u009c\u0002[\u0001\u0000.[\u0001\u009e\u0001[\u0001\u009e\u0002\u0000\u0001\u009fc\u0000\u0001\u00a0\u0001\u0000\u0002a\u0001\u0000(a\u0001\u0000\ba\u0001\u0000\u0001b3\u0000\u0001\u00a1\u0001\u00a2]\u0000\u0001\u00a3\b\u0000\u0001e3\u0000\u0001g3\u0000\u0001i:\u0000\nk\u0004\u0000\u0003k\u0001\u0000\u000fk\u000b\u0000\u0001l\u0001\u00a4\u0001\u00001l\u0001\u0000\u0001m3\u0000\u0001\u00a5\u0001n1\u0000\u0002p\u0001\u0000'p\u0002\u0000\u0005p\u0001r\u0004p\u0001\u00a6'p\u0002\u0000\u0005p\u0001r\u0002p\u0002s\u0001\u0000(s\u0001\u0000\u0004s\u0001\u0000\u0001t\u0004s\u0001\u00a6(s\u0001\u0000\u0004s\u0001\u0000\u0001t\u0002s\u0002u\u0001\u00001u\b\u0000\nx\u0004\u0000\u0003x\u0001\u0000\u000fx\u0013\u0000\b\u00a7\u0006\u0000\u0003\u00a7\u0001\u0000\u000f\u00a7\u000b\u0000\u0002{\u0002\u00000{\u0002}\u0002\u00000}\u0002~\u0002\u00000~\b\u0000\u0002\u001f\u0001\u00a8\u0007\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000e\u001f\u0001\u00a9\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0003\u001f\u0001\u00aa\u000b\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\f\u001f\u0001\u00ab\u0002\u001f\u0013\u0000\n\u001f\u0004\u0000\u0002\u001f\u0001\u00aa\u0001\u0000\u000f\u001f\u0013\u0000\t\u0084\u0005\u0000\u0003\u0084\u0001\u0000\u000f\u0084\u0013\u0000\u0001\u001f\u0001\u00ac\b\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0002\u001f\u0001\u00ad\u0001\u0000\u000f\u001f\u0013\u0000\u0001\u00ae\t\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u00af\n\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0002\u001f\u0001\u00b0\f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0003\u001f\u0001\u0081\u000b\u001f\u0013\u0000\u0004\u001f\u0001\u00b1\u0005\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0006\u001f\u0001\u00b1\b\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u00b2\u0002\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\b\u001f\u0001\u00b3\u0006\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\t\u001f\u0001\u00b4\u0005\u001f \u0000\u0001\u00922\u0000\u0001\u00b5\u0001\u00b6\u0014\u0000\u0001\u00b6\u0011\u0000\n\u0096\u0004\u0000\u0003\u0096\u0001\u0000\u000f\u0096\u0006\u0000\u0001\u00b7\u0005\u0000\u0001\u0099-\u0000\u0001\u009a\u0004\u0000\u0001[\u0001\u009e\u0001\u00b8.[\u0001\u009e\u0001[\u0001\u009e\u0001\u0000\u0001\u00a1^\u0000\u0001\u00b9\u0007\u0000\u0002\u00a4\u0002\u00000\u00a4\u0001\u0000\u0001\u00a5:\u0000\t\u00a7\u0005\u0000\u0003\u00a7\u0001\u0000\u000f\u00a7\u0013\u0000\u0003\u001f\u0001\u00ba\u0006\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000e\u001f\u0001\u00bb\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u00bc\u000f\u001f\u0013\u0000\u0003\u001f\u0001\u00bd\u0006\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0002\u001f\u0001\u00aa\u0007\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0004\u001f\u0001\u00aa\u0005\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u00be\n\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0007\u001f\u0001\u00bf\u0007\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0001\u001f\u0001\u00c0\r\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0007\u001f\u0001\u00aa\u0007\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\t\u001f\u0001\u00c1\u0005\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u001f\u0001\u00c2\u0001\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0001\u001f\u0001\u00c3\b\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f \u0000\u0001\u00b6&\u0000\u0004\u001f\u0001\u00c4\u0005\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0006\u001f\u0001\u00c5\u0003\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u00c6\n\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u001f\u0001\u0081\u0001\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0001\u00c7\t\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0003\u001f\u0001\u00c8\u000b\u001f\u0013\u0000\u0001\u00c9\t\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0001\u001f\u0001\u0087\r\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u00ca\n\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\r\u001f\u0001\u00cb\u0001\u001f\u0013\u0000\u0005\u001f\u0001\u00cc\u0004\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0006\u001f\u0001\u00aa\u0003\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0007\u001f\u0001\u00c5\u0007\u001f\u0013\u0000\u0006\u001f\u0001\u00cd\u0003\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0002\u001f\u0001\u00ce\u0007\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0001\u001f\u0001\u00cf\b\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0001\u00aa\t\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u00d0\n\u001f\u0013\u0000\u0006\u001f\u0001\u00d1\u0003\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u00aa\u0002\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u00d2\u0002\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\n\u001f\u0001\u00d3\u0004\u001f\u0013\u0000\n\u001f\u0004\u0000\u0001\u00d4\u0002\u001f\u0001\u0000\u000f\u001f\f\u0000\u0001\u00d5\u0006\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u00d6\n\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000b\u001f\u0001\u00aa\u0003\u001f\u0013\u0000\n\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u0004\u001f\u0001\u00aa\n\u001f\u0013\u0000\u0005\u001f\u0001\u00d7\u0004\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u0013\u0000\u0003\u001f\u0001\u00aa\u0006\u001f\u0004\u0000\u0003\u001f\u0001\u0000\u000f\u001f\u000b\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _SlimLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\u0001\u0010\u0000\u0002\u0001\u0003\u0000\u0001\t\u0001\u0001\u0001\t\u0006\u0001\u0001\t\n\u0001\u0002\t\u0006\u0001\u0001\t\u0001\u0001\u0002\t\u0003\u0001\u0001\t\u0001\u0001\u0002\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0002\u0001\u0002\t\u0005\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0001\u0004\t\u0004\u0001\u0003\t\u0006\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0004\u0001\u0001\t\u0001\u0001\u0001\t\u0004\u0001\u0002\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0001\t\b\u0001\u0001\t\f\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0004\u0000\u0003\t\u0002\u0001\u0002\t\u0001\u0001\u0001\t\u0003\u0001\u0001\t\u000f\u0001\u0004\t\u0002\u0001\u0001\t\u0018\u0001\u0001\t\u0002\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    public static final String[] STRINGS_TO_MERGE = new String[]{"else", "elsif"};
    private boolean isInEscapedInterpolation = false;
    private int currentIndent = 0;
    private int rubyCodeIndent = 0;
    private boolean rubyComment = false;
    private char attrsListOpenBrace;
    private char openBrace;
    private char closeBrace;
    private final Stack<Integer> stateStack = new Stack();
    private IElementType filterType;
    private SlimLanguageLevel mySlimLanguageLevel;
    private boolean rubyCodeExpected = false;
    private static final Map<Character, Character> MATCHING_BRACES = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('('), Character.valueOf(')'));
            this.put(Character.valueOf('['), Character.valueOf(']'));
            this.put(Character.valueOf('{'), Character.valueOf('}'));
        }
    };

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 12] | ch >> 6 & 0x3F] << 6 | ch & 0x3F];
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[215];
        int offset = 0;
        offset = _SlimLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[215];
        int offset = 0;
        offset = _SlimLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[8268];
        int offset = 0;
        offset = _SlimLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[215];
        int offset = 0;
        offset = _SlimLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public void setSlimLanguageLevel(@NotNull SlimLanguageLevel slimLanguageLevel) {
        if (slimLanguageLevel == null) {
            _SlimLexer.$$$reportNull$$$0(0);
        }
        this.mySlimLanguageLevel = slimLanguageLevel;
    }

    private int getTabSize() {
        return SlimLanguageCodeStyleSettingsProvider.TAB_SIZE;
    }

    private char nextChar() {
        int loc = this.getTokenStart() + 1;
        return 0 <= loc && loc < this.zzBuffer.length() ? this.zzBuffer.charAt(loc) : (char)'\uffff';
    }

    private char nextNotWhitespaceChar() {
        int loc;
        for (loc = this.getTokenEnd(); loc < this.zzBuffer.length() && StringUtil.isWhiteSpace((char)this.zzBuffer.charAt(loc)); ++loc) {
        }
        return loc < this.zzBuffer.length() ? this.zzBuffer.charAt(loc) : (char)'\uffff';
    }

    private boolean isFollowedByOneOfIdents(String[] idents) {
        int followingIndentOffset;
        for (followingIndentOffset = this.getTokenEnd(); followingIndentOffset < this.zzBuffer.length() && (StringUtil.isWhiteSpace((char)this.zzBuffer.charAt(followingIndentOffset)) || this.isRubyCodeStartMarker(this.zzBuffer.charAt(followingIndentOffset))); ++followingIndentOffset) {
        }
        for (String ident : idents) {
            if (followingIndentOffset + ident.length() > this.zzBuffer.length() || !this.zzBuffer.subSequence(followingIndentOffset, followingIndentOffset + ident.length()).toString().equals(ident)) continue;
            return true;
        }
        return false;
    }

    private boolean rubyInjectionMustBeMerged() {
        if (this.rubyComment) {
            return true;
        }
        return this.isFollowedByOneOfIdents(STRINGS_TO_MERGE);
    }

    private int nextIndentSize() {
        int result = 0;
        for (int loc = this.getTokenEnd(); loc < this.zzBuffer.length() && StringUtil.isWhiteSpace((char)this.zzBuffer.charAt(loc)); ++loc) {
            result += this.zzBuffer.charAt(loc) == '\t' ? this.getTabSize() : 1;
        }
        return result;
    }

    private boolean isRubyCodeStartMarker(char c) {
        return c == '-' | c == '=';
    }

    private int calcStringLength(CharSequence text) {
        int len = 0;
        int tabSize = this.getTabSize();
        for (int i = text.length() - 1; i >= 0; --i) {
            if (text.charAt(i) == '\t') {
                len += tabSize;
                continue;
            }
            ++len;
        }
        return len;
    }

    private int getIndentAtLoc(CharSequence s, int loc) {
        int tabSize = this.getTabSize();
        int currentIndent = 0;
        while (loc < s.length() && StringUtil.isWhiteSpace((char)s.charAt(loc))) {
            ++loc;
        }
        --loc;
        while (0 <= loc && s.charAt(loc) != '\n' && (loc == 0 || s.charAt(loc - 1) != '\\')) {
            char c = s.charAt(loc);
            currentIndent = c == '\t' ? (currentIndent += tabSize) : (StringUtil.isWhiteSpace((char)c) ? ++currentIndent : 0);
            --loc;
        }
        return currentIndent;
    }

    private int getCurrentIndent() {
        return this.getIndentAtLoc(this.zzBuffer, this.getTokenStart());
    }

    private char previousChar() {
        return this.charAt(-1);
    }

    private char charAt(int offset) {
        int loc = this.getTokenStart() + offset;
        return 0 <= loc && loc < this.zzBuffer.length() ? this.zzBuffer.charAt(loc) : (char)'\uffff';
    }

    private IElementType commentTypeByState() {
        return this.yystate() == 2 ? CODE_COMMENT : HTML_COMMENT;
    }

    private void yyBegin(int newState) {
        this.yybegin(newState);
    }

    private void yyPopState() {
        if (this.stateStack.size() > 0) {
            this.yyBegin(this.stateStack.pop());
        }
    }

    private void yyPushState(int newState) {
        this.stateStack.push(newState);
    }

    private String getPreviousLine() {
        int i;
        for (i = this.getTokenStart() - 1; i >= 0 && this.zzBuffer.charAt(i) != '\r'; --i) {
        }
        return this.zzBuffer.toString().substring(i + 1, this.getTokenStart());
    }

    private boolean isPrevLineRubyComment() {
        String previousLine = this.getPreviousLine();
        return previousLine.matches("[-=][ \t]*#.*");
    }

    private void readParens(boolean includeBraces) {
        int braceBalance = 1;
        int length = includeBraces ? 1 : 0;
        char c = '\uffff';
        while (braceBalance != 0) {
            char c2 = this.charAt(length);
            c = c2;
            if (c2 == '\uffff') break;
            if (c == this.openBrace) {
                ++braceBalance;
            }
            if (c == this.closeBrace) {
                --braceBalance;
            }
            ++length;
        }
        this.zzMarkedPos += length - 1;
        if (c != '\uffff' && !includeBraces) {
            --this.zzMarkedPos;
        }
    }

    private void readRubyTillSpace(char ... readBraces) {
        char c;
        Stack<Character> stack = new Stack<Character>();
        for (char brace : readBraces) {
            stack.push(Character.valueOf(brace));
        }
        int length = 0;
        char stringQuote = '\u0000';
        while ((c = this.charAt(length)) != '\uffff' && c != '\n') {
            if (c == '\\' && stringQuote != '\u0000' && this.charAt(length + 1) != '\uffff') {
                length += 2;
                continue;
            }
            if (c == '\'' || c == '\"') {
                if (stringQuote == '\u0000') {
                    stringQuote = c;
                } else if (c == stringQuote) {
                    stringQuote = '\u0000';
                }
            }
            if (stringQuote == '\u0000') {
                if (stack.size() == 0 && MATCHING_BRACES.values().contains(Character.valueOf(c))) break;
                if (MATCHING_BRACES.get(Character.valueOf(c)) != null) {
                    stack.push(Character.valueOf(c));
                }
                if (stack.size() > 0 && MATCHING_BRACES.get(stack.peek()).charValue() == c) {
                    stack.pop();
                }
                if (stack.size() == 0 && Character.isWhitespace(c)) break;
            }
            ++length;
        }
        this.zzMarkedPos += Math.max(0, length - 1);
    }

    private IElementType getFilterType(String filterName) {
        if (filterName != null) {
            if (filterName.startsWith("ruby")) {
                return RUBY_CODE;
            }
            if (filterName.startsWith("coffee")) {
                return COFFEE_CODE;
            }
            if (filterName.startsWith("javascript")) {
                return JAVASCRIPT_CODE;
            }
            if (filterName.startsWith("css")) {
                return CSS_CODE;
            }
            if (filterName.startsWith("sass")) {
                return SASS_CODE;
            }
            if (filterName.startsWith("scss")) {
                return SCSS_CODE;
            }
            if (filterName.startsWith("less")) {
                return LESS_CODE;
            }
            if (filterName.startsWith("styl")) {
                return STYLUS_CODE;
            }
        }
        return FILTER_CONTENT;
    }

    public _SlimLexer(Reader in) {
        this.stateStack.push(0);
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block158: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _SlimLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.yyBegin(16);
                    return LEADING_TRAILING_SPACE_SYMBOL;
                }
                case 79: {
                    continue block158;
                }
                case 2: {
                    return STRING_LITERAL;
                }
                case 80: {
                    continue block158;
                }
                case 3: {
                    this.stateStack.clear();
                    this.yyBegin(46);
                    this.yypushback(this.yylength());
                }
                case 81: {
                    continue block158;
                }
                case 4: {
                    char prev;
                    if (8 == this.yystate() || 10 == this.yystate() || 12 == this.yystate() || 14 == this.yystate()) {
                        this.yyBegin(16);
                        this.yypushback(this.yylength() - 1);
                    }
                    return (prev = this.previousChar()) == '\n' || prev == '\uffff' ? INDENT : WHITESPACE;
                }
                case 82: {
                    continue block158;
                }
                case 5: {
                    return EOL;
                }
                case 83: {
                    continue block158;
                }
                case 6: {
                    this.yypushback(this.yylength());
                    this.yyBegin(50);
                    return PSEUDO_TAG_START;
                }
                case 84: {
                    continue block158;
                }
                case 7: {
                    this.currentIndent = this.getCurrentIndent();
                    this.rubyCodeIndent = this.getCurrentIndent();
                    this.rubyCodeExpected = true;
                    this.yyBegin(24);
                    return RUBY_CODE;
                }
                case 85: {
                    continue block158;
                }
                case 8: {
                    this.yypushback(this.yylength());
                    this.yyBegin(48);
                    return PSEUDO_TAG_START;
                }
                case 86: {
                    continue block158;
                }
                case 9: {
                    this.yyBegin(30);
                    this.currentIndent = this.getCurrentIndent();
                    return STATIC_CONTENT_START;
                }
                case 87: {
                    continue block158;
                }
                case 10: {
                    this.currentIndent = this.getCurrentIndent();
                    this.rubyCodeIndent = this.getCurrentIndent();
                    this.rubyCodeExpected = true;
                    this.yyBegin(24);
                    return RUBY_CODE;
                }
                case 88: {
                    continue block158;
                }
                case 11: {
                    return this.commentTypeByState();
                }
                case 89: {
                    continue block158;
                }
                case 12: {
                    if (this.previousChar() == '\n' && this.calcStringLength(this.yytext()) <= this.currentIndent) {
                        this.yyBegin(0);
                        return INDENT;
                    }
                    return this.commentTypeByState();
                }
                case 90: {
                    continue block158;
                }
                case 13: {
                    String text = this.yytext().toString().replaceAll("\t", "    ");
                    if (text.length() - 1 > this.currentIndent || this.nextChar() == '\n') {
                        return this.commentTypeByState();
                    }
                    this.yyBegin(0);
                    this.yypushback(this.yylength() - 1);
                    return EOL;
                }
                case 91: {
                    continue block158;
                }
                case 14: {
                    return DOCTYPE;
                }
                case 92: {
                    continue block158;
                }
                case 15: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 93: {
                    continue block158;
                }
                case 16: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 94: {
                    continue block158;
                }
                case 17: {
                    this.attrsListOpenBrace = this.yycharat(0);
                    this.yyPushState(36);
                    this.yyBegin(18);
                    return OPEN_BRACE;
                }
                case 95: {
                    continue block158;
                }
                case 18: {
                    this.yyBegin(0);
                    return COLON;
                }
                case 96: {
                    continue block158;
                }
                case 19: {
                    this.yyBegin(10);
                    return ID_START;
                }
                case 97: {
                    continue block158;
                }
                case 20: {
                    this.yyBegin(12);
                    return CLASS_START;
                }
                case 98: {
                    continue block158;
                }
                case 21: {
                    this.yyBegin(8);
                    return ID;
                }
                case 99: {
                    continue block158;
                }
                case 22: {
                    this.yyBegin(8);
                    return CLASS;
                }
                case 100: {
                    continue block158;
                }
                case 23: {
                    this.yyBegin(8);
                    this.yypushback(this.yylength());
                }
                case 101: {
                    continue block158;
                }
                case 24: {
                    return ATTRIBUTE_SHORTCUT_VALUE;
                }
                case 102: {
                    continue block158;
                }
                case 25: {
                    this.yyBegin(20);
                    return EQUALS;
                }
                case 103: {
                    continue block158;
                }
                case 26: {
                    this.yyBegin(22);
                    this.yypushback(this.yylength());
                }
                case 104: {
                    continue block158;
                }
                case 27: {
                    this.yyPopState();
                    this.yypushback(this.yylength());
                }
                case 105: {
                    continue block158;
                }
                case 28: {
                    char prev = this.previousChar();
                    return prev == '\n' || prev == '\uffff' ? INDENT : WHITESPACE;
                }
                case 106: {
                    continue block158;
                }
                case 29: {
                    this.yyPopState();
                    return EOL;
                }
                case 107: {
                    continue block158;
                }
                case 30: {
                    return ATTR_NAME;
                }
                case 108: {
                    continue block158;
                }
                case 31: {
                    this.readRubyTillSpace(new char[0]);
                    char localOpenBrace = this.yycharat(0);
                    char localCloseBrace = '\u0000';
                    if (localOpenBrace == '{') {
                        localCloseBrace = '}';
                    } else if (localOpenBrace == '(') {
                        localCloseBrace = ')';
                    } else if (localOpenBrace == '[') {
                        localCloseBrace = ']';
                    }
                    if (localCloseBrace != '\u0000' && localCloseBrace == this.yycharat(this.yylength() - 1)) {
                        if (this.mySlimLanguageLevel == SlimLanguageLevel.SLIM_1_3) {
                            this.yypushback(this.yylength() - 1);
                            this.yyBegin(34);
                            this.openBrace = localOpenBrace;
                            this.closeBrace = localCloseBrace;
                            return OPEN_BRACE;
                        }
                        this.yyBegin(8);
                        return RUBY_CODE;
                    }
                    this.yyPopState();
                    return RUBY_CODE;
                }
                case 109: {
                    continue block158;
                }
                case 32: {
                    this.yyBegin(42);
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
                }
                case 110: {
                    continue block158;
                }
                case 33: {
                    this.yyBegin(44);
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
                }
                case 111: {
                    continue block158;
                }
                case 34: {
                    this.currentIndent = this.getCurrentIndent();
                    this.yyBegin(30);
                    this.yypushback(this.yylength());
                }
                case 112: {
                    continue block158;
                }
                case 35: {
                    String trimmed = this.yytext().toString().trim();
                    if (!(this.getCurrentIndent() > this.rubyCodeIndent || this.rubyCodeExpected || trimmed.length() != 0 && this.isRubyCodeStartMarker(trimmed.charAt(0)))) {
                        this.yyBegin(0);
                        this.yypushback(this.yylength());
                    } else {
                        this.rubyComment = trimmed.length() > 0 && trimmed.charAt(0) == '#';
                        this.rubyCodeExpected = false;
                        return RUBY_CODE;
                    }
                }
                case 113: {
                    continue block158;
                }
                case 36: {
                    if (!(this.rubyCodeExpected || this.nextIndentSize() >= this.rubyCodeIndent && (this.nextIndentSize() != this.rubyCodeIndent || this.isRubyCodeStartMarker(this.nextNotWhitespaceChar()) && this.rubyInjectionMustBeMerged()))) {
                        this.yyBegin(0);
                        return EOL;
                    }
                    return RUBY_CODE;
                }
                case 114: {
                    continue block158;
                }
                case 37: {
                    this.openBrace = (char)123;
                    this.closeBrace = (char)125;
                    this.readParens(false);
                    this.yyBegin(28);
                    return RUBY_CODE;
                }
                case 115: {
                    continue block158;
                }
                case 38: {
                    this.yyPopState();
                    return STATIC_CONTENT;
                }
                case 116: {
                    continue block158;
                }
                case 39: {
                    this.yypushback(1);
                    this.yyBegin(28);
                }
                case 117: {
                    continue block158;
                }
                case 40: {
                    this.yyPopState();
                    return INTERPOLATION_END;
                }
                case 118: {
                    continue block158;
                }
                case 41: {
                    return STATIC_CONTENT;
                }
                case 119: {
                    continue block158;
                }
                case 42: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 120: {
                    continue block158;
                }
                case 43: {
                    if (this.yystate() == 30 || this.yystate() == 32) {
                        return STATIC_CONTENT;
                    }
                    return STRING_LITERAL;
                }
                case 121: {
                    continue block158;
                }
                case 44: {
                    if (this.previousChar() == '\n' && this.calcStringLength(this.yytext()) <= this.currentIndent) {
                        this.yyBegin(0);
                        return INDENT;
                    }
                    return STATIC_CONTENT;
                }
                case 122: {
                    continue block158;
                }
                case 45: {
                    if (this.yycharat(0) == this.closeBrace) {
                        this.yyBegin(16);
                        if (this.mySlimLanguageLevel == SlimLanguageLevel.SLIM_1_3) {
                            return CLOSE_BRACE;
                        }
                        return RUBY_CODE;
                    }
                    this.readRubyTillSpace(new char[0]);
                    return RUBY_CODE;
                }
                case 123: {
                    continue block158;
                }
                case 46: {
                    return RUBY_CODE;
                }
                case 124: {
                    continue block158;
                }
                case 47: {
                    this.yyBegin(22);
                    this.attrsListOpenBrace = '\u0000';
                    this.yypushback(this.yylength());
                }
                case 125: {
                    continue block158;
                }
                case 48: {
                    this.yyPushState(this.yystate());
                    this.yyBegin(18);
                    this.yypushback(this.yylength());
                }
                case 126: {
                    continue block158;
                }
                case 49: {
                    this.yyBegin(22);
                    this.attrsListOpenBrace = '\u0000';
                    return CLOSE_BRACE;
                }
                case 127: {
                    continue block158;
                }
                case 50: {
                    return this.filterType;
                }
                case 128: {
                    continue block158;
                }
                case 51: {
                    if (this.previousChar() == '\n' && this.calcStringLength(this.yytext()) <= this.currentIndent) {
                        this.yyBegin(0);
                        return INDENT;
                    }
                    return this.filterType;
                }
                case 129: {
                    continue block158;
                }
                case 52: {
                    int indent = this.getIndentAtLoc(this.yytext(), this.yylength());
                    if (indent > this.currentIndent) {
                        return this.filterType;
                    }
                    this.yyBegin(0);
                    this.yypushback(this.yylength() - 1);
                    return EOL;
                }
                case 130: {
                    continue block158;
                }
                case 53: {
                    this.readRubyTillSpace(new char[0]);
                    this.yyBegin(22);
                    return RUBY_CODE;
                }
                case 131: {
                    continue block158;
                }
                case 54: {
                    this.yyPopState();
                    return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
                }
                case 132: {
                    continue block158;
                }
                case 55: {
                    return BAD_CHARACTER;
                }
                case 133: {
                    continue block158;
                }
                case 56: {
                    this.yyBegin(0);
                    return EOL;
                }
                case 134: {
                    continue block158;
                }
                case 57: {
                    this.yypushback(this.yylength());
                    this.yyBegin(8);
                    return PSEUDO_TAG_NAME;
                }
                case 135: {
                    continue block158;
                }
                case 58: {
                    this.yyBegin(8);
                    return TAG;
                }
                case 136: {
                    continue block158;
                }
                case 59: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzMarkedPos, -1);
                    char prev = this.previousChar();
                    return prev == '\n' || prev == '\uffff' ? INDENT : WHITESPACE;
                }
                case 137: {
                    continue block158;
                }
                case 60: {
                    if (this.yycharat(this.yylength() - 1) == '\n') {
                        this.yypushback(1);
                    }
                    this.yyBegin(2);
                    this.currentIndent = this.getCurrentIndent();
                    return CODE_COMMENT;
                }
                case 138: {
                    continue block158;
                }
                case 61: {
                    return CONDITIONAL_COMMENT;
                }
                case 139: {
                    continue block158;
                }
                case 62: {
                    this.yyBegin(4);
                    this.currentIndent = this.getCurrentIndent();
                    return HTML_COMMENT;
                }
                case 140: {
                    continue block158;
                }
                case 63: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yyBegin(40);
                    return SPLAT_SHORTCUT;
                }
                case 141: {
                    continue block158;
                }
                case 64: {
                    this.currentIndent = this.getCurrentIndent();
                    this.rubyCodeIndent = this.getCurrentIndent();
                    this.rubyCodeExpected = true;
                    this.yyBegin(24);
                    return RUBY_CODE;
                }
                case 142: {
                    continue block158;
                }
                case 65: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzMarkedPos, -1);
                    this.yyBegin(14);
                    return ATTRIBUTE_SHORTCUT;
                }
                case 143: {
                    continue block158;
                }
                case 66: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yyPushState(this.yystate());
                    this.yyBegin(20);
                    return EQUALS;
                }
                case 144: {
                    continue block158;
                }
                case 67: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzMarkedPos, -1);
                    this.yyBegin(30);
                    this.currentIndent = this.getCurrentIndent();
                    return STATIC_CONTENT;
                }
                case 145: {
                    continue block158;
                }
                case 68: {
                    this.rubyCodeExpected = true;
                    return RUBY_CODE;
                }
                case 146: {
                    continue block158;
                }
                case 69: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    return RUBY_CODE;
                }
                case 147: {
                    continue block158;
                }
                case 70: {
                    this.yyPopState();
                    if (this.isInEscapedInterpolation) {
                        this.yypushback(1);
                        return INTERPOLATION_END;
                    }
                    return UNESCAPED_INTERPOLATION_END;
                }
                case 148: {
                    continue block158;
                }
                case 71: {
                    if (this.calcStringLength(this.yytext()) - 1 > this.currentIndent) {
                        this.yypushback(this.yylength() - 1);
                        this.yyBegin(32);
                        return STATIC_CONTENT;
                    }
                    this.yypushback(this.yylength() - 1);
                    this.yyBegin(0);
                    return EOL;
                }
                case 149: {
                    continue block158;
                }
                case 72: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yyBegin(32);
                    return STATIC_CONTENT;
                }
                case 150: {
                    continue block158;
                }
                case 73: {
                    this.yyPushState(this.yystate());
                    this.isInEscapedInterpolation = true;
                    this.yyBegin(26);
                    return INTERPOLATION_START;
                }
                case 151: {
                    continue block158;
                }
                case 74: {
                    this.yypushback(this.yylength() - 1);
                    return DYNAMIC_TAG_SYMBOL;
                }
                case 152: {
                    continue block158;
                }
                case 75: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 1);
                    this.yyBegin(14);
                    return ATTRIBUTE_SHORTCUT;
                }
                case 153: {
                    continue block158;
                }
                case 76: {
                    this.yyPushState(this.yystate());
                    this.isInEscapedInterpolation = false;
                    this.yyBegin(26);
                    return UNESCAPED_INTERPOLATION_START;
                }
                case 154: {
                    continue block158;
                }
                case 77: {
                    this.filterType = this.getFilterType(this.yytext().toString());
                    this.yyBegin(38);
                    this.currentIndent = this.getCurrentIndent();
                    return FILTER;
                }
                case 155: {
                    continue block158;
                }
                case 78: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 7);
                    this.yyBegin(6);
                    return DOCTYPE_KWD;
                }
                case 156: {
                    continue block158;
                }
            }
            this.zzScanError(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slimLanguageLevel", "org/jetbrains/plugins/slim/lexer/_SlimLexer", "setSlimLanguageLevel"));
    }
}

