/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.adapters;

import com.intellij.execution.filters.Filter;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.adapters.PuppetAbstractLibrarianAdapter;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemsRunner;
import org.jetbrains.plugins.ruby.gem.MissingGemNotificationWithFix;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;

public class PuppetLibrarianGemAdapter
extends PuppetAbstractLibrarianAdapter {
    private static final Logger LOG = Logger.getInstance(PuppetLibrarianGemAdapter.class);

    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            PuppetLibrarianGemAdapter.$$$reportNull$$$0(0);
        }
        return logger;
    }

    protected void installDependencies(@NotNull PuppetEntity puppetEntity, @NotNull ProgressIndicator indicator) {
        if (puppetEntity == null) {
            PuppetLibrarianGemAdapter.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            PuppetLibrarianGemAdapter.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Project project;
            if (puppetEntity == null) {
                PuppetLibrarianGemAdapter.$$$reportNull$$$0(3);
            }
            if ((project = puppetEntity.getProject()).isDisposed()) {
                return;
            }
            VirtualFile entityRoot = puppetEntity.getRoot();
            if (!entityRoot.isValid()) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)entityRoot, (Project)project);
            if (module == null) {
                return;
            }
            Sdk rubySdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            MissingGemNotificationWithFix.checkGemExecPresenceOrInstall((Module)module, (Sdk)rubySdk, (String)"librarian-puppet", success -> {
                if (puppetEntity == null) {
                    PuppetLibrarianGemAdapter.$$$reportNull$$$0(4);
                }
                if (!success) {
                    return;
                }
                boolean shouldExcludeLibrarianDir = PuppetLibrarianGemAdapter.getLibrarianInternalDir((VirtualFile)entityRoot) == null;
                HashMap env = new HashMap();
                this.configureEnvironment(env);
                MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(ArrayUtil.toStringArray((Collection)this.createLibrarianArguments(puppetEntity)), null, null, env, rubySdk);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (puppetEntity == null) {
                        PuppetLibrarianGemAdapter.$$$reportNull$$$0(5);
                    }
                    if (!project.isDisposed() && entityRoot.isValid()) {
                        GemsRunner.runGemScriptInConsoleAndRefreshModule((Module)module, (Sdk)rubySdk, (String)PuppetBundle.message((String)"puppet.installing.dependencies", (Object[])new Object[]{puppetEntity.getDescriptiveName(), puppetEntity.getName()}), null, (ConsoleRunner.ProcessLaunchMode)ConsoleRunner.ProcessLaunchMode.BACKGROUND_TASK_WITH_PROGRESS, (String)"librarian-puppet", null, (String)"librarian-puppet", (String)entityRoot.getCanonicalPath(), (RubyCommandLineArgumentsProvider)provider, (RunContentDescriptorFactory)new RunContentDescriptorFactory.PinTabsFactory(), (Filter[])new Filter[]{new RStackTraceFilter(module, entityRoot.getCanonicalPath())}, () -> {
                            if (puppetEntity == null) {
                                PuppetLibrarianGemAdapter.$$$reportNull$$$0(6);
                            }
                            ApplicationManager.getApplication().runReadAction(() -> {
                                if (puppetEntity == null) {
                                    PuppetLibrarianGemAdapter.$$$reportNull$$$0(7);
                                }
                                this.doPostInstallationWork(puppetEntity, () -> {
                                    VirtualFile librarianInternalDir;
                                    if (shouldExcludeLibrarianDir && (librarianInternalDir = PuppetLibrarianGemAdapter.getLibrarianInternalDir((VirtualFile)entityRoot)) != null) {
                                        PuppetLibrarianGemAdapter.excludeVirtualFile((Project)project, (VirtualFile)librarianInternalDir);
                                    }
                                });
                            });
                        }, (boolean)false);
                    }
                });
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/adapters/PuppetLibrarianGemAdapter";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "puppetEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/adapters/PuppetLibrarianGemAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installDependencies$5";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

