/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets;

import b.h.la;
import com.google.common.base.Splitter;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsComment;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsConstants;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;

public class SprocketsUtil {
    private static final Set<String> a;
    private static final long b;

    private SprocketsUtil() {
    }

    public static boolean areAssetsEnabled(@NotNull RailsApp app) {
        if (app == null) {
            SprocketsUtil.a(0);
        }
        return SprocketsUtil.railsWithAssetsSupport(app.getModule());
    }

    @Nullable
    public static String getAssetType(@Nullable String directive, @NotNull PsiElement element) {
        long l2 = b ^ 0x1AA839F5E4CCL;
        if (element == null) {
            SprocketsUtil.a(1);
        }
        if ("depend_on".equals(directive) || "depend_on_asset".equals(directive)) {
            return "javascripts";
        }
        if (SprocketsUtil.isStylesheet(element)) {
            return "stylesheets";
        }
        if (SprocketsUtil.isJavascript(element)) {
            return "javascripts";
        }
        return null;
    }

    public static boolean isStylesheet(@NotNull PsiElement element) {
        Language language;
        String string;
        long l2 = b ^ 0x5F76EE1A664CL;
        if (element == null) {
            SprocketsUtil.a(2);
        }
        return (string = (language = element.getLanguage()).getDisplayName()).equalsIgnoreCase("css") || string.equalsIgnoreCase("scss") || string.equalsIgnoreCase("sass") || string.equalsIgnoreCase("less");
    }

    public static boolean isJavascript(@NotNull PsiElement element) {
        Language language;
        String string;
        long l2 = b ^ 0x9549F4B9862L;
        if (element == null) {
            SprocketsUtil.a(3);
        }
        return (string = (language = element.getLanguage()).getDisplayName()).equalsIgnoreCase("javascript") || string.equalsIgnoreCase("coffeescript");
    }

    public static boolean railsWithAssetsSupport(@Nullable Module module) {
        return RailsUtil.isRails31OrHigher(module);
    }

    public static boolean isStdAssetsRoot(@Nullable Set<VirtualFile> assetsRoots, @NotNull VirtualFile parentFileOrDir, @NotNull VirtualFile childFileOrDir) {
        long l2 = b ^ 0x58B32E58E7C8L;
        if (parentFileOrDir == null) {
            SprocketsUtil.a(4);
        }
        if (childFileOrDir == null) {
            SprocketsUtil.a(5);
        }
        return assetsRoots != null && (childFileOrDir.isDirectory() && "assets".equals(childFileOrDir.getName()) && Comparing.equal((Object)parentFileOrDir, (Object)childFileOrDir.getParent()) || assetsRoots.contains(childFileOrDir));
    }

    public static boolean isSprocketsSupportedFile(@NotNull PsiFile file) {
        if (file == null) {
            SprocketsUtil.a(6);
        }
        List<String> list2 = ViewsConventions.getViewExtensions(file.getName());
        for (String string : list2) {
            if (!a.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static void processSprocketComments(@NotNull PsiComment comment, @NotNull Processor<? super SprocketsComment> processor) {
        if (comment == null) {
            SprocketsUtil.a(7);
        }
        if (processor == null) {
            SprocketsUtil.a(8);
        }
        int n2 = 0;
        for (String string : Splitter.on((char)'\n').split((CharSequence)comment.getText())) {
            Matcher matcher;
            if (!string.isEmpty() && (matcher = SprocketsConstants.SPROCKET_COMMENT.matcher(string)).matches()) {
                processor.process((Object)SprocketsComment.fromMatcher(comment, n2, matcher));
            }
            n2 += string.length() + 1;
        }
    }

    static {
        b = la.a(8707228442486449426L, 3113091418388946904L, MethodHandles.lookup().lookupClass()).a(29939201305L);
        long l2 = b ^ 0x7DA5C70F96F0L;
        a = ContainerUtil.immutableSet((Object[])new String[]{"css", "sass", "scss", "less", "js", "coffee"});
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x6ACA4AC5CE58L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFileOrDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childFileOrDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/SprocketsUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areAssetsEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStylesheet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavascript";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isStdAssetsRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSprocketsSupportedFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processSprocketComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

