/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv;

import b.h.la;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherBase;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.a;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

final class RbenvSdkRefresher
extends SdkRefresherBase {
    private static final Logger h;
    private static final String g = ".rbenv-version";
    private static final String j = ".ruby-version";
    private static final CharsetDecoder k;
    @NotNull
    private final Map<Project, VirtualFileListener> i = Maps.newConcurrentMap();
    @NotNull
    private final Map<Module, VirtualFileListener> f = Maps.newConcurrentMap();
    private static final long l;

    RbenvSdkRefresher() {
    }

    @Override
    protected void doAdditionalApplicationInit() {
        this.getInstallationsRoots().stream().flatMap(virtualFile -> Stream.of(virtualFile.getChildren())).filter(virtualFile -> virtualFile.isDirectory()).forEach(virtualFile -> this.d((VirtualFile)virtualFile));
    }

    @Override
    @NotNull
    public RbenvVersionManagerHandler getVersionManagerHandler() {
        RbenvVersionManagerHandler rbenvVersionManagerHandler = RbenvVersionManagerHandler.getInstance();
        if (rbenvVersionManagerHandler == null) {
            RbenvSdkRefresher.d(0);
        }
        return rbenvVersionManagerHandler;
    }

    private void d(@NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        long l2 = l ^ 0x62C88AB03176L;
        if (virtualFile == null) {
            RbenvSdkRefresher.d(1);
        }
        if ((virtualFile2 = virtualFile.findChild("gemsets")) == null || !virtualFile2.isDirectory()) {
            h.debug("No gemset directory for " + virtualFile);
            return;
        }
        this.addRootToWatch(virtualFile2);
    }

    @Override
    @NotNull
    protected List<String> getPossibleVersionManagersPaths() {
        List<String> list2 = RbenvVersionManagerHandler.POSSIBLE_RBENV_PATHS;
        if (list2 == null) {
            RbenvSdkRefresher.d(2);
        }
        return list2;
    }

    @Override
    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        long l2 = l ^ 0x535EFC804F04L;
        if (versionManagerPathName == null) {
            RbenvSdkRefresher.d(3);
        }
        if (interpreterHome == null) {
            RbenvSdkRefresher.d(4);
        }
        h.debug("Processing potential home " + interpreterHome);
        Stream stream2 = Stream.of(new RubySdkInfo(versionManagerPathName, interpreterHome, null));
        VirtualFile virtualFile3 = interpreterHome.findChild("gemsets");
        if (virtualFile3 != null) {
            this.myLog.debug("Got a gemset directory: " + virtualFile3);
            stream2 = Streams.concat((Stream[])new Stream[]{stream2, Stream.of(virtualFile3).filter(virtualFile -> virtualFile.isDirectory() && !FileTypeManager.getInstance().isFileIgnored(virtualFile)).map(virtualFile2 -> {
                long l2 = l ^ 0x7C5CBEAA556L;
                if (versionManagerPathName == null) {
                    RbenvSdkRefresher.d(21);
                }
                if (interpreterHome == null) {
                    RbenvSdkRefresher.d(22);
                }
                this.myLog.debug("Found gemset: " + virtualFile2);
                return new RubySdkInfo(versionManagerPathName, interpreterHome, virtualFile2.getName());
            })});
        }
        Stream stream3 = stream2;
        if (stream3 == null) {
            RbenvSdkRefresher.d(5);
        }
        return stream3;
    }

    @Override
    protected void runPostCreateSdkAction(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RbenvSdkRefresher.d(6);
        }
        if (!RbenvGemsetManager.isGemsetSdk(sdkInfo)) {
            LocalFileSystem.getInstance().addRootToWatch(sdkInfo.getInterpreterHome().getPath(), false);
        }
        this.d(sdkInfo.getInterpreterHome());
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String sdkHomePath, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        String string;
        long l2 = l ^ 0x65A1FBD32D6EL;
        if (executablePath == null) {
            RbenvSdkRefresher.d(7);
        }
        if (sdkHomePath == null) {
            RbenvSdkRefresher.d(8);
        }
        if (versionManagerSdkAdditionalData == null) {
            RbenvSdkRefresher.d(9);
        }
        if ((string = super.suggestSdkName(executablePath, sdkHomePath, versionManagerSdkAdditionalData)) == null) {
            return null;
        }
        String string2 = ((RbenvSdkData)versionManagerSdkAdditionalData).getGemsetName();
        if (string2 != null && !StringUtil.isEmpty((String)string2)) {
            return string + " [" + string2 + ']';
        }
        return string;
    }

    @Override
    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            RbenvSdkRefresher.d(10);
        }
        LocalVersionWatcher localVersionWatcher = new LocalVersionWatcher(project, null);
        this.i.put(project, localVersionWatcher);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)localVersionWatcher);
        this.b(project);
        StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> {
            if (project == null) {
                RbenvSdkRefresher.d(20);
            }
            for (Module module : RModuleUtil.getInstance().getAllModulesWithRubySupport(project)) {
                RbenvGemsetManager.excludeLocalGemsets(module);
                RbenvGemsetsConfigFileListener rbenvGemsetsConfigFileListener = new RbenvGemsetsConfigFileListener(module);
                this.f.put(module, rbenvGemsetsConfigFileListener);
                VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)rbenvGemsetsConfigFileListener);
            }
        });
    }

    @Override
    public void onProjectClosed(@NotNull Project project) {
        if (project == null) {
            RbenvSdkRefresher.d(11);
        }
        VirtualFileListener virtualFileListener = this.i.remove(project);
        assert (virtualFileListener != null);
        VirtualFileManager.getInstance().removeVirtualFileListener(virtualFileListener);
        for (Module module : RModuleUtil.getInstance().getAllModulesWithRubySupport(project)) {
            VirtualFileListener virtualFileListener2 = this.f.remove(module);
            if (virtualFileListener2 == null) continue;
            VirtualFileManager.getInstance().removeVirtualFileListener(virtualFileListener2);
        }
        RbenvGemsetManager.RBENV_PLUGIN_INSTALLED.drop();
    }

    private void b(@NotNull Project project) {
        long l2 = l ^ 0x4085874CC1B4L;
        if (project == null) {
            RbenvSdkRefresher.d(12);
        }
        if (this.getInstallationsRoots().isEmpty()) {
            return;
        }
        Module[] moduleArray = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        if (moduleArray.length == 0) {
            return;
        }
        Set<? extends RubySdkInfo> set = this.getSdkInfos();
        if (set.isEmpty()) {
            return;
        }
        for (Module module : moduleArray) {
            if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(RModuleUtil.getInstance().findRubySdkForModule(module))) {
                h.debug(module.getName() + " configured to use remote sdk thus let's ignore rbenv config");
                continue;
            }
            VirtualFile virtualFile = RbenvSdkRefresher.a(module);
            if (virtualFile == null) continue;
            h.debug("Local rbenv version config found " + virtualFile + " for " + module.getName());
            String string = RbenvSdkRefresher.h(virtualFile);
            if (StringUtil.isEmpty((String)string)) {
                h.debug("no version specified");
                continue;
            }
            VirtualFile virtualFile2 = RbenvSdkRefresher.a(set, string);
            if (virtualFile2 == null) {
                h.warn("Unable to find rbenv sdk for >" + string + "<");
                continue;
            }
            Sdk sdk = RbenvSdkRefresher.a(virtualFile2);
            if (sdk != null) {
                if (RModuleUtil.getInstance().changeModuleSdk(sdk, module)) {
                    h.debug("Sdk for " + module.getName() + " changed to " + sdk.getName());
                    GemManager.addGemsForSdk(sdk);
                    continue;
                }
                h.warn("Unable to change sdk for " + module.getName());
                continue;
            }
            h.warn("unable to find sdk for " + virtualFile2);
        }
    }

    @Nullable
    private static VirtualFile a(@NotNull Collection<? extends RubySdkInfo> collection, @NotNull String string) {
        if (collection == null) {
            RbenvSdkRefresher.d(13);
        }
        if (string == null) {
            RbenvSdkRefresher.d(14);
        }
        for (RubySdkInfo rubySdkInfo : collection) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = rubySdkInfo.getInterpreterHome();
            if (!virtualFile2.getPath().endsWith(string) || (virtualFile = rubySdkInfo.getRubyExecutable()) == null) continue;
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private static Sdk a(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RbenvSdkRefresher.d(15);
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            VirtualFile virtualFile2 = sdk.getHomeDirectory();
            if (virtualFile2 == null || !virtualFile2.equals(virtualFile) || !RbenvGemsetManager.isRootRbenvSdk(sdk)) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    private static VirtualFile a(@NotNull Module module) {
        long l2 = l ^ 0x20DD1CF514E0L;
        if (module == null) {
            RbenvSdkRefresher.d(16);
        }
        for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (virtualFile == null) continue;
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(j);
            if (virtualFile2 != null) {
                return virtualFile2;
            }
            VirtualFile virtualFile3 = virtualFile.findFileByRelativePath(g);
            if (virtualFile3 == null) continue;
            return virtualFile3;
        }
        return null;
    }

    @Nullable
    private static String h(@NotNull VirtualFile virtualFile) {
        long l2 = l ^ 0x4CBBF4E73549L;
        if (virtualFile == null) {
            RbenvSdkRefresher.d(17);
        }
        try {
            byte[] byArray = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            StringBuilder stringBuilder = new StringBuilder((int)virtualFile.getLength());
            InputStream inputStream = virtualFile.getInputStream();
            while (inputStream.available() > 0) {
                int n2 = inputStream.read(byArray);
                byteBuffer.clear();
                byteBuffer.put(byArray, 0, n2);
                byteBuffer.flip();
                stringBuilder.append(k.decode(byteBuffer));
            }
            inputStream.close();
            return stringBuilder.toString().trim();
        }
        catch (IOException iOException) {
            h.warn("Unable to read version file - " + virtualFile, (Throwable)iOException);
            return null;
        }
    }

    @Override
    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        long l2 = l ^ 0x67AEFB697172L;
        this.myLog.debug("Seeking for installation root");
        String string = RbenvVersionManagerHandler.computeRootFor(this.getVersionManagerPath(), RubyLocalRunner.getRunner(null));
        if (string == null) {
            this.myLog.debug("Could not find rbenv root");
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RbenvSdkRefresher.d(18);
            }
            return list2;
        }
        this.myLog.debug("Found root at " + string);
        List<String> list3 = Collections.singletonList(Paths.get(string, new String[0]).resolve("versions").toString());
        if (list3 == null) {
            RbenvSdkRefresher.d(19);
        }
        return list3;
    }

    static {
        l = la.a(150209789266920538L, 8241129055560004294L, MethodHandles.lookup().lookupClass()).a(186738859990499L);
        long l2 = l ^ 0x72A5B14D4823L;
        h = Logger.getInstance(RbenvSdkRefresher.class);
        k = Charset.forName(System.getProperty("file.encoding")).newDecoder();
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x51A1BDAA9271L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyHome";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfos";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyExecutable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerHandler";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleVersionManagersPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addGemsetsToWatchRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runPostCreateSdkAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onProjectClosed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyLocalVersionToProject";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRubyExecutable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableSdk";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvLocal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocalVersion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onProjectOpened$5";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSdkInfosForInterpreterHome$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RbenvGemsetsConfigFileListener
    implements VirtualFileListener {
        private final Module a;
        private static final long b = la.a(-1047089880040680975L, -3744078764841490933L, MethodHandles.lookup().lookupClass()).a(93395465873668L);

        RbenvGemsetsConfigFileListener(@NotNull Module module) {
            if (module == null) {
                RbenvGemsetsConfigFileListener.a(0);
            }
            this.a = module;
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                RbenvGemsetsConfigFileListener.a(1);
            }
            this.a(event);
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                RbenvGemsetsConfigFileListener.a(2);
            }
            this.a(event);
        }

        private void a(@NotNull VirtualFileEvent virtualFileEvent) {
            if (virtualFileEvent == null) {
                RbenvGemsetsConfigFileListener.a(3);
            }
            if (virtualFileEvent.getRequestor() == RbenvGemsetManager.RBENV_GEMSETS_CONFIG_REQUESTOR) {
                return;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.a);
            if (sdk == null) {
                return;
            }
            if (RbenvGemsetManager.isRbenvGemsetConfig(this.a, virtualFileEvent.getFile())) {
                List<String> list2 = RbenvGemsetManager.getCommandLineRbenvGemsets(this.a, sdk);
                MultiMap<String, String> multiMap = RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.a);
                multiMap.put((Object)sdk.getHomePath(), list2);
                RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.a, multiMap);
                RbenvGemsetManager.updateLibraries(sdk, this.a);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x74955ACF1674L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher$RbenvGemsetsConfigFileListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyGemsetConfigChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class LocalVersionWatcher
    implements VirtualFileListener {
        @NotNull
        final Project myProject;
        private static final long a = la.a(3455733805661420678L, -8084517110728803764L, MethodHandles.lookup().lookupClass()).a(100812825811783L);

        private LocalVersionWatcher(Project project) {
            if (project == null) {
                LocalVersionWatcher.a(0);
            }
            this.myProject = project;
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LocalVersionWatcher.a(1);
            }
            this.a(event.getFile());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LocalVersionWatcher.a(2);
            }
            this.a(event.getFile());
        }

        private void a(@NotNull VirtualFile virtualFile) {
            long l2 = a ^ 0x2FAAC1A4869CL;
            if (virtualFile == null) {
                LocalVersionWatcher.a(3);
            }
            if (virtualFile.isDirectory()) {
                return;
            }
            if (!RbenvSdkRefresher.g.equals(virtualFile.getName()) && !RbenvSdkRefresher.j.equals(virtualFile.getName())) {
                return;
            }
            h.debug("It looks like " + virtualFile.getName() + " (" + virtualFile.getPath() + ") has been changed (or created), let's update sdk for the project (" + this.myProject + ")");
            RbenvSdkRefresher.this.b(this.myProject);
        }

        /* synthetic */ LocalVersionWatcher(Project x1, a x2) {
            this(x1);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x42886A53CB05L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher$LocalVersionWatcher";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSelectedSdkIfNeeded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

