/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;
import org.jetbrains.plugins.ruby.cucumber.ruby.CucumberParameterTypeCallType;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberCallType;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberParameterTypeIndex;
import org.jetbrains.plugins.ruby.cucumber.settings.CucumberRubySettings;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

public class CucumberUtil {
    @NonNls
    public static final String CUCUMBER_RAILS_SCRIPT_NAME = "cucumber";
    @NonNls
    public static final String CUCUMBER_GEM_NAME = "cucumber";
    @NonNls
    public static final String CUCUMBER_RAILS_GEM_NAME = "cucumber-rails";
    @NonNls
    public static final String[] CUCUMBER_GEM_NAMES = new String[]{"cucumber"};
    @NonNls
    public static final String[] CUCUMBER_RAILS_GEM_NAMES = new String[]{"cucumber-rails"};
    @NonNls
    public static final String[] CUCUMBER_RAILS_PLUGIN_NAMES = new String[]{"cucumber-rails"};
    @NonNls
    public static final String CUCUMBER_GEM_EXECUTABLE = "cucumber";
    @NonNls
    public static final String CUCUMBER_OPTS_ENV_KEY = "CUCUMBER_OPTS";
    @NonNls
    public static final String INIT_GENERATOR_NAME = "cucumber";
    @NonNls
    public static final String INIT_GENERATOR_RAILS_3_NAME = "cucumber:install";
    @NonNls
    public static final String STEP_DEFINITIONS_DIR_NAME = "step_definitions";
    private static final String[] CUCUMBER_PLUGIN_NAMES = new String[]{"cucumber"};
    public static final String GENERATOR_SPORK_OPTION = "--spork";
    public static final String GENERATOR_RSPEC_OPTION = "--rspec";
    public static final String GENERATOR_CAPYBARA_OPTION = "--capybara";
    public static final String GENERATOR_WEBRAT_OPTION = "--webrat";
    public static final String GENERATOR_TESTUNIT_OPTION = "--testunit";
    public static final String CUCUMBER_COLOR_MODE_OPTION = "--color";
    public static final List<String> CUCUMBER_STEP_PREFIXES = Arrays.asList("And", "Then", "When", "Given", "But", "step");
    public static final String CUCUMBER_EXPRESSION_START_VERSION = "3.0.0.pre.2";
    private static final Pattern PARAMETER_TYPE_PATTERN = Pattern.compile(".*\\{([^}]+)}.*");

    private CucumberUtil() {
    }

    public static boolean isCucumberScriptSupportInstalledInRailsProject(@NotNull Module module) {
        String appHomeDirPathUrl;
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(0);
        }
        return (appHomeDirPathUrl = RailsFacetUtil.getRailsAppHomeDirPathUrl((Module)module)) == null || CucumberUtil.getRailsCucumberScriptExecutablePath(module) != null;
    }

    @Nullable
    private static String getRailsCucumberScriptExecutablePath(@NotNull Module module) {
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(1);
        }
        return RailsUtil.getRailsScriptExecutablePath((Module)module, (String)"cucumber");
    }

    public static boolean isStepDefinitionLikeFile(@Nullable VirtualFile file) {
        if (file != null && RubyVirtualFileScanner.isRubyFile((VirtualFile)file)) {
            return CucumberUtil.isFileUnderStepDefinitionsRoot(file);
        }
        return false;
    }

    public static boolean isFileUnderStepDefinitionsRoot(@NotNull VirtualFile file) {
        if (file == null) {
            CucumberUtil.$$$reportNull$$$0(2);
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            if (!STEP_DEFINITIONS_DIR_NAME.equals(parent.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCucumberRailsSupportProbablyEnabled(@NotNull Module module, @NotNull Sdk sdk) {
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            CucumberUtil.$$$reportNull$$$0(4);
        }
        if (!RailsFacetUtil.hasRailsSupport((Module)module)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportProbablyEnabled((Module)module, (Sdk)sdk, (String[])CUCUMBER_RAILS_GEM_NAMES, (String[])CUCUMBER_RAILS_PLUGIN_NAMES);
    }

    public static boolean isCucumberSupportEnabled(@NotNull Module module) {
        GemInfo gemInfo;
        boolean supportEnabled;
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(5);
        }
        if ((supportEnabled = GemUtil.isGemOrRailsPluginSupportEnabled((Module)module, (String[])CUCUMBER_GEM_NAMES, (String[])CUCUMBER_PLUGIN_NAMES)) && (gemInfo = CucumberUtil.getAttachedCucumberGem(module)) != null) {
            return CucumberUtil.checkIfVersionIsSupported(gemInfo.getVersion());
        }
        return supportEnabled;
    }

    @Nullable
    public static GemInfo getAttachedCucumberGem(@NotNull Module module) {
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(6);
        }
        return GemSearchUtil.findGemEx((Module)module, (String)"cucumber");
    }

    @Nullable
    public static GemInfo findLatestCucumberGemIn(@Nullable Module module, @Nullable Sdk sdk) {
        return sdk == null ? null : GemSearchUtil.findGem((Module)module, (Sdk)sdk, (String)"cucumber");
    }

    public static boolean checkIfVersionIsSupported(String cucmberGemVersion) {
        return VersionComparatorUtil.compare((String)cucmberGemVersion, (String)CucumberUtil.getMinimalSupportedVersion()) >= 0;
    }

    public static String getMinimalSupportedVersion() {
        return "0.3.7";
    }

    @Nullable
    public static String determinePreferredCucumberExecutablePath(@Nullable Module module, @Nullable Sdk alternativeSdk) {
        Sdk sdk;
        String cucumberCreatedByGenerator;
        if (module != null && RailsFacetUtil.hasRailsSupport((Module)module) && (cucumberCreatedByGenerator = CucumberUtil.getRailsCucumberScriptExecutablePath(module)) != null) {
            return cucumberCreatedByGenerator;
        }
        Object object = alternativeSdk == null ? (module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null) : (sdk = alternativeSdk);
        if (sdk != null) {
            return CucumberUtil.getCucumberGemExecutablePath(module, sdk);
        }
        return null;
    }

    @Nullable
    private static String getCucumberGemExecutablePath(@Nullable Module module, @NotNull Sdk sdk) {
        if (sdk == null) {
            CucumberUtil.$$$reportNull$$$0(7);
        }
        return RubyGemExecutionContext.getScriptPath((Sdk)sdk, (Module)module, (String)"cucumber", (String)"cucumber");
    }

    public static String getArguments(boolean useRSpec, boolean useSpork, boolean capybaraBackend) {
        StringBuilder buf = new StringBuilder();
        buf.append(useRSpec ? GENERATOR_RSPEC_OPTION : GENERATOR_TESTUNIT_OPTION);
        if (useSpork) {
            buf.append(' ').append(GENERATOR_SPORK_OPTION);
        }
        buf.append(' ').append(capybaraBackend ? GENERATOR_CAPYBARA_OPTION : GENERATOR_WEBRAT_OPTION);
        return buf.toString();
    }

    @Nullable
    public static String determineCurrentScenarioName(@NotNull PsiElement element) {
        GherkinStepsHolder parentScenario;
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(8);
        }
        if ((parentScenario = (GherkinStepsHolder)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GherkinStepsHolder.class})) == null) {
            return null;
        }
        return parentScenario instanceof GherkinScenario && ((GherkinScenario)parentScenario).isBackground() ? null : parentScenario.getScenarioName();
    }

    public static boolean isParameterTypeDeclaration(@Nullable PsiElement element) {
        if (!(element instanceof RCall)) {
            return false;
        }
        RCall call = (RCall)element;
        return call.getCallType() instanceof CucumberParameterTypeCallType;
    }

    public static boolean isCucumberStepDefinition(@Nullable PsiElement element) {
        if (element instanceof RDoBlockCall) {
            element = ((RDoBlockCall)element).getCall();
        }
        if (element instanceof RCall) {
            RCall call = (RCall)element;
            return call.getCallType() instanceof RubyCucumberCallType;
        }
        return false;
    }

    @Nullable
    public static String getStepNameFromStepCall(@NotNull PsiElement element) {
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(9);
        }
        if (element instanceof RBaseString) {
            return ((RBaseString)element).getContent();
        }
        if (element instanceof RRegexpLiteral) {
            return ((RRegexpLiteral)element).getContent();
        }
        return null;
    }

    @Nullable
    public static String getCucumberStepDefinitionName(@Nullable PsiElement element) {
        RCall call = CucumberUtil.getStepCall(element);
        if (element != null && call != null) {
            if (call.getParent() instanceof RDoBlockCall) {
                return CucumberUtil.getDescriptiveName(element.getParent());
            }
            PsiElement parameter = (PsiElement)call.getArguments().get(0);
            return CucumberUtil.getStepNameFromStepCall(parameter);
        }
        return null;
    }

    @NotNull
    private static String getDescriptiveName(@NotNull PsiElement element) {
        ItemPresentation presentation;
        String res;
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(10);
        }
        if ((res = DescriptiveNameUtil.getDescriptiveName((PsiElement)element)).isEmpty() && element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            String string = StringUtil.notNullize((String)presentation.getPresentableText(), (String)"");
            if (string == null) {
                CucumberUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = res;
        if (string == null) {
            CucumberUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static RCall getStepCall(@Nullable PsiElement element) {
        RCall call;
        if (element instanceof RDoBlockCall) {
            element = ((RDoBlockCall)element).getCall();
        }
        RCall rCall = call = element instanceof RCall ? (RCall)element : (RCall)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RCall.class);
        if (call != null && call.getCallType() instanceof RubyCucumberCallType) {
            return call;
        }
        return null;
    }

    @Nullable
    public static RCall getStepInvocation(PsiElement element) {
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class);
        if (call != null && call.getArguments().size() >= 1 && CUCUMBER_STEP_PREFIXES.contains(call.getCommand())) {
            return call;
        }
        return null;
    }

    public static List<AbstractStepDefinition> getSameStepDefinitionList(@NotNull PsiElement stepDefinition) {
        PsiElement patternElement;
        RCall call;
        Module module;
        if (stepDefinition == null) {
            CucumberUtil.$$$reportNull$$$0(13);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)stepDefinition)) != null && (call = CucumberUtil.getStepCall(stepDefinition)) != null && call.getArguments().size() == 1 && (patternElement = (PsiElement)call.getArguments().get(0)) instanceof RRegexpLiteral) {
            RRegexpLiteral regexp = (RRegexpLiteral)patternElement;
            return CucumberStepsIndex.getInstance((Project)call.getProject()).findStepDefinitionsByPattern(regexp.getContent(), module);
        }
        return new ArrayList<AbstractStepDefinition>();
    }

    public static boolean isCucumberExpressionEnabled(@NotNull PsiElement context) {
        Module module;
        if (context == null) {
            CucumberUtil.$$$reportNull$$$0(14);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            return true;
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GemInfo gem = GemSearchUtil.findGem((Module)module, (String)"cucumber");
            boolean result = gem == null || VersionComparatorUtil.compare((String)gem.getVersion(), (String)CUCUMBER_EXPRESSION_START_VERSION) >= 0;
            return new CachedValueProvider.Result((Object)result, new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
        });
    }

    public static String processRegexpSymbols(String stepPattern) {
        return stepPattern.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$").replaceAll("\\^", "\\\\^").replaceAll("\\*", "\\\\*").replaceAll("\\.", "\\\\.");
    }

    public static String processCucumberExpressions(@NotNull String stepPattern, @NotNull Project project) {
        boolean cucumberExpressionFound;
        if (stepPattern == null) {
            CucumberUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            CucumberUtil.$$$reportNull$$$0(16);
        }
        stepPattern = CucumberUtil.processStandardCucumberExpressions(stepPattern);
        StringBuilder result = new StringBuilder(stepPattern);
        do {
            cucumberExpressionFound = false;
            Matcher matcher = PARAMETER_TYPE_PATTERN.matcher(result);
            if (!matcher.matches()) continue;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            for (int i = matcher.groupCount(); i > 0; --i) {
                CucumberParameterTypeCallType parameterTypeCallType;
                String parameterValue;
                String parameterName = matcher.group(i);
                RCall parameterTypeCall = RubyCucumberParameterTypeIndex.findParamType(project, globalSearchScope, parameterName);
                if (parameterTypeCall == null || !(parameterTypeCall.getCallType() instanceof CucumberParameterTypeCallType) || (parameterValue = (parameterTypeCallType = (CucumberParameterTypeCallType)parameterTypeCall.getCallType()).getCallData((RPossibleCall)parameterTypeCall).getRegexp()) == null) continue;
                cucumberExpressionFound = true;
                int start = matcher.start(i);
                int end = matcher.end(i);
                result.replace(start - 1, end + 1, parameterValue);
            }
        } while (cucumberExpressionFound);
        return result.toString();
    }

    private static String processStandardCucumberExpressions(String stepPattern) {
        for (Map.Entry entry : org.jetbrains.plugins.cucumber.CucumberUtil.STANDARD_PARAMETER_TYPES.entrySet()) {
            stepPattern = stepPattern.replaceAll("\\{" + (String)entry.getKey() + "}", "(" + ((String)entry.getValue()).replaceAll("\\\\", "\\\\\\\\") + ")");
        }
        return stepPattern;
    }

    private static String getGemName(VirtualFile file) {
        VirtualFile parent = file.getParent();
        while (parent != null && !parent.getName().equals("gems")) {
            file = parent;
            parent = file.getParent();
        }
        if (parent == null) {
            return null;
        }
        int delimiterPos = file.getName().lastIndexOf("-");
        if (delimiterPos > 0) {
            return file.getName().substring(0, delimiterPos);
        }
        return null;
    }

    public static boolean enabledStepDefinition(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(17);
        }
        if ((file = element.getContainingFile().getVirtualFile()) == null) {
            return false;
        }
        String gemName = CucumberUtil.getGemName(file);
        return gemName == null || CucumberRubySettings.getInstance().getGemsToImportStepDefs().contains(gemName);
    }

    public static String processExpressionOrOperator(@NotNull String cucumberExpression) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(18);
        }
        cucumberExpression = org.jetbrains.plugins.cucumber.CucumberUtil.replaceNotNecessaryTextTemplateByRegexp((String)cucumberExpression);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < cucumberExpression.length(); ++i) {
            char c = cucumberExpression.charAt(i);
            if (c == '/') {
                result.append('|');
                continue;
            }
            if (c == '|') {
                result.append("\\|");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/CucumberUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinition";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepPattern";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/CucumberUtil";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberScriptSupportInstalledInRailsProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRailsCucumberScriptExecutablePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderStepDefinitionsRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberRailsSupportProbablyEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberSupportEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedCucumberGem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberGemExecutablePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentScenarioName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStepNameFromStepCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptiveName";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSameStepDefinitionList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberExpressionEnabled";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processCucumberExpressions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enabledStepDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processExpressionOrOperator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

