/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.codeinsight;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberParameterTypeSelfReference;
import org.jetbrains.plugins.ruby.cucumber.CucumberRubyParameterTypeReference;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyStringReferenceProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RStringLiteralBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class CucumberRubyStringReferenceProvider
implements RubyStringReferenceProvider {
    private static final Pattern PARAMETER_TYPE_PATTERN = Pattern.compile(".*(\\{[^}]+}).*");
    private static final String NAME_ASSOC_KEY = "name";

    public PsiReference[] getReferences(@NotNull RStringLiteralBase element) {
        RCall call;
        RAssoc assoc;
        RPossibleCall parentCall;
        if (element == null) {
            CucumberRubyStringReferenceProvider.$$$reportNull$$$0(0);
        }
        if (!CucumberUtil.isCucumberStepDefinition((PsiElement)(parentCall = (RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)element, RPossibleCall.class, (boolean)false))) && !CucumberUtil.isParameterTypeDeclaration((PsiElement)parentCall)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (element.getParent() instanceof RListOfExpressions) {
            if (((RListOfExpressions)element.getParent()).getFirstElement() != element) {
                return PsiReference.EMPTY_ARRAY;
            }
            RCall stepCall = CucumberUtil.getStepCall((PsiElement)element);
            if (stepCall == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            Matcher matcher = PARAMETER_TYPE_PATTERN.matcher(element.getText());
            ArrayList<CucumberRubyParameterTypeReference> result = new ArrayList<CucumberRubyParameterTypeReference>();
            if (!matcher.find()) {
                return result.toArray(PsiReference.EMPTY_ARRAY);
            }
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                int start = matcher.start(i);
                int end = matcher.end(i);
                CucumberRubyParameterTypeReference reference = new CucumberRubyParameterTypeReference((PsiElement)element, TextRange.create((int)(start + 1), (int)(end - 1)));
                result.add(reference);
            }
            return result.toArray(PsiReference.EMPTY_ARRAY);
        }
        if (element.getParent() instanceof RAssoc && element == (assoc = (RAssoc)element.getParent()).getValue() && StringUtil.equals((CharSequence)assoc.getKeyText(), (CharSequence)NAME_ASSOC_KEY) && CucumberUtil.isParameterTypeDeclaration((PsiElement)(call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class)))) {
            return new PsiReference[]{new CucumberParameterTypeSelfReference((PsiElement)element)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/cucumber/codeinsight/CucumberRubyStringReferenceProvider", "getReferences"));
    }
}

