/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;

public abstract class BaseCucumberRunConfigurationExternalizer
extends SettingsExternalizer {
    @NonNls
    public static final String CURRENT_SETTINGS_VERSION = "2";
    @NonNls
    private static final String CUCUMBER_ARGS = "CUCUMBER_ARGS";
    @NonNls
    private static final String RUNNER_VERSION = "RUNNER_VERSION";
    @NonNls
    private static final String TESTS_FOLDER_PATH = "TESTS_FOLDER_PATH";
    @NonNls
    private static final String TEST_SCRIPT_PATH = "TEST_SCRIPT_PATH";
    @NonNls
    private static final String TEST_TAGS_FILTER = "TEST_TAGS_FILTER";
    @NonNls
    private static final String TEST_NAME_FILTER = "TEST_NAME_FILTER";
    @NonNls
    private static final String TEST_FILE_MASK = "TEST_FILE_MASK";
    @NonNls
    private static final String TEST_TEST_TYPE = "TEST_TEST_TYPE";
    @NonNls
    private static final String FULL_BACKTRACE = "FULL_BACKTRACE";
    @NonNls
    private static final String VERBOSE_OPTION = "VERBOSE_OPTION";
    @NonNls
    private static final String DRB = "DRB";
    @NonNls
    private static final String ZEUS = "ZEUS";
    @NonNls
    private static final String SPRING = "SPRING";
    @NonNls
    private static final String CUCUMBER_RUNNER_PATH = "CUCUMBER_RUNNER_PATH";
    @NonNls
    private static final String USE_CUSTOM_RUNNER = "USE_CUSTOM_RUNNER";

    public void writeExternal(BaseCucumberRunConfiguration config, Element elem) {
        this.writeOption(TEST_FILE_MASK, config.getTestFileMask(), elem);
        this.writeOption(TEST_TEST_TYPE, config.getTestType().toString(), elem);
        this.writeOption(TESTS_FOLDER_PATH, config.getTestsFolderPath(), elem);
        this.writeOption(TEST_SCRIPT_PATH, config.getTestScriptPath(), elem);
        this.writeOption(TEST_TAGS_FILTER, config.getTagsFilters(), elem);
        this.writeOption(TEST_NAME_FILTER, config.getFeatureElementNameFilter(), elem);
        this.writeOption(CUCUMBER_ARGS, config.getRunnerOptions(), elem);
        this.writeOption(RUNNER_VERSION, config.getRunnerGemVersion(), elem);
        this.writeOption(FULL_BACKTRACE, String.valueOf(config.isBacktraceEnabled()), elem);
        this.writeOption(VERBOSE_OPTION, String.valueOf(config.isBacktraceEnabled()), elem);
        this.writeOption(DRB, String.valueOf(config.getPreloadServer() == PreLoadUtil.PreLoadServer.DRb), elem);
        this.writeOption(ZEUS, String.valueOf(config.getPreloadServer() == PreLoadUtil.PreLoadServer.Zeus), elem);
        this.writeOption(SPRING, String.valueOf(config.getPreloadServer() == PreLoadUtil.PreLoadServer.Spring), elem);
        this.writeOption(CUCUMBER_RUNNER_PATH, config.getCustomCucumberRunnerPath(), elem);
        this.writeOption(USE_CUSTOM_RUNNER, String.valueOf(config.shouldUseCustomCucumberRunner()), elem);
        this.writeCurrentVersion(elem, CURRENT_SETTINGS_VERSION);
    }

    public void readExternal(BaseCucumberRunConfiguration config, Element elem) {
        Map optionsByName = this.buildOptionsByElement(elem);
        config.setTestFileMask((String)optionsByName.get(TEST_FILE_MASK));
        String type_value = (String)optionsByName.get(TEST_TEST_TYPE);
        if (type_value != null) {
            config.setTestType(Enum.valueOf(AbstractRubyTestsRunConfigurationParams.TestType.class, type_value));
        }
        config.setTestsFolderPath((String)optionsByName.get(TESTS_FOLDER_PATH));
        config.setTestScriptPath((String)optionsByName.get(TEST_SCRIPT_PATH));
        config.setTagsFilter((String)optionsByName.get(TEST_TAGS_FILTER));
        config.setFeatureElementNameFilter((String)optionsByName.get(TEST_NAME_FILTER));
        config.setRunnerOptions((String)optionsByName.get(CUCUMBER_ARGS));
        config.setRunnerGemVersion((String)optionsByName.get(RUNNER_VERSION));
        config.setBacktraceEnabled(Boolean.valueOf((String)optionsByName.get(FULL_BACKTRACE)));
        config.setVerboseEnabled(Boolean.valueOf((String)optionsByName.get(VERBOSE_OPTION)));
        if (Boolean.valueOf((String)optionsByName.get(DRB)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.DRb);
        } else if (Boolean.valueOf((String)optionsByName.get(ZEUS)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.Zeus);
        } else if (Boolean.valueOf((String)optionsByName.get(SPRING)).booleanValue()) {
            config.setPreloadServer(PreLoadUtil.PreLoadServer.Spring);
        }
        config.setCustomCucumberRunnerPath((String)optionsByName.get(CUCUMBER_RUNNER_PATH));
        config.setShouldUseCustomCucumberRunner(Boolean.valueOf((String)optionsByName.get(USE_CUSTOM_RUNNER)));
    }
}

