/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.redmine;

import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.redmine.RedmineRepositoryType;
import com.intellij.tasks.redmine.RedmineTask;
import com.intellij.tasks.redmine.model.RedmineIssue;
import com.intellij.tasks.redmine.model.RedmineProject;
import com.intellij.tasks.redmine.model.RedmineResponseWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Redmine")
public class RedmineRepository
extends NewBaseRepositoryImpl {
    private static final Gson GSON = TaskGsonUtil.createDefaultBuilder().create();
    private static final Pattern ID_PATTERN = Pattern.compile("\\d+");
    private static final Logger LOG = Logger.getInstance(RedmineRepository.class);
    public static final RedmineProject UNSPECIFIED_PROJECT = RedmineRepository.createUnspecifiedProject();
    private String myAPIKey = "";
    private RedmineProject myCurrentProject;
    private boolean myAssignedToMe = true;
    private List<RedmineProject> myProjects = null;

    @NotNull
    private static RedmineProject createUnspecifiedProject() {
        RedmineProject unspecified = new RedmineProject(){

            @Override
            @NotNull
            public String getName() {
                if ("-- from all projects --" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "-- from all projects --";
            }

            @Override
            @Nullable
            public String getIdentifier() {
                return this.getName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineRepository$1", "getName"));
            }
        };
        unspecified.setId(-1);
        RedmineProject redmineProject = unspecified;
        if (redmineProject == null) {
            RedmineRepository.$$$reportNull$$$0(0);
        }
        return redmineProject;
    }

    public RedmineRepository() {
    }

    public RedmineRepository(RedmineRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUseHttpAuthentication(true);
    }

    public RedmineRepository(RedmineRepository other) {
        super(other);
        this.setAPIKey(other.myAPIKey);
        this.setCurrentProject(other.getCurrentProject());
        this.setAssignedToMe(other.isAssignedToMe());
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof RedmineRepository)) {
            return false;
        }
        RedmineRepository that = (RedmineRepository)((Object)o);
        if (!Comparing.equal((String)this.getAPIKey(), (String)that.getAPIKey())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getCurrentProject(), (Object)that.getCurrentProject())) {
            return false;
        }
        return this.isAssignedToMe() == that.isAssignedToMe();
    }

    @NotNull
    public RedmineRepository clone() {
        RedmineRepository redmineRepository = new RedmineRepository(this);
        if (redmineRepository == null) {
            RedmineRepository.$$$reportNull$$$0(1);
        }
        return redmineRepository;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void test() throws Exception {
                URIBuilder uriBuilder = RedmineRepository.this.createUriBuilderWithApiKey(new Object[]{"users", "current.json"});
                this.myCurrentRequest.setURI(uriBuilder.build());
                HttpClient client = RedmineRepository.this.getHttpClient();
                HttpResponse httpResponse = client.execute((HttpUriRequest)this.myCurrentRequest);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null && statusLine.getStatusCode() == 404) {
                    this.myCurrentRequest = new HttpGet(RedmineRepository.this.getProjectsUrl(0, 1));
                    statusLine = client.execute((HttpUriRequest)this.myCurrentRequest).getStatusLine();
                    if (statusLine != null && statusLine.getStatusCode() == 200) {
                        this.myCurrentRequest = new HttpGet(RedmineRepository.this.getIssuesUrl(0, 1, true));
                        statusLine = client.execute((HttpUriRequest)this.myCurrentRequest).getStatusLine();
                    }
                }
                if (statusLine != null && statusLine.getStatusCode() != 200) {
                    throw RequestFailedException.forStatusCode((int)statusLine.getStatusCode(), (String)statusLine.getReasonPhrase());
                }
            }
        };
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List<RedmineIssue> issues = this.fetchIssues(query, offset, limit, withClosed);
        List result = ContainerUtil.map(issues, issue -> new RedmineTask(this, (RedmineIssue)issue));
        if (query != null && ID_PATTERN.matcher(query).matches()) {
            LOG.debug("Query '" + query + "' looks like an issue ID. Requesting it explicitly from the server " + (Object)((Object)this));
            Task found = this.findTask(query);
            if (found != null) {
                result = ContainerUtil.append((List)result, (Object[])new Task[]{found});
            }
        }
        return (Task[])ArrayUtil.toObjectArray((Collection)result, Task.class);
    }

    public List<RedmineIssue> fetchIssues(String query, int offset, int limit, boolean withClosed) throws Exception {
        this.ensureProjectsDiscovered();
        HttpClient client = this.getHttpClient();
        HttpGet method = new HttpGet(this.getIssuesUrl(offset, limit, withClosed));
        RedmineResponseWrapper.IssuesWrapper wrapper = (RedmineResponseWrapper.IssuesWrapper)client.execute((HttpUriRequest)method, new TaskResponseUtil.GsonSingleObjectDeserializer<RedmineResponseWrapper.IssuesWrapper>(GSON, RedmineResponseWrapper.IssuesWrapper.class));
        return wrapper == null ? Collections.emptyList() : wrapper.getIssues();
    }

    private URI getIssuesUrl(int offset, int limit, boolean withClosed) throws URISyntaxException {
        URIBuilder builder = this.createUriBuilderWithApiKey("issues.json").addParameter("offset", String.valueOf(offset)).addParameter("limit", String.valueOf(limit)).addParameter("sort", "updated_on:desc").addParameter("status_id", withClosed ? "*" : "open");
        if (this.myAssignedToMe) {
            builder.addParameter("assigned_to_id", "me");
        }
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            builder.addParameter("project_id", String.valueOf(this.myCurrentProject.getId()));
        }
        return builder.build();
    }

    public List<RedmineProject> fetchProjects() throws Exception {
        RedmineResponseWrapper.ProjectsWrapper wrapper;
        HttpClient client = this.getHttpClient();
        ArrayList<RedmineProject> allProjects = new ArrayList<RedmineProject>();
        int offset = 0;
        do {
            HttpGet method = new HttpGet(this.getProjectsUrl(offset, 50));
            wrapper = (RedmineResponseWrapper.ProjectsWrapper)client.execute((HttpUriRequest)method, new TaskResponseUtil.GsonSingleObjectDeserializer<RedmineResponseWrapper.ProjectsWrapper>(GSON, RedmineResponseWrapper.ProjectsWrapper.class));
            offset += wrapper.getProjects().size();
            allProjects.addAll(wrapper.getProjects());
        } while (wrapper.getTotalCount() > allProjects.size() || wrapper.getProjects().isEmpty());
        this.myProjects = allProjects;
        return Collections.unmodifiableList(this.myProjects);
    }

    @NotNull
    private URI getProjectsUrl(int offset, int limit) throws URISyntaxException {
        URIBuilder builder = this.createUriBuilderWithApiKey("projects.json");
        builder.addParameter("offset", String.valueOf(offset));
        builder.addParameter("limit", String.valueOf(limit));
        URI uRI = builder.build();
        if (uRI == null) {
            RedmineRepository.$$$reportNull$$$0(2);
        }
        return uRI;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            RedmineRepository.$$$reportNull$$$0(3);
        }
        this.ensureProjectsDiscovered();
        HttpGet method = new HttpGet(this.createUriBuilderWithApiKey("issues", id + ".json").build());
        RedmineResponseWrapper.IssueWrapper wrapper = (RedmineResponseWrapper.IssueWrapper)this.getHttpClient().execute((HttpUriRequest)method, new TaskResponseUtil.GsonSingleObjectDeserializer<RedmineResponseWrapper.IssueWrapper>(GSON, RedmineResponseWrapper.IssueWrapper.class, true));
        if (wrapper == null) {
            return null;
        }
        return new RedmineTask(this, wrapper.getIssue());
    }

    public String getAPIKey() {
        return this.myAPIKey;
    }

    public void setAPIKey(String APIKey) {
        this.myAPIKey = APIKey;
    }

    public boolean isAssignedToMe() {
        return this.myAssignedToMe;
    }

    public void setAssignedToMe(boolean assignedToMe) {
        this.myAssignedToMe = assignedToMe;
    }

    private boolean isUseApiKeyAuthentication() {
        return !this.isUseHttpAuthentication() && StringUtil.isNotEmpty((String)this.myAPIKey);
    }

    @NotNull
    private URIBuilder createUriBuilderWithApiKey(Object ... pathParts) throws URISyntaxException {
        if (pathParts == null) {
            RedmineRepository.$$$reportNull$$$0(4);
        }
        URIBuilder builder = new URIBuilder(this.getRestApiUrl(pathParts));
        if (this.isUseApiKeyAuthentication()) {
            builder.addParameter("key", this.myAPIKey);
        }
        URIBuilder uRIBuilder = builder;
        if (uRIBuilder == null) {
            RedmineRepository.$$$reportNull$$$0(5);
        }
        return uRIBuilder;
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            name = name + "/projects/" + StringUtil.notNullize((String)this.myCurrentProject.getIdentifier(), (String)String.valueOf(this.myCurrentProject.getId()));
        }
        return name;
    }

    public boolean isConfigured() {
        if (!super.isConfigured()) {
            return false;
        }
        if (this.isUseHttpAuthentication()) {
            return StringUtil.isNotEmpty((String)this.myPassword) && StringUtil.isNotEmpty((String)this.myUsername);
        }
        return StringUtil.isNotEmpty((String)this.myAPIKey);
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        if (taskName == null) {
            RedmineRepository.$$$reportNull$$$0(6);
        }
        return ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF | 1;
    }

    @Nullable
    public RedmineProject getCurrentProject() {
        return this.myCurrentProject;
    }

    public void setCurrentProject(@Nullable RedmineProject project) {
        this.myCurrentProject = project != null && project.getId() == -1 ? UNSPECIFIED_PROJECT : project;
    }

    @NotNull
    public List<RedmineProject> getProjects() {
        try {
            this.ensureProjectsDiscovered();
        }
        catch (Exception ignored) {
            List<RedmineProject> list = Collections.emptyList();
            if (list == null) {
                RedmineRepository.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<RedmineProject> list = Collections.unmodifiableList(this.myProjects);
        if (list == null) {
            RedmineRepository.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void ensureProjectsDiscovered() throws Exception {
        if (this.myProjects == null) {
            this.fetchProjects();
        }
    }

    @Transient
    public void setProjects(@NotNull List<RedmineProject> projects) {
        if (projects == null) {
            RedmineRepository.$$$reportNull$$$0(9);
        }
        this.myProjects = projects;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/redmine/RedmineRepository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathParts";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnspecifiedProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsUrl";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/redmine/RedmineRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUriBuilderWithApiKey";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUriBuilderWithApiKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setProjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

