/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSHighlightingInfoBuilder {
    @NotNull
    public static JSFileHighlightingInfo createInfoWithUnSavedFiles(@NotNull Project project, @NotNull VirtualFile currentVirtualFile, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(0);
        }
        if (currentVirtualFile == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(1);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceUpdateContext context = JSHighlightingInfoBuilder.createUpdateContext(project, filesFilter);
        JSFileHighlightingInfo jSFileHighlightingInfo = new JSFileHighlightingInfo(currentVirtualFile, context);
        if (jSFileHighlightingInfo == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(3);
        }
        return jSFileHighlightingInfo;
    }

    @NotNull
    public static JSLanguageServiceUpdateContext createUpdateContext(@NotNull Project project, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(4);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap nameToUnsavedContent = ContainerUtil.newHashMap();
        HashMap nameToOpenContent = ContainerUtil.newHashMap();
        HashMap nameToTimestamps = ContainerUtil.newHashMap();
        JSHighlightingInfoBuilder.fillByUnsavedDocuments(project, nameToUnsavedContent, nameToTimestamps, filesFilter);
        JSHighlightingInfoBuilder.fillByOpenedEditors(project, nameToOpenContent, nameToTimestamps, filesFilter);
        JSLanguageServiceUpdateContext jSLanguageServiceUpdateContext = new JSLanguageServiceUpdateContext(nameToUnsavedContent, nameToOpenContent, nameToTimestamps);
        if (jSLanguageServiceUpdateContext == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(6);
        }
        return jSLanguageServiceUpdateContext;
    }

    private static void fillByOpenedEditors(@NotNull Project project, @NotNull Map<VirtualFile, Document> nameToContent, @NotNull Map<VirtualFile, Long> nameToTimestamps, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(7);
        }
        if (nameToContent == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(8);
        }
        if (nameToTimestamps == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(9);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(10);
        }
        Map<VirtualFile, Document> filteredFiles = JSHighlightingInfoBuilder.getFilteredOpenedFiles(project, filesFilter);
        for (Map.Entry<VirtualFile, Document> entry : filteredFiles.entrySet()) {
            VirtualFile processedOpenedFile = entry.getKey();
            Document document = entry.getValue();
            nameToContent.put(processedOpenedFile, document);
            if (nameToTimestamps.containsKey(processedOpenedFile)) continue;
            long processedStamp = JSHighlightingInfoBuilder.getTimestamp(processedOpenedFile, document);
            nameToTimestamps.put(processedOpenedFile, processedStamp);
        }
    }

    public static long getTimestamp(@NotNull VirtualFile openedFile, @NotNull Document document) {
        long processedDocumentModificationStamp;
        long processedStamp;
        if (openedFile == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(11);
        }
        if (document == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(12);
        }
        if ((processedStamp = openedFile.getModificationStamp()) < (processedDocumentModificationStamp = document.getModificationStamp())) {
            processedStamp = processedDocumentModificationStamp;
        }
        return processedStamp;
    }

    private static void fillByUnsavedDocuments(@NotNull Project project, @NotNull Map<VirtualFile, Document> nameToContent, @NotNull Map<VirtualFile, Long> nameToTimestamps, @NotNull Condition<VirtualFile> filter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(13);
        }
        if (nameToContent == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(14);
        }
        if (nameToTimestamps == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(15);
        }
        if (filter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(16);
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile virtualFile = manager.getFile(document);
            if (virtualFile == null || !filter.value((Object)virtualFile) || !scope.accept(virtualFile)) continue;
            nameToContent.put(virtualFile, document);
            nameToTimestamps.put(virtualFile, document.getModificationStamp());
        }
    }

    @NotNull
    public static Pair<String, String> getModuleInfo(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(18);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(file2);
        String contentRootPath = null;
        if (contentRoot != null) {
            contentRootPath = JSLanguageServiceUtil.normalizeNameAndPath(contentRoot.getPath());
        }
        VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(file2);
        String sourceRootPath = null;
        if (sourceRoot != null) {
            sourceRootPath = JSLanguageServiceUtil.normalizeNameAndPath(sourceRoot.getPath());
        }
        Pair pair = Pair.create((Object)contentRootPath, sourceRootPath);
        if (pair == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @NotNull
    public static String toPath(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(20);
        }
        String string = FileUtil.toSystemDependentName((String)configFile.getPath());
        if (string == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static Map<VirtualFile, Document> getFilteredOpenedFiles(@NotNull Project project, @NotNull Condition<? super VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(22);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap filesToOpen = ContainerUtil.newHashMap();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject != project || !(editor instanceof EditorEx) || editor.getProject() != editorProject || (vFile = ((EditorEx)editor).getVirtualFile()) == null || !filesFilter.value((Object)vFile)) continue;
            filesToOpen.put(vFile, editor.getDocument());
        }
        HashMap hashMap = filesToOpen;
        if (hashMap == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(24);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 19: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 19: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVirtualFile";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesFilter";
                break;
            }
            case 3: 
            case 6: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToContent";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToTimestamps";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openedFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoWithUnSavedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredOpenedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInfoWithUnSavedFiles";
                break;
            }
            case 3: 
            case 6: 
            case 19: 
            case 21: 
            case 24: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillByOpenedEditors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTimestamp";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillByUnsavedDocuments";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredOpenedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 19: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

