/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryKt;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n\u001a%\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0011\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"gist", "Lcom/intellij/util/gist/VirtualFileGist;", "", "getGist", "()Lcom/intellij/util/gist/VirtualFileGist;", "provider", "Lcom/intellij/util/gist/VirtualFileGist$GistCalculator;", "getProvider", "()Lcom/intellij/util/gist/VirtualFileGist$GistCalculator;", "getLibraryCandidate", "Lcom/intellij/lang/typescript/library/TypeScriptLibraries;", "project", "Lcom/intellij/openapi/project/Project;", "defaultLibraries", "isValidFile", "kotlin.jvm.PlatformType", "libDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "isValidLibraryFile", "file", "intellij.javascript.impl"})
public final class TypeScriptLibraryKt {
    @NotNull
    private static final VirtualFileGist.GistCalculator<Boolean> provider = provider.1.INSTANCE;
    @NotNull
    private static final VirtualFileGist<Boolean> gist;

    @NotNull
    public static final VirtualFileGist.GistCalculator<Boolean> getProvider() {
        return provider;
    }

    @NotNull
    public static final VirtualFileGist<Boolean> getGist() {
        return gist;
    }

    public static final boolean isValidLibraryFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return !PsiErrorElementUtil.hasErrors((Project)project, (VirtualFile)file2);
    }

    @NotNull
    public static final TypeScriptLibraries getLibraryCandidate(@NotNull Project project, @NotNull TypeScriptLibraries defaultLibraries) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)defaultLibraries, (String)"defaultLibraries");
        if (project.isDefault() || project.isDisposed()) {
            return defaultLibraries;
        }
        try {
            TypeScriptLibraries result2 = (TypeScriptLibraries)RecursionManager.doPreventingRecursion((Object)"ts.loading.libraries", (boolean)false, (Computable)new Computable<T>(project, defaultLibraries){
                final /* synthetic */ Project $project;
                final /* synthetic */ TypeScriptLibraries $defaultLibraries;

                @NotNull
                public final TypeScriptLibraries compute() {
                    TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = TypeScriptServiceDirectoryWatcher.getService(this.$project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeScriptServiceDirectoryWatcher, (String)"TypeScriptServiceDirecto\u2026tcher.getService(project)");
                    TypeScriptServiceDirectoryWatcher watcher = typeScriptServiceDirectoryWatcher;
                    String servicePath = watcher.getCachedCustomServiceDirectory();
                    CharSequence charSequence = servicePath;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)servicePath, (Object)watcher.getDefaultServicePath())) {
                        return this.$defaultLibraries;
                    }
                    File file2 = new File(servicePath);
                    if (!file2.exists() || !new File(file2, "lib.d.ts").exists()) {
                        return this.$defaultLibraries;
                    }
                    VirtualFile libDirectory = LocalFileSystem.getInstance().findFileByIoFile(file2);
                    if (libDirectory == null || !TypeScriptLibraryKt.access$isValidFile(this.$project, libDirectory).booleanValue()) {
                        return this.$defaultLibraries;
                    }
                    return new TypeScriptLibraries(file2, false);
                }
                {
                    this.$project = project;
                    this.$defaultLibraries = typeScriptLibraries;
                }
            });
            if (result2 == null) {
                Logger.getInstance(TypeScriptLibraryProvider.class).error("Infinite recursion in typescript #getLibraryCandidate");
                return defaultLibraries;
            }
            return result2;
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                throw (Throwable)ex;
            }
            Logger.getInstance(TypeScriptLibraryProvider.class).error("Error while processing typescript external libraries", (Throwable)ex);
            return new TypeScriptLibraries();
        }
    }

    private static final Boolean isValidFile(Project project, VirtualFile libDirectory) {
        return (Boolean)gist.getFileData(project, libDirectory);
    }

    static {
        VirtualFileGist virtualFileGist = GistManager.getInstance().newVirtualFileGist("typescript.library.validation.cache", 0, (DataExternalizer)BooleanDataDescriptor.INSTANCE, provider);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileGist, (String)"GistManager.getInstance(\u2026iptor.INSTANCE, provider)");
        gist = virtualFileGist;
    }

    public static final /* synthetic */ Boolean access$isValidFile(@NotNull Project project, @NotNull VirtualFile libDirectory) {
        return TypeScriptLibraryKt.isValidFile(project, libDirectory);
    }
}

