/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.nondbconst;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintView;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.ConfigureNonDbConstraintDlg;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.ConstraintDataSet;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.ContraintDisplayData;

public class ConfigureNonDbConstraintController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConfigureNonDbConstraintController.class);
    private ConfigureNonDbConstraintDlg _dlg;
    private ConstraintDataSet _constraintDataSet;
    private ConstraintView _constraintView;
    private TableFrameController _fkTable;
    private TableFrameController _pkTable;

    public ConfigureNonDbConstraintController(ConstraintView constraintView, TableFrameController fkTable, TableFrameController pkTable) {
        this._constraintView = constraintView;
        this._fkTable = fkTable;
        this._pkTable = pkTable;
        try {
            String fkTableName = fkTable.getTableInfo().getSimpleName();
            String pkTableName = pkTable.getTableInfo().getSimpleName();
            Window parent = SwingUtilities.windowForComponent(fkTable.getFrame());
            this._dlg = new ConfigureNonDbConstraintDlg(parent, fkTableName, pkTableName);
            this._constraintDataSet = new ConstraintDataSet(constraintView, fkTableName, pkTableName);
            this._dlg._table.show((IDataSet)this._constraintDataSet);
            this._dlg._txtContstrName.setText(constraintView.getData().getConstraintName());
            this.initCbos(fkTable, pkTable, constraintView);
            this._dlg._btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureNonDbConstraintController.this.onRemoveSelectedRow();
                }
            });
            this._dlg._btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureNonDbConstraintController.this.onAddColumns();
                }
            });
            this._dlg._btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureNonDbConstraintController.this.onOk();
                }
            });
            this._dlg._btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureNonDbConstraintController.this.close();
                }
            });
            this._dlg.setVisible(true);
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void onOk() {
        if (this._constraintDataSet.isEmpty()) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("graph.ConfigureNonDbConstraintController.emptyMsg"));
            return;
        }
        if (null == this._dlg._txtContstrName.getText() || 0 == this._dlg._txtContstrName.getText().trim().length()) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("graph.ConfigureNonDbConstraintController.noNameMsg"));
            return;
        }
        this._constraintDataSet.writeConstraintView(this._constraintView, this._fkTable, this._pkTable);
        this._constraintView.getData().setConstraintName(this._dlg._txtContstrName.getText().trim());
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private void onAddColumns() {
        try {
            ColumnInfo fkColumn = (ColumnInfo)this._dlg._cboFkCol.getSelectedItem();
            ColumnInfo pkColumn = (ColumnInfo)this._dlg._cboPkCol.getSelectedItem();
            if (null == fkColumn || null == pkColumn) {
                return;
            }
            this.removeFromCbo(fkColumn, this._dlg._cboFkCol);
            this.removeFromCbo(pkColumn, this._dlg._cboPkCol);
            this._constraintDataSet.addRow(fkColumn, pkColumn);
            this._dlg._table.show((IDataSet)this._constraintDataSet);
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeFromCbo(ColumnInfo col, JComboBox cbo) {
        if (null == col) {
            return;
        }
        ((DefaultComboBoxModel)cbo.getModel()).removeElement(col);
        if (0 < cbo.getItemCount()) {
            cbo.setSelectedIndex(0);
        }
    }

    private void onRemoveSelectedRow() {
        try {
            ArrayList<ContraintDisplayData> displayDatas = this._constraintDataSet.removeRows(this._dlg._table.getSeletedModelRows());
            if (0 < displayDatas.size()) {
                this._dlg._table.show((IDataSet)this._constraintDataSet);
            }
            for (ContraintDisplayData displayData : displayDatas) {
                ((DefaultComboBoxModel)this._dlg._cboFkCol.getModel()).addElement(displayData.getFkCol());
                ((DefaultComboBoxModel)this._dlg._cboPkCol.getModel()).addElement(displayData.getPkCol());
            }
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void initCbos(TableFrameController fkTable, TableFrameController pkTable, ConstraintView constraintView) {
        this._dlg._cboFkCol.setModel(new DefaultComboBoxModel<ColumnInfo>(this.getUnused(fkTable.getColumnInfos(), constraintView.getData().getFkColumnInfos())));
        this._dlg._cboPkCol.setModel(new DefaultComboBoxModel<ColumnInfo>(this.getUnused(pkTable.getColumnInfos(), constraintView.getData().getPkColumnInfos())));
    }

    private ColumnInfo[] getUnused(ColumnInfo[] all, ColumnInfo[] used) {
        ArrayList<ColumnInfo> ret = new ArrayList<ColumnInfo>();
        ret.addAll(Arrays.asList(all));
        ret.removeAll(Arrays.asList(used));
        return ret.toArray(new ColumnInfo[ret.size()]);
    }
}

